/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtils;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class DataFlowUtils {
    private DataFlowUtils() {
    }

    @NotNull
    public static DataFlowInfo extractDataFlowInfoFromCondition(@Nullable JetExpression condition2, final boolean conditionValue, final ExpressionTypingContext context2) {
        if (condition2 == null) {
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "extractDataFlowInfoFromCondition"));
            }
            return dataFlowInfo;
        }
        final Ref result2 = new Ref(null);
        condition2.accept(new JetVisitorVoid(){

            @Override
            public void visitIsExpression(@NotNull JetIsExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils$1", "visitIsExpression"));
                }
                if (conditionValue && !expression2.isNegated() || !conditionValue && expression2.isNegated()) {
                    result2.set((Object)context2.trace.get(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression2));
                }
            }

            @Override
            public void visitBinaryExpression(@NotNull JetBinaryExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils$1", "visitBinaryExpression"));
                }
                IElementType operationToken = expression2.getOperationToken();
                if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey((Object)operationToken)) {
                    DataFlowInfo dataFlowInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expression2.getLeft(), conditionValue, context2);
                    JetExpression expressionRight = expression2.getRight();
                    if (expressionRight != null) {
                        DataFlowInfo rightInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expressionRight, conditionValue, context2);
                        boolean and = operationToken == JetTokens.ANDAND;
                        dataFlowInfo = and == conditionValue ? dataFlowInfo.and(rightInfo) : dataFlowInfo.or(rightInfo);
                    }
                    result2.set((Object)dataFlowInfo);
                } else {
                    JetExpression left = expression2.getLeft();
                    if (left == null) {
                        return;
                    }
                    JetExpression right = expression2.getRight();
                    if (right == null) {
                        return;
                    }
                    JetType lhsType = context2.trace.getBindingContext().getType(left);
                    if (lhsType == null) {
                        return;
                    }
                    JetType rhsType = context2.trace.getBindingContext().getType(right);
                    if (rhsType == null) {
                        return;
                    }
                    DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, lhsType, context2);
                    DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rhsType, context2);
                    Boolean equals = null;
                    if (operationToken == JetTokens.EQEQ || operationToken == JetTokens.EQEQEQ) {
                        equals = true;
                    } else if (operationToken == JetTokens.EXCLEQ || operationToken == JetTokens.EXCLEQEQEQ) {
                        equals = false;
                    }
                    if (equals != null) {
                        if (equals == conditionValue) {
                            result2.set((Object)context2.dataFlowInfo.equate(leftValue, rightValue));
                        } else {
                            result2.set((Object)context2.dataFlowInfo.disequate(leftValue, rightValue));
                        }
                    }
                }
            }

            @Override
            public void visitUnaryExpression(@NotNull JetUnaryExpression expression2) {
                JetExpression baseExpression;
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils$1", "visitUnaryExpression"));
                }
                IElementType operationTokenType = expression2.getOperationReference().getReferencedNameElementType();
                if (operationTokenType == JetTokens.EXCL && (baseExpression = expression2.getBaseExpression()) != null) {
                    result2.set((Object)DataFlowUtils.extractDataFlowInfoFromCondition(baseExpression, !conditionValue, context2));
                }
            }

            @Override
            public void visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils$1", "visitParenthesizedExpression"));
                }
                JetExpression body2 = expression2.getExpression();
                if (body2 != null) {
                    body2.accept(this);
                }
            }
        });
        if (result2.get() == null) {
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "extractDataFlowInfoFromCondition"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo.and((DataFlowInfo)result2.get());
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "extractDataFlowInfoFromCondition"));
        }
        return dataFlowInfo;
    }

    @Nullable
    public static JetType checkType(@Nullable JetType expressionType, @NotNull JetExpression expression2, @NotNull ResolutionContext context2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkType"));
        }
        return DataFlowUtils.checkType(expressionType, expression2, context2, null);
    }

    @NotNull
    public static JetTypeInfo checkType(@NotNull JetTypeInfo typeInfo, @NotNull JetExpression expression2, @NotNull ResolutionContext context2) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkType"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkType"));
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(DataFlowUtils.checkType(typeInfo.getType(), expression2, context2));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkType"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public static JetType checkType(@Nullable JetType expressionType, @NotNull JetExpression expressionToCheck, @NotNull ResolutionContext c, @Nullable Ref<Boolean> hasError) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkType"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkType"));
        }
        if (hasError != null) {
            hasError.set((Object)false);
        }
        JetExpression expression2 = JetPsiUtil.safeDeparenthesize(expressionToCheck, false);
        DataFlowUtils.recordExpectedType(c.trace, expression2, c.expectedType);
        if (expressionType == null) {
            return null;
        }
        c.additionalTypeChecker.checkType(expression2, expressionType, c);
        if (TypeUtils.noExpectedType(c.expectedType) || !c.expectedType.getConstructor().isDenotable() || JetTypeChecker.DEFAULT.isSubtypeOf(expressionType, c.expectedType)) {
            return expressionType;
        }
        if (expression2 instanceof JetConstantExpression) {
            CompileTimeConstant<?> value2 = ConstantExpressionEvaluator.evaluate(expression2, c.trace, c.expectedType);
            if (value2 instanceof IntegerValueTypeConstant) {
                value2 = EvaluatePackage.createCompileTimeConstantWithType((IntegerValueTypeConstant)value2, c.expectedType);
            }
            boolean error = new CompileTimeConstantChecker(c.trace, true).checkConstantExpressionType(value2, (JetConstantExpression)expression2, c.expectedType);
            if (hasError != null) {
                hasError.set((Object)error);
            }
            return expressionType;
        }
        if (expression2 instanceof JetWhenExpression) {
            return expressionType;
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, expressionType, c);
        for (JetType possibleType : c.dataFlowInfo.getPossibleTypes(dataFlowValue)) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(possibleType, c.expectedType)) continue;
            SmartCastUtils.recordCastOrError(expression2, possibleType, c.trace, dataFlowValue.isPredictable(), false);
            return possibleType;
        }
        c.trace.report(Errors.TYPE_MISMATCH.on(expression2, c.expectedType, expressionType));
        if (hasError != null) {
            hasError.set((Object)true);
        }
        return expressionType;
    }

    public static void recordExpectedType(@NotNull BindingTrace trace, @NotNull JetExpression expression2, @NotNull JetType expectedType) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "recordExpectedType"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "recordExpectedType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "recordExpectedType"));
        }
        if (expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            JetType normalizeExpectedType = expectedType == TypeUtils.UNIT_EXPECTED_TYPE ? KotlinBuiltIns.getInstance().getUnitType() : expectedType;
            trace.record(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2, normalizeExpectedType);
        }
    }

    @Nullable
    public static JetType checkStatementType(@NotNull JetExpression expression2, @NotNull ResolutionContext context2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkStatementType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkStatementType"));
        }
        if (!(TypeUtils.noExpectedType(context2.expectedType) || KotlinBuiltIns.isUnit(context2.expectedType) || context2.expectedType.isError())) {
            context2.trace.report(Errors.EXPECTED_TYPE_MISMATCH.on(expression2, context2.expectedType));
            return null;
        }
        return KotlinBuiltIns.getInstance().getUnitType();
    }

    @Nullable
    public static JetType checkImplicitCast(@Nullable JetType expressionType, @NotNull JetExpression expression2, @NotNull ResolutionContext context2, boolean isStatement) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        if (expressionType != null && context2.expectedType == TypeUtils.NO_EXPECTED_TYPE && context2.contextDependency == ContextDependency.INDEPENDENT && !isStatement && (KotlinBuiltIns.isUnit(expressionType) || KotlinBuiltIns.isAnyOrNullableAny(expressionType)) && !TypesPackage.isDynamic(expressionType)) {
            context2.trace.report(Errors.IMPLICIT_CAST_TO_UNIT_OR_ANY.on(expression2, expressionType));
        }
        return expressionType;
    }

    @NotNull
    public static JetTypeInfo checkImplicitCast(@NotNull JetTypeInfo typeInfo, @NotNull JetExpression expression2, @NotNull ResolutionContext context2, boolean isStatement) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(DataFlowUtils.checkImplicitCast(typeInfo.getType(), expression2, context2, isStatement));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public static JetTypeInfo illegalStatementType(@NotNull JetExpression expression2, @NotNull ExpressionTypingContext context2, @NotNull ExpressionTypingInternals facade) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "illegalStatementType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "illegalStatementType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "illegalStatementType"));
        }
        facade.checkStatementType(expression2, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        context2.trace.report(Errors.EXPRESSION_EXPECTED.on(expression2, expression2));
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "illegalStatementType"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public static Collection<JetType> getAllPossibleTypes(@NotNull JetExpression expression2, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType type2, @NotNull ResolutionContext c) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, type2, c);
        HashSet possibleTypes = Sets.newHashSet((Object[])new JetType[]{type2});
        if (dataFlowValue.isPredictable()) {
            possibleTypes.addAll(dataFlowInfo.getPossibleTypes(dataFlowValue));
        }
        HashSet hashSet = possibleTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        return hashSet;
    }
}

