/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetSingleValueToken;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;

public class OperatorConventions {
    public static final Name EQUALS = Name.identifier("equals");
    public static final Name IDENTITY_EQUALS = Name.identifier("identityEquals");
    public static final Name COMPARE_TO = Name.identifier("compareTo");
    public static final Name CONTAINS = Name.identifier("contains");
    public static final Name INVOKE = Name.identifier("invoke");
    public static final Name DOUBLE = Name.identifier("toDouble");
    public static final Name FLOAT = Name.identifier("toFloat");
    public static final Name LONG = Name.identifier("toLong");
    public static final Name INT = Name.identifier("toInt");
    public static final Name CHAR = Name.identifier("toChar");
    public static final Name SHORT = Name.identifier("toShort");
    public static final Name BYTE = Name.identifier("toByte");
    public static final ImmutableSet<Name> NUMBER_CONVERSIONS = ImmutableSet.of((Object)DOUBLE, (Object)FLOAT, (Object)LONG, (Object)INT, (Object)SHORT, (Object)BYTE, (Object[])new Name[]{CHAR});
    public static final ImmutableBiMap<JetSingleValueToken, Name> UNARY_OPERATION_NAMES = ImmutableBiMap.builder().put((Object)JetTokens.PLUSPLUS, (Object)Name.identifier("inc")).put((Object)JetTokens.MINUSMINUS, (Object)Name.identifier("dec")).put((Object)JetTokens.PLUS, (Object)Name.identifier("plus")).put((Object)JetTokens.MINUS, (Object)Name.identifier("minus")).put((Object)JetTokens.EXCL, (Object)Name.identifier("not")).build();
    public static final ImmutableBiMap<JetSingleValueToken, Name> BINARY_OPERATION_NAMES = ImmutableBiMap.builder().put((Object)JetTokens.MUL, (Object)Name.identifier("times")).put((Object)JetTokens.PLUS, (Object)Name.identifier("plus")).put((Object)JetTokens.MINUS, (Object)Name.identifier("minus")).put((Object)JetTokens.DIV, (Object)Name.identifier("div")).put((Object)JetTokens.PERC, (Object)Name.identifier("mod")).put((Object)JetTokens.RANGE, (Object)Name.identifier("rangeTo")).build();
    public static final ImmutableSet<JetSingleValueToken> NOT_OVERLOADABLE = ImmutableSet.of((Object)((Object)JetTokens.ANDAND), (Object)((Object)JetTokens.OROR), (Object)((Object)JetTokens.ELVIS), (Object)((Object)JetTokens.EQEQEQ), (Object)((Object)JetTokens.EXCLEQEQEQ));
    public static final ImmutableSet<JetSingleValueToken> INCREMENT_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.PLUSPLUS), (Object)((Object)JetTokens.MINUSMINUS));
    public static final ImmutableSet<JetSingleValueToken> COMPARISON_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.LT), (Object)((Object)JetTokens.GT), (Object)((Object)JetTokens.LTEQ), (Object)((Object)JetTokens.GTEQ));
    public static final ImmutableSet<JetSingleValueToken> EQUALS_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.EQEQ), (Object)((Object)JetTokens.EXCLEQ));
    public static final ImmutableSet<JetSingleValueToken> IDENTITY_EQUALS_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.EQEQEQ), (Object)((Object)JetTokens.EXCLEQEQEQ));
    public static final ImmutableSet<JetSingleValueToken> IN_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.IN_KEYWORD), (Object)((Object)JetTokens.NOT_IN));
    public static final ImmutableBiMap<JetSingleValueToken, Name> ASSIGNMENT_OPERATIONS = ImmutableBiMap.builder().put((Object)JetTokens.MULTEQ, (Object)Name.identifier("timesAssign")).put((Object)JetTokens.DIVEQ, (Object)Name.identifier("divAssign")).put((Object)JetTokens.PERCEQ, (Object)Name.identifier("modAssign")).put((Object)JetTokens.PLUSEQ, (Object)Name.identifier("plusAssign")).put((Object)JetTokens.MINUSEQ, (Object)Name.identifier("minusAssign")).build();
    public static final ImmutableBiMap<JetSingleValueToken, JetSingleValueToken> ASSIGNMENT_OPERATION_COUNTERPARTS = ImmutableBiMap.builder().put((Object)JetTokens.MULTEQ, (Object)JetTokens.MUL).put((Object)JetTokens.DIVEQ, (Object)JetTokens.DIV).put((Object)JetTokens.PERCEQ, (Object)JetTokens.PERC).put((Object)JetTokens.PLUSEQ, (Object)JetTokens.PLUS).put((Object)JetTokens.MINUSEQ, (Object)JetTokens.MINUS).build();
    public static final ImmutableBiMap<JetSingleValueToken, Name> BOOLEAN_OPERATIONS = ImmutableBiMap.builder().put((Object)JetTokens.ANDAND, (Object)Name.identifier("and")).put((Object)JetTokens.OROR, (Object)Name.identifier("or")).build();

    private OperatorConventions() {
    }

    @Nullable
    public static Name getNameForOperationSymbol(@NotNull JetToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/types/expressions/OperatorConventions", "getNameForOperationSymbol"));
        }
        Name name2 = (Name)UNARY_OPERATION_NAMES.get((Object)token);
        if (name2 != null) {
            return name2;
        }
        name2 = (Name)BINARY_OPERATION_NAMES.get((Object)token);
        if (name2 != null) {
            return name2;
        }
        name2 = (Name)ASSIGNMENT_OPERATIONS.get((Object)token);
        if (name2 != null) {
            return name2;
        }
        if (COMPARISON_OPERATIONS.contains((Object)token)) {
            return COMPARE_TO;
        }
        if (EQUALS_OPERATIONS.contains((Object)token)) {
            return EQUALS;
        }
        if (IN_OPERATIONS.contains((Object)token)) {
            return CONTAINS;
        }
        return null;
    }
}

