/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"I\u0006)Q2+\u001a8tK2,7o]\"p[B\f'/[:p]\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0003usB,7OC\u0006fqB\u0014Xm]:j_:\u001c(bA!os*\u00013\r[3dWN+gn]3mKN\u001c8i\\7qCJL7o\u001c8XSRDg*\u001e7m\u0015))\u0007\u0010\u001d:fgNLwN\u001c\u0006\u0014\u0015\u0016$()\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0004aNL'\u0002\u00027fMRTQBS3u\u000bb\u0004(/Z:tS>t'\"\u0002:jO\"$(bB2p]R,\u0007\u0010\u001e\u0006\u0012%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$(b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\bO\u0016$H+\u001f9f\u0015%1UO\\2uS>t\u0017GC\u0004KKR$\u0016\u0010]3\u000b\u001d\u001d,GOT;mY\u0006\u0014\u0017\u000e\\5us*iA)\u0019;b\r2|wOV1mk\u0016T!b]7beR\u001c\u0017m\u001d;t\u0015-qU\u000f\u001c7bE&d\u0017\u000e^=\u000b\tUs\u0017\u000e\u001e\u0006\u0004UZl'\"\u00034v]\u000e$\u0018n\u001c8te\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)!\u0001B\u0001\t\u000b\u0015\u0019A\u0001\u0002E\u0005\u0019\u0001)1\u0001\u0002\u0003\t\r1\u0001QA\u0001\u0003\u0002\u0011!)!\u0001b\u0003\t\u0012\u0015\u0011AA\u0002\u0005\b\u000b\r!i\u0001c\u0004\r\u0001\u0015\u0019Aa\u0001E\n\u0019\u0001)1\u0001b\u0001\t\u00151\u0001QA\u0001\u0003\u0007\u0011/)1\u0001\"\u0005\t\u00171\u0001Qa\u0001C\t\u00111a\u0001!B\u0002\u0005\u0007!eA\u0002A\u0003\u0003\t\u0011AI!\u0002\u0002\u0005\t!1QA\u0001C\u0007\u0011\u001f)!\u0001B\u0002\t\u001b\u0015\u0011A\u0001\u0004E\u000e\u000b\t!I\u0002c\u0005\u0005A\u0006a)!\u0007\u0002\u0006\u0003!\u001dQ66\u0001\u0005\u0002a\u001dQT\u0002\u0003\u0001\u0011\u0011i!!B\u0001\t\nA\u001b\u0001!(\u0004\u0005\u0001!-QBA\u0003\u0002\u0011\u0015\u00016\u0011AO\u0007\t\u0001Ai!\u0004\u0002\u0006\u0003!)\u0001kA\u0001\u001e\u0012\u0011\u0001\u0001bB\u0007\u0005\u000b\u0005Aq!C\u0001\u0005\u0004A\u001b\u0019!h\b\u0005\u0001!IQbC\u0003\u0002\u0011\u001fI1!\u0003\u0002\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005A\u0001\u0002$\u0001Q\u0007\tij\u0002\u0002\u0001\t\u00165QQ!\u0001E\b\u0013\rI!!B\u0001\t\u0013%\u0019\u0011BA\u0003\u0002\u0011'\u00016QA\u0011\u0003\u000b\u0005A!\"U\u0002\u0010\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003!UQ\"\u0001\u0005\f\u001b\u0005A1\"D\u0001\t\u00185\t\u0001\"D\u0007\u0002\u00115)\u0004\u0001"})
public final class SenselessComparisonChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final SenselessComparisonChecker INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(SenselessComparisonChecker.class);
        new SenselessComparisonChecker();
    }

    @platformStatic
    public static final void checkSenselessComparisonWithNull(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression2, @JetValueParameter(name="left") @NotNull JetExpression left, @JetValueParameter(name="right") @NotNull JetExpression right, @JetValueParameter(name="context") @NotNull ResolutionContext<?> context2, @JetValueParameter(name="getType") @NotNull Function1<? super JetExpression, ? extends JetType> getType2, @JetValueParameter(name="getNullability") @NotNull Function1<? super DataFlowValue, ? extends Nullability> getNullability) {
        boolean bl;
        JetExpression jetExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        Intrinsics.checkParameterIsNotNull(context2, (String)"context");
        Intrinsics.checkParameterIsNotNull(getType2, (String)"getType");
        Intrinsics.checkParameterIsNotNull(getNullability, (String)"getNullability");
        if (JetPsiUtil.isNullConstant(left)) {
            jetExpression = right;
        } else if (JetPsiUtil.isNullConstant(right)) {
            jetExpression = left;
        } else {
            return;
        }
        JetExpression expr = jetExpression;
        JetType type2 = (JetType)getType2.invoke((Object)expr);
        if (type2 == null || type2.isError()) {
            return;
        }
        JetSimpleNameExpression operationSign = expression2.getOperationReference();
        DataFlowValue value2 = DataFlowValueFactory.createDataFlowValue(expr, type2, context2);
        boolean equality = Intrinsics.areEqual((Object)operationSign.getReferencedNameElementType(), (Object)((Object)JetTokens.EQEQ)) || Intrinsics.areEqual((Object)operationSign.getReferencedNameElementType(), (Object)((Object)JetTokens.EQEQEQ));
        DataFlowValue dataFlowValue = value2;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowValue, (String)"value");
        Nullability nullability = (Nullability)((Object)getNullability.invoke((Object)dataFlowValue));
        if (Intrinsics.areEqual((Object)((Object)nullability), (Object)((Object)Nullability.NULL))) {
            bl = equality;
        } else if (Intrinsics.areEqual((Object)((Object)nullability), (Object)((Object)Nullability.NOT_NULL))) {
            bl = !equality;
        } else if (Intrinsics.areEqual((Object)((Object)nullability), (Object)((Object)Nullability.IMPOSSIBLE))) {
            bl = false;
        } else {
            return;
        }
        boolean expressionIsAlways = bl;
        context2.trace.report(Errors.SENSELESS_COMPARISON.on((JetBinaryExpression)((PsiElement)expression2), expression2, expressionIsAlways));
    }

    SenselessComparisonChecker() {
        INSTANCE$ = this;
    }
}

