/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinPackage$AbstractBinaryClassAnnotationAndConstantLoader$15372af3;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MemberSignature;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.Flags;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBinaryClassAnnotationAndConstantLoader<A, C>
implements AnnotationAndConstantLoader<A, C> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Storage<A, C>> storage;
    private final KotlinClassFinder kotlinClassFinder;
    private final ErrorReporter errorReporter;

    static {
        $kotlinClass = Reflection.createKotlinClass(AbstractBinaryClassAnnotationAndConstantLoader.class);
    }

    @Nullable
    protected abstract C loadConstant(@JetValueParameter(name="desc") @NotNull String var1, @JetValueParameter(name="initializer") @NotNull Object var2);

    @Nullable
    protected abstract KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@JetValueParameter(name="annotationClassId") @NotNull ClassId var1, @JetValueParameter(name="result") @NotNull List<A> var2);

    @NotNull
    protected abstract A loadTypeAnnotation(@JetValueParameter(name="proto") @NotNull ProtoBuf.Annotation var1, @JetValueParameter(name="nameResolver") @NotNull NameResolver var2);

    private final KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotationIfNotSpecial(@JetValueParameter(name="annotationClassId") ClassId annotationClassId, @JetValueParameter(name="result") List<A> result) {
        if (JvmAnnotationNames.isSpecialAnnotation(annotationClassId, true)) {
            return null;
        }
        return this.loadAnnotation(annotationClassId, result);
    }

    @Override
    @NotNull
    public List<A> loadClassAnnotations(@JetValueParameter(name="classProto") @NotNull ProtoBuf.Class classProto, @JetValueParameter(name="nameResolver") @NotNull NameResolver nameResolver) {
        ClassId classId;
        Intrinsics.checkParameterIsNotNull(classProto, "classProto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        ClassId classId2 = classId = nameResolver.getClassId(classProto.getFqName());
        Intrinsics.checkExpressionValueIsNotNull(classId2, "classId");
        KotlinJvmBinaryClass kotlinClass = this.kotlinClassFinder.findKotlinClass(classId2);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading class annotations is not found: " + classId.asSingleFqName(), null);
            return KotlinPackage.listOf();
        }
        ArrayList result = new ArrayList(1);
        kotlinClass.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(this, result){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;
            final /* synthetic */ ArrayList $result;

            static {
                $kotlinClass = Reflection.createKotlinClass(loadClassAnnotations.1.class);
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@JetValueParameter(name="classId") @NotNull ClassId classId) {
                Intrinsics.checkParameterIsNotNull(classId, "classId");
                return AbstractBinaryClassAnnotationAndConstantLoader.access$loadAnnotationIfNotSpecial$0(this.this$0, classId, this.$result);
            }

            public void visitEnd() {
            }
            {
                this.this$0 = $outer;
                this.$result = $captured_local_variable$1;
            }
        });
        return result;
    }

    @Override
    @NotNull
    public List<A> loadCallableAnnotations(@JetValueParameter(name="container") @NotNull ProtoContainer container, @JetValueParameter(name="proto") @NotNull ProtoBuf.Callable proto, @JetValueParameter(name="nameResolver") @NotNull NameResolver nameResolver, @JetValueParameter(name="kind") @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        MemberSignature memberSignature = KotlinPackage$AbstractBinaryClassAnnotationAndConstantLoader$15372af3.getCallableSignature(proto, nameResolver, kind);
        if (memberSignature == null) {
            return KotlinPackage.listOf();
        }
        MemberSignature signature = memberSignature;
        return this.findClassAndLoadMemberAnnotations(container, proto, nameResolver, kind, signature);
    }

    private final List<A> findClassAndLoadMemberAnnotations(@JetValueParameter(name="container") ProtoContainer container, @JetValueParameter(name="proto") ProtoBuf.Callable proto, @JetValueParameter(name="nameResolver") NameResolver nameResolver, @JetValueParameter(name="kind") AnnotatedCallableKind kind, @JetValueParameter(name="signature") MemberSignature signature) {
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, proto, nameResolver, kind);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading member annotations is not found: " + container.getFqName(nameResolver), null);
            return KotlinPackage.listOf();
        }
        List<Object> list = ((Storage)this.storage.invoke(kotlinClass)).getMemberAnnotations().get(signature);
        if (list == null) {
            list = KotlinPackage.listOf();
        }
        return list;
    }

    @Override
    @NotNull
    public List<A> loadValueParameterAnnotations(@JetValueParameter(name="container") @NotNull ProtoContainer container, @JetValueParameter(name="callable") @NotNull ProtoBuf.Callable callable, @JetValueParameter(name="nameResolver") @NotNull NameResolver nameResolver, @JetValueParameter(name="kind") @NotNull AnnotatedCallableKind kind, @JetValueParameter(name="proto") @NotNull ProtoBuf.Callable.ValueParameter proto) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        MemberSignature methodSignature = KotlinPackage$AbstractBinaryClassAnnotationAndConstantLoader$15372af3.getCallableSignature(callable, nameResolver, kind);
        if (methodSignature != null && proto.hasExtension(JvmProtoBuf.index)) {
            MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, ((Number)proto.getExtension(JvmProtoBuf.index)).intValue());
            return this.findClassAndLoadMemberAnnotations(container, callable, nameResolver, kind, paramSignature);
        }
        return KotlinPackage.listOf();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadTypeAnnotations(@JetValueParameter(name="type") @NotNull ProtoBuf.Type type2, @JetValueParameter(name="nameResolver") @NotNull NameResolver nameResolver) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable $receiver2 = type2.getExtension(JvmProtoBuf.typeAnnotation);
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item;
            void var9_9 = destination;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            A a = this.loadTypeAnnotation((ProtoBuf.Annotation)v0, nameResolver);
            var9_9.add(a);
        }
        return (List)destination;
    }

    @Override
    @Nullable
    public C loadPropertyConstant(@JetValueParameter(name="container") @NotNull ProtoContainer container, @JetValueParameter(name="proto") @NotNull ProtoBuf.Callable proto, @JetValueParameter(name="nameResolver") @NotNull NameResolver nameResolver, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        MemberSignature memberSignature = KotlinPackage$AbstractBinaryClassAnnotationAndConstantLoader$15372af3.getCallableSignature(proto, nameResolver, AnnotatedCallableKind.PROPERTY);
        if (memberSignature == null) {
            return null;
        }
        MemberSignature signature = memberSignature;
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, proto, nameResolver, AnnotatedCallableKind.PROPERTY);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading property constant is not found: " + container.getFqName(nameResolver), null);
            return null;
        }
        return ((Storage)this.storage.invoke(kotlinClass)).getPropertyConstants().get(signature);
    }

    private final KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(@JetValueParameter(name="container") ProtoContainer container, @JetValueParameter(name="proto") ProtoBuf.Callable proto, @JetValueParameter(name="nameResolver") NameResolver nameResolver, @JetValueParameter(name="annotatedCallableKind") AnnotatedCallableKind annotatedCallableKind) {
        FqName packageFqName = container.getPackageFqName();
        if (packageFqName != null) {
            return this.findPackagePartClass(packageFqName, proto, nameResolver);
        }
        ProtoBuf.Class clazz = container.getClassProto();
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        ProtoBuf.Class classProto = clazz;
        ProtoBuf.Class.Kind classKind = Flags.CLASS_KIND.get(classProto.getFlags());
        ClassId classId = nameResolver.getClassId(classProto.getFqName());
        if (Intrinsics.areEqual(classKind, ProtoBuf.Class.Kind.CLASS_OBJECT) && this.isStaticFieldInOuter(proto)) {
            ClassId classId2 = classId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull(classId2, "classId.getOuterClassId()");
            return this.kotlinClassFinder.findKotlinClass(classId2);
        }
        if (Intrinsics.areEqual(classKind, ProtoBuf.Class.Kind.TRAIT) && Intrinsics.areEqual((Object)annotatedCallableKind, (Object)AnnotatedCallableKind.PROPERTY)) {
            if (proto.hasExtension(JvmProtoBuf.implClassName)) {
                FqName parentPackageFqName = classId.getPackageFqName();
                Name tImplName = nameResolver.getName(((Number)proto.getExtension(JvmProtoBuf.implClassName)).intValue());
                return this.kotlinClassFinder.findKotlinClass(new ClassId(parentPackageFqName, tImplName));
            }
            return null;
        }
        ClassId classId3 = classId;
        Intrinsics.checkExpressionValueIsNotNull(classId3, "classId");
        return this.kotlinClassFinder.findKotlinClass(classId3);
    }

    private final KotlinJvmBinaryClass findPackagePartClass(@JetValueParameter(name="packageFqName") FqName packageFqName, @JetValueParameter(name="proto") ProtoBuf.Callable proto, @JetValueParameter(name="nameResolver") NameResolver nameResolver) {
        if (proto.hasExtension(JvmProtoBuf.implClassName)) {
            return this.kotlinClassFinder.findKotlinClass(new ClassId(packageFqName, nameResolver.getName(((Number)proto.getExtension(JvmProtoBuf.implClassName)).intValue())));
        }
        return null;
    }

    private final boolean isStaticFieldInOuter(@JetValueParameter(name="proto") ProtoBuf.Callable proto) {
        if (!proto.hasExtension(JvmProtoBuf.propertySignature)) {
            return false;
        }
        JvmProtoBuf.JvmPropertySignature propertySignature = proto.getExtension(JvmProtoBuf.propertySignature);
        return propertySignature.hasField() && propertySignature.getField().getIsStaticInOuter();
    }

    private final Storage<A, C> loadAnnotationsAndInitializers(@JetValueParameter(name="kotlinClass") KotlinJvmBinaryClass kotlinClass) {
        HashMap memberAnnotations = new HashMap();
        HashMap propertyConstants = new HashMap();
        kotlinClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(this, memberAnnotations, propertyConstants){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;
            final /* synthetic */ HashMap $memberAnnotations;
            final /* synthetic */ HashMap $propertyConstants;

            static {
                $kotlinClass = Reflection.createKotlinClass(loadAnnotationsAndInitializers.1.class);
            }

            @Nullable
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@JetValueParameter(name="name") @NotNull Name name, @JetValueParameter(name="desc") @NotNull String desc) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                Intrinsics.checkParameterIsNotNull(desc, "desc");
                return new loadAnnotationsAndInitializers.AnnotationVisitorForMethod(this, MemberSignature.Companion.fromMethodNameAndDesc(name.asString() + desc));
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@JetValueParameter(name="name") @NotNull Name name, @JetValueParameter(name="desc") @NotNull String desc, @JetValueParameter(name="initializer", type="?") @Nullable Object initializer) {
                C constant;
                Intrinsics.checkParameterIsNotNull(name, "name");
                Intrinsics.checkParameterIsNotNull(desc, "desc");
                MemberSignature signature = MemberSignature.Companion.fromFieldNameAndDesc(name, desc);
                if (initializer != null && (constant = this.this$0.loadConstant(desc, initializer)) != null) {
                    KotlinPackage.set(this.$propertyConstants, signature, constant);
                }
                return new loadAnnotationsAndInitializers.MemberAnnotationVisitor(this, signature);
            }
            {
                this.this$0 = $outer;
                this.$memberAnnotations = $captured_local_variable$1;
                this.$propertyConstants = $captured_local_variable$2;
            }
        });
        return new Storage(memberAnnotations, propertyConstants);
    }

    public AbstractBinaryClassAnnotationAndConstantLoader(@JetValueParameter(name="storageManager") @NotNull StorageManager storageManager, @JetValueParameter(name="kotlinClassFinder") @NotNull KotlinClassFinder kotlinClassFinder, @JetValueParameter(name="errorReporter") @NotNull ErrorReporter errorReporter) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(kotlinClassFinder, "kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull(errorReporter, "errorReporter");
        this.kotlinClassFinder = kotlinClassFinder;
        this.errorReporter = errorReporter;
        this.storage = storageManager.createMemoizedFunction(new Function1<KotlinJvmBinaryClass, Storage<A, C>>(this){
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;

            @NotNull
            public final Storage<A, C> invoke(@JetValueParameter(name="kotlinClass") @NotNull KotlinJvmBinaryClass kotlinClass) {
                Intrinsics.checkParameterIsNotNull(kotlinClass, "kotlinClass");
                return AbstractBinaryClassAnnotationAndConstantLoader.access$loadAnnotationsAndInitializers$1(this.this$0, kotlinClass);
            }
            {
                this.this$0 = abstractBinaryClassAnnotationAndConstantLoader;
                super(1);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor access$loadAnnotationIfNotSpecial$0(@JetValueParameter(name="$this", type="?") AbstractBinaryClassAnnotationAndConstantLoader<A, C> $this, @JetValueParameter(name="annotationClassId") @NotNull ClassId annotationClassId, @JetValueParameter(name="result") @NotNull List<A> result) {
        return super.loadAnnotationIfNotSpecial(annotationClassId, result);
    }

    @NotNull
    public static final /* synthetic */ Storage<A, C> access$loadAnnotationsAndInitializers$1(@JetValueParameter(name="$this", type="?") AbstractBinaryClassAnnotationAndConstantLoader<A, C> $this, @JetValueParameter(name="kotlinClass") @NotNull KotlinJvmBinaryClass kotlinClass) {
        return super.loadAnnotationsAndInitializers(kotlinClass);
    }

    private static final class Storage<A, C> {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Map<MemberSignature, ? extends List<? extends A>> memberAnnotations;
        @NotNull
        private final Map<MemberSignature, ? extends C> propertyConstants;

        static {
            $kotlinClass = Reflection.createKotlinClass(Storage.class);
        }

        @NotNull
        public final Map<MemberSignature, List<? extends A>> getMemberAnnotations() {
            return this.memberAnnotations;
        }

        @NotNull
        public final Map<MemberSignature, C> getPropertyConstants() {
            return this.propertyConstants;
        }

        public Storage(@JetValueParameter(name="memberAnnotations") @NotNull Map<MemberSignature, ? extends List<? extends A>> memberAnnotations, @JetValueParameter(name="propertyConstants") @NotNull Map<MemberSignature, ? extends C> propertyConstants) {
            Intrinsics.checkParameterIsNotNull(memberAnnotations, "memberAnnotations");
            Intrinsics.checkParameterIsNotNull(propertyConstants, "propertyConstants");
            this.memberAnnotations = memberAnnotations;
            this.propertyConstants = propertyConstants;
        }
    }
}

