/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlElement;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomModule;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsManagerWatcher;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModuleBuilderHelper {
    private final MavenId myProjectId;
    private final MavenProject myAggregatorProject;
    private final MavenProject myParentProject;
    private final boolean myInheritGroupId;
    private final boolean myInheritVersion;
    private final MavenArchetype myArchetype;
    private final Map<String, String> myPropertiesToCreateByArtifact;
    private final String myCommandName;

    public MavenModuleBuilderHelper(@NotNull MavenId projectId, MavenProject aggregatorProject, MavenProject parentProject, boolean inheritGroupId, boolean inheritVersion, MavenArchetype archetype, Map<String, String> propertiesToCreateByArtifact, String commaneName) {
        if (projectId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectId", "org/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper", "<init>"));
        }
        this.myProjectId = projectId;
        this.myAggregatorProject = aggregatorProject;
        this.myParentProject = parentProject;
        this.myInheritGroupId = inheritGroupId;
        this.myInheritVersion = inheritVersion;
        this.myArchetype = archetype;
        this.myPropertiesToCreateByArtifact = propertiesToCreateByArtifact;
        this.myCommandName = commaneName;
    }

    public void configure(final Project project, final VirtualFile root, final boolean isInteractive) {
        PsiFile[] psiFileArray;
        if (this.myAggregatorProject != null) {
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray = psiFileArray2;
            psiFileArray2[0] = MavenModuleBuilderHelper.getPsiFile(project, this.myAggregatorProject.getFile());
        } else {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFiles = psiFileArray;
        final VirtualFile pom = (VirtualFile)new WriteCommandAction<VirtualFile>(project, this.myCommandName, psiFiles){

            protected void run(Result<VirtualFile> result) throws Throwable {
                VirtualFile file;
                try {
                    file = root.createChildData((Object)this, "pom.xml");
                    MavenUtil.runOrApplyMavenProjectFileTemplate(project, file, MavenModuleBuilderHelper.this.myProjectId, isInteractive);
                    result.setResult((Object)file);
                }
                catch (IOException e) {
                    MavenModuleBuilderHelper.showError(project, e);
                    return;
                }
                MavenModuleBuilderHelper.this.updateProjectPom(project, file);
                if (MavenModuleBuilderHelper.this.myAggregatorProject != null) {
                    MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project, MavenModuleBuilderHelper.this.myAggregatorProject.getFile());
                    model.getPackaging().setStringValue("pom");
                    MavenDomModule module = model.getModules().addModule();
                    module.setValue(MavenModuleBuilderHelper.getPsiFile(project, file));
                }
            }
        }.execute().getResultObject();
        if (pom == null) {
            return;
        }
        if (this.myAggregatorProject == null) {
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
            manager.addManagedFilesOrUnignore(Collections.singletonList(pom));
        }
        if (this.myArchetype == null) {
            try {
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/java"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/resources"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/test/java"));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        MavenUtil.invokeLater(project, ModalityState.NON_MODAL, new Runnable(){

            @Override
            public void run() {
                if (!pom.isValid()) {
                    return;
                }
                EditorHelper.openInEditor((PsiElement)MavenModuleBuilderHelper.getPsiFile(project, pom));
                if (MavenModuleBuilderHelper.this.myArchetype != null) {
                    MavenModuleBuilderHelper.this.generateFromArchetype(project, pom);
                }
            }
        });
    }

    private void updateProjectPom(final Project project, final VirtualFile pom) {
        if (this.myParentProject == null) {
            return;
        }
        new WriteCommandAction.Simple(project, this.myCommandName, new PsiFile[0]){

            protected void run() throws Throwable {
                XmlElement el;
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project, pom);
                if (model == null) {
                    return;
                }
                MavenDomUtil.updateMavenParent(model, MavenModuleBuilderHelper.this.myParentProject);
                if (MavenModuleBuilderHelper.this.myInheritGroupId && (el = model.getGroupId().getXmlElement()) != null) {
                    el.delete();
                }
                if (MavenModuleBuilderHelper.this.myInheritVersion && (el = model.getVersion().getXmlElement()) != null) {
                    el.delete();
                }
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)MavenModuleBuilderHelper.getPsiFile(project, pom));
                pom.putUserData(MavenProjectsManagerWatcher.FORCE_IMPORT_AND_RESOLVE_ON_REFRESH, (Object)Boolean.TRUE);
                try {
                    Document doc = FileDocumentManager.getInstance().getDocument(pom);
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
                    FileDocumentManager.getInstance().saveDocument(doc);
                }
                finally {
                    pom.putUserData(MavenProjectsManagerWatcher.FORCE_IMPORT_AND_RESOLVE_ON_REFRESH, null);
                }
            }
        }.execute();
    }

    private static PsiFile getPsiFile(Project project, VirtualFile pom) {
        return PsiManager.getInstance((Project)project).findFile(pom);
    }

    private void generateFromArchetype(final Project project, final VirtualFile pom) {
        File workingDir;
        try {
            workingDir = FileUtil.createTempDirectory((String)"archetype", (String)"tmp");
            workingDir.deleteOnExit();
        }
        catch (IOException e) {
            MavenModuleBuilderHelper.showError(project, e);
            return;
        }
        MavenRunnerParameters params = new MavenRunnerParameters(false, workingDir.getPath(), Collections.singletonList("org.apache.maven.plugins:maven-archetype-plugin:RELEASE:generate"), Collections.<String>emptyList());
        MavenRunner runner = MavenRunner.getInstance(project);
        MavenRunnerSettings settings = runner.getState().clone();
        Map<String, String> props = settings.getMavenProperties();
        props.put("interactiveMode", "false");
        props.putAll(this.myPropertiesToCreateByArtifact);
        runner.run(params, settings, new Runnable(){

            @Override
            public void run() {
                MavenModuleBuilderHelper.this.copyGeneratedFiles(workingDir, pom, project);
            }
        });
    }

    private void copyGeneratedFiles(File workingDir, VirtualFile pom, Project project) {
        try {
            FileUtil.copyDir((File)new File(workingDir, this.myProjectId.getArtifactId()), (File)new File(pom.getParent().getPath()));
        }
        catch (IOException e) {
            MavenModuleBuilderHelper.showError(project, e);
            return;
        }
        FileUtil.delete((File)workingDir);
        pom.refresh(false, false);
        this.updateProjectPom(project, pom);
        LocalFileSystem.getInstance().refreshWithoutFileWatcher(true);
    }

    private static void showError(Project project, Throwable e) {
        MavenUtil.showError(project, "Failed to create a Maven project", e);
    }
}

