/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.psi.PsiElement;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.Nullable;

public class NavigateAction<T extends PsiElement>
extends AnAction {
    private LineMarkerInfo<T> myInfo;

    public NavigateAction(String text, LineMarkerInfo<T> info, @Nullable String originalActionId) {
        super(text);
        this.myInfo = info;
        if (originalActionId != null) {
            ShortcutSet set = ActionManager.getInstance().getAction(originalActionId).getShortcutSet();
            this.setShortcutSet(set);
        }
    }

    public NavigateAction(LineMarkerInfo<T> info) {
        this.myInfo = info;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        if (this.myInfo.getNavigationHandler() != null) {
            MouseEvent mouseEvent = (MouseEvent)e.getInputEvent();
            T element = this.myInfo.getElement();
            if (element == null || !element.isValid()) {
                return;
            }
            this.myInfo.getNavigationHandler().navigate(mouseEvent, element);
        }
    }

    public static <T extends PsiElement> LineMarkerInfo<T> setNavigateAction(LineMarkerInfo<T> info, String text, @Nullable String originalActionId) {
        NavigateAction<T> action = new NavigateAction<T>(text, info, originalActionId);
        info.setNavigateAction(action);
        return info;
    }
}

