/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import java.util.ArrayList;

public class CompilerTestUtil {
    private CompilerTestUtil() {
    }

    public static void setupJavacForTests(Project project) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance(project);
        compilerConfiguration.setDefaultCompiler((BackendCompiler)compilerConfiguration.getJavacCompiler());
    }

    public static void scanSourceRootsToRecompile(Project project) {
    }

    public static void saveApplicationSettings() {
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CompilerTestUtil.doSaveComponent(ProjectJdkTable.getInstance());
                CompilerTestUtil.doSaveComponent(FileTypeManager.getInstance());
            }
        }, ModalityState.any());
    }

    public static void saveApplicationComponent(final Object appComponent) {
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CompilerTestUtil.doSaveComponent(appComponent);
            }
        }, ModalityState.any());
    }

    private static void doSaveComponent(Object appComponent) {
        ((ComponentStoreImpl)((ApplicationImpl)ApplicationManager.getApplication()).getStateStore()).saveApplicationComponent(appComponent);
    }

    public static void enableExternalCompiler() {
        new WriteAction(){

            @Override
            protected void run(Result result) {
                ApplicationManagerEx.getApplicationEx().doNotSave(false);
                JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
                table.addJdk(table.getInternalJdk());
            }
        }.execute();
    }

    public static void disableExternalCompiler(final Project project) {
        new WriteAction(){

            @Override
            protected void run(Result result) {
                ApplicationManagerEx.getApplicationEx().doNotSave(true);
                Module[] modules = ModuleManager.getInstance(project).getModules();
                JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
                Sdk internalJdk = table.getInternalJdk();
                ArrayList<Module> modulesToRestore = new ArrayList<Module>();
                for (Module module : modules) {
                    Sdk sdk = ModuleRootManager.getInstance(module).getSdk();
                    if (sdk == null || !sdk.equals(internalJdk)) continue;
                    modulesToRestore.add(module);
                }
                table.removeJdk(internalJdk);
                for (Module module : modulesToRestore) {
                    ModuleRootModificationUtil.setModuleSdk(module, internalJdk);
                }
                BuildManager.getInstance().clearState(project);
            }
        }.execute();
    }
}

