/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeBuilderUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.TreeBuilderUtil");

    public static void storePaths(AbstractTreeBuilder treeBuilder, DefaultMutableTreeNode root, List<Object> pathsToExpand, List<Object> selectionPaths, boolean storeElementsOnly) {
        TreePath path;
        if (!treeBuilder.wasRootNodeInitialized()) {
            return;
        }
        JTree tree = treeBuilder.getTree();
        if (tree.isPathSelected(path = new TreePath(root.getPath()))) {
            selectionPaths.add(storeElementsOnly ? ((NodeDescriptor)root.getUserObject()).getElement() : path);
        }
        if (tree.isExpanded(path) || root.getChildCount() == 0) {
            pathsToExpand.add(storeElementsOnly ? ((NodeDescriptor)root.getUserObject()).getElement() : path);
            TreeBuilderUtil._storePaths(tree, root, pathsToExpand, selectionPaths, storeElementsOnly);
        }
    }

    private static void _storePaths(JTree tree, DefaultMutableTreeNode root, List<Object> pathsToExpand, List<Object> selectionPaths, boolean storeElementsOnly) {
        ArrayList<TreeNode> childNodes = TreeUtil.childrenToArray(root);
        for (TreeNode childNode1 : childNodes) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
            TreePath path = new TreePath(childNode.getPath());
            Object userObject = childNode.getUserObject();
            if (tree.isPathSelected(path)) {
                if (!(userObject instanceof NodeDescriptor)) {
                    LOG.error("Node: " + childNode + "; userObject: " + userObject + " of class " + userObject.getClass());
                }
                selectionPaths.add(storeElementsOnly ? ((NodeDescriptor)userObject).getElement() : path);
            }
            if (!tree.isExpanded(path) && childNode.getChildCount() != 0) continue;
            pathsToExpand.add(storeElementsOnly && userObject instanceof NodeDescriptor ? ((NodeDescriptor)userObject).getElement() : path);
            TreeBuilderUtil._storePaths(tree, childNode, pathsToExpand, selectionPaths, storeElementsOnly);
        }
    }

    public static void restorePaths(AbstractTreeBuilder treeBuilder, List<Object> pathsToExpand, List<Object> selectionPaths, boolean elementsOnly) {
        JTree tree = treeBuilder.getTree();
        if (!elementsOnly) {
            for (Object path : pathsToExpand) {
                tree.expandPath((TreePath)path);
            }
            tree.addSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
        } else {
            DefaultMutableTreeNode node;
            for (Object element : pathsToExpand) {
                treeBuilder.buildNodeForElement(element);
                node = treeBuilder.getNodeForElement(element);
                if (node == null) continue;
                tree.expandPath(new TreePath(node.getPath()));
            }
            for (Object element : selectionPaths) {
                node = treeBuilder.getNodeForElement(element);
                if (node == null) continue;
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                tree.addSelectionPath(new TreePath(treeModel.getPathToRoot(node)));
            }
        }
    }

    public static boolean isNodeSelected(JTree tree, DefaultMutableTreeNode node) {
        TreePath[] selectionPaths = tree.getSelectionPaths();
        return selectionPaths != null && selectionPaths.length != 0 && ContainerUtil.find(Arrays.asList(selectionPaths), (Object)new TreePath(node.getPath())) != null;
    }

    public static boolean isNodeOrChildSelected(JTree tree, DefaultMutableTreeNode node) {
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return false;
        }
        TreePath path = new TreePath(node.getPath());
        for (TreePath selectionPath : selectionPaths) {
            if (!path.isDescendant(selectionPath)) continue;
            return true;
        }
        return false;
    }
}

