/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComboBoxAction
extends AnAction
implements CustomComponentAction {
    private static final Icon ARROW_ICON = UIUtil.isUnderDarcula() ? AllIcons.General.ComboArrow : AllIcons.General.ComboBoxButtonArrow;
    private static final Icon DISABLED_ARROW_ICON = IconLoader.getDisabledIcon((Icon)ARROW_ICON);
    private boolean mySmallVariant = true;
    private String myPopupTitle;

    protected ComboBoxAction() {
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        ComboBoxButton button = (ComboBoxButton)e.getPresentation().getClientProperty("customComponent");
        if (button == null) {
            Component contextComponent = e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            JRootPane rootPane = (JRootPane)UIUtil.getParentOfType(JRootPane.class, (Component)contextComponent);
            if (rootPane != null) {
                button = (ComboBoxButton)JBSwingUtilities.uiTraverser().breadthFirstTraversal((Object)rootPane).filter((Condition)new Condition<Component>(){

                    public boolean value(Component component) {
                        return component instanceof ComboBoxButton && ((ComboBoxButton)component).getMyAction() == ComboBoxAction.this;
                    }
                }).first();
            }
            if (button == null) {
                return;
            }
        }
        if (!button.isShowing()) {
            return;
        }
        button.showPopup();
    }

    @Override
    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new GridBagLayout());
        ComboBoxButton button = this.createComboBoxButton(presentation);
        panel.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insets((int)0, (int)3, (int)0, (int)3), 0, 0));
        return panel;
    }

    protected ComboBoxButton createComboBoxButton(Presentation presentation) {
        return new ComboBoxButton(presentation);
    }

    public boolean isSmallVariant() {
        return this.mySmallVariant;
    }

    public void setSmallVariant(boolean smallVariant) {
        this.mySmallVariant = smallVariant;
    }

    public void setPopupTitle(String popupTitle) {
        this.myPopupTitle = popupTitle;
    }

    @Override
    public void update(AnActionEvent e) {
    }

    protected boolean shouldShowDisabledActions() {
        return false;
    }

    @NotNull
    protected abstract DefaultActionGroup createPopupActionGroup(JComponent var1);

    protected int getMaxRows() {
        return 30;
    }

    protected int getMinHeight() {
        return 1;
    }

    protected int getMinWidth() {
        return 1;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return null;
    }

    protected class ComboBoxButton
    extends JButton
    implements UserActivityProviderComponent {
        private final Presentation myPresentation;
        private boolean myForcePressed = false;
        private PropertyChangeListener myButtonSynchronizer;
        private boolean myMouseInside = false;
        private JBPopup myPopup;
        private boolean myForceTransparent = false;

        public ComboBoxButton(Presentation presentation) {
            this.myPresentation = presentation;
            this.setEnabled(this.myPresentation.isEnabled());
            this.setModel(new MyButtonModel());
            this.setHorizontalAlignment(2);
            this.setFocusable(false);
            Insets margins = this.getMargin();
            this.setMargin((Insets)JBUI.insets((int)margins.top, (int)2, (int)margins.bottom, (int)2));
            if (ComboBoxAction.this.isSmallVariant()) {
                this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)0, (int)2));
                if (!UIUtil.isUnderGTKLookAndFeel()) {
                    this.setFont((Font)JBUI.Fonts.label((float)11.0f));
                }
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ComboBoxButton.this.myForcePressed) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

                            @Override
                            public void run() {
                                ComboBoxButton.this.showPopup();
                            }
                        });
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ComboBoxButton.this.myMouseInside = true;
                    ComboBoxButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ComboBoxButton.this.myMouseInside = false;
                    ComboBoxButton.this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        e.consume();
                        ComboBoxButton.this.doClick();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ComboBoxButton.this.dispatchEventToPopup(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(new MouseEvent(e.getComponent(), 503, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    ComboBoxButton.this.dispatchEventToPopup(e);
                }
            });
        }

        private void dispatchEventToPopup(MouseEvent e) {
            if (this.myPopup != null && this.myPopup.isVisible()) {
                MouseEvent event;
                Component component;
                JComponent content = this.myPopup.getContent();
                Rectangle rectangle = content.getBounds();
                Point location = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(location, content);
                Point eventPoint = e.getLocationOnScreen();
                rectangle.setLocation(location);
                if (rectangle.contains(eventPoint) && (component = SwingUtilities.getDeepestComponentAt(content, (event = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.myPopup.getContent())).getX(), event.getY())) != null) {
                    component.dispatchEvent(event);
                }
            }
        }

        public void setForceTransparent(boolean transparent) {
            this.myForceTransparent = transparent;
        }

        @NotNull
        private Runnable setForcePressed() {
            this.myForcePressed = true;
            this.repaint();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ComboBoxButton.this.myForcePressed = false;
                            ComboBoxButton.this.myPopup = null;
                        }
                    }, ModalityState.any());
                    ComboBoxButton.this.repaint();
                    ComboBoxButton.this.fireStateChanged();
                }
            };
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton", "setForcePressed"));
            }
            return runnable;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myForcePressed ? null : super.getToolTipText();
        }

        public void showPopup() {
            this.createPopup(this.setForcePressed()).showUnderneathOf(this);
        }

        protected JBPopup createPopup(Runnable onDispose) {
            DefaultActionGroup group = ComboBoxAction.this.createPopupActionGroup(this);
            DataContext context = this.getDataContext();
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(ComboBoxAction.this.myPopupTitle, group, context, false, ComboBoxAction.this.shouldShowDisabledActions(), false, onDispose, ComboBoxAction.this.getMaxRows(), ComboBoxAction.this.getPreselectCondition());
            popup.setMinimumSize(new Dimension(ComboBoxAction.this.getMinWidth(), ComboBoxAction.this.getMinHeight()));
            return popup;
        }

        private ComboBoxAction getMyAction() {
            return ComboBoxAction.this;
        }

        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext(this);
        }

        @Override
        public void removeNotify() {
            if (this.myButtonSynchronizer != null) {
                this.myPresentation.removePropertyChangeListener(this.myButtonSynchronizer);
                this.myButtonSynchronizer = null;
            }
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.myButtonSynchronizer == null) {
                this.myButtonSynchronizer = new MyButtonSynchronizer();
                this.myPresentation.addPropertyChangeListener(this.myButtonSynchronizer);
            }
            this.initButton();
        }

        private void initButton() {
            this.setIcon(this.myPresentation.getIcon());
            this.setText(this.myPresentation.getText());
            this.updateTooltipText(this.myPresentation.getDescription());
            this.updateButtonSize();
        }

        private void updateTooltipText(String description) {
            String tooltip = KeymapUtil.createTooltipText(description, ComboBoxAction.this);
            this.setToolTipText(!tooltip.isEmpty() ? tooltip : null);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public Insets getInsets() {
            Insets insets = super.getInsets();
            return new Insets(insets.top, insets.left, insets.bottom, insets.right + ARROW_ICON.getIconWidth());
        }

        @Override
        public Insets getInsets(Insets insets) {
            Insets result = super.getInsets(insets);
            result.right += ARROW_ICON.getIconWidth();
            return result;
        }

        @Override
        public boolean isOpaque() {
            return !ComboBoxAction.this.isSmallVariant();
        }

        @Override
        public Dimension getPreferredSize() {
            int width;
            boolean isEmpty = this.getIcon() == null && StringUtil.isEmpty((String)this.getText());
            int n = width = isEmpty ? JBUI.scale((int)10) + ARROW_ICON.getIconWidth() : super.getPreferredSize().width;
            if (ComboBoxAction.this.isSmallVariant()) {
                width += JBUI.scale((int)4);
            }
            return new Dimension(width, ComboBoxAction.this.isSmallVariant() ? JBUI.scale((int)19) : super.getPreferredSize().height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
        }

        @Override
        public Font getFont() {
            return SystemInfo.isMac && ComboBoxAction.this.isSmallVariant() ? UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL) : UIUtil.getLabelFont();
        }

        @Override
        public void paint(Graphics g) {
            Icon icon;
            Color textColor;
            UISettings.setupAntialiasing(g);
            Dimension size = this.getSize();
            boolean isEmpty = this.getIcon() == null && StringUtil.isEmpty((String)this.getText());
            Color color = textColor = this.isEnabled() ? UIManager.getColor("Panel.foreground") : UIUtil.getInactiveTextColor();
            if (this.myForceTransparent) {
                Icon icon2 = this.getIcon();
                int x = 7;
                if (icon2 != null) {
                    icon2.paintIcon(this, g, x, (size.height - icon2.getIconHeight()) / 2);
                    x += icon2.getIconWidth() + 3;
                }
                if (!StringUtil.isEmpty((String)this.getText())) {
                    Font font = this.getFont();
                    g.setFont(font);
                    g.setColor(textColor);
                    g.drawString(this.getText(), x, (size.height + font.getSize()) / 2 - 1);
                }
            } else if (ComboBoxAction.this.isSmallVariant()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(UIUtil.getControlColor());
                int w = this.getWidth();
                int h = this.getHeight();
                if (this.getModel().isArmed() && this.getModel().isPressed()) {
                    g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)UIUtil.getControlColor(), (float)0.0f, (float)h, (Color)ColorUtil.shift((Color)UIUtil.getControlColor(), (double)0.8)));
                } else if (UIUtil.isUnderDarcula()) {
                    g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ColorUtil.shift((Color)UIUtil.getControlColor(), (double)1.1), (float)0.0f, (float)h, (Color)ColorUtil.shift((Color)UIUtil.getControlColor(), (double)0.9)));
                } else {
                    g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)new JBColor((Color)(SystemInfo.isMac ? Gray._226 : Gray._245), (Color)Gray._131), (float)0.0f, (float)h, (Color)new JBColor((Color)(SystemInfo.isMac ? Gray._198 : Gray._208), (Color)Gray._128)));
                }
                g2.fillRoundRect(2, 0, w - 2, h, 5, 5);
                JBColor borderColor = this.myMouseInside ? new JBColor((Color)Gray._111, (Color)Gray._118) : new JBColor((Color)Gray._151, (Color)Gray._95);
                g2.setPaint((Paint)borderColor);
                g2.drawRoundRect(2, 0, w - 3, h - 1, 5, 5);
                Icon icon3 = this.getIcon();
                int x = 7;
                if (icon3 != null) {
                    icon3.paintIcon(this, g, x, (size.height - icon3.getIconHeight()) / 2);
                    x += icon3.getIconWidth() + 3;
                }
                if (!StringUtil.isEmpty((String)this.getText())) {
                    Font font = this.getFont();
                    g2.setFont(font);
                    g2.setColor(textColor);
                    g2.drawString(this.getText(), x, (size.height + font.getSize()) / 2 - 1);
                }
            } else {
                super.paint(g);
            }
            Insets insets = super.getInsets();
            Icon icon4 = icon = this.isEnabled() ? ARROW_ICON : DISABLED_ARROW_ICON;
            int x = isEmpty ? (size.width - icon.getIconWidth()) / 2 : (ComboBoxAction.this.isSmallVariant() ? size.width - icon.getIconWidth() - insets.right + 1 : size.width - icon.getIconWidth() - insets.right + (UIUtil.isUnderNimbusLookAndFeel() ? -3 : 2));
            icon.paintIcon(null, g, x, (size.height - icon.getIconHeight()) / 2);
            g.setPaintMode();
        }

        protected void updateButtonSize() {
            this.invalidate();
            this.repaint();
            this.setSize(this.getPreferredSize());
        }

        private class MyButtonSynchronizer
        implements PropertyChangeListener {
            private MyButtonSynchronizer() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("text".equals(propertyName)) {
                    ComboBoxButton.this.setText((String)evt.getNewValue());
                    ComboBoxButton.this.updateButtonSize();
                } else if ("description".equals(propertyName)) {
                    ComboBoxButton.this.updateTooltipText((String)evt.getNewValue());
                } else if ("icon".equals(propertyName)) {
                    ComboBoxButton.this.setIcon((Icon)evt.getNewValue());
                    ComboBoxButton.this.updateButtonSize();
                } else if ("enabled".equals(propertyName)) {
                    ComboBoxButton.this.setEnabled((Boolean)evt.getNewValue());
                }
            }
        }

        protected class MyButtonModel
        extends DefaultButtonModel {
            protected MyButtonModel() {
            }

            @Override
            public boolean isPressed() {
                return ComboBoxButton.this.myForcePressed || super.isPressed();
            }

            @Override
            public boolean isArmed() {
                return ComboBoxButton.this.myForcePressed || super.isArmed();
            }
        }
    }
}

