/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.MockJdkWrapper;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.builders.JavaModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureBuilderImpl;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

abstract class JavaModuleFixtureBuilderImpl<T extends ModuleFixture>
extends ModuleFixtureBuilderImpl<T>
implements JavaModuleFixtureBuilder<T> {
    private final List<Lib> myLibraries = new ArrayList<Lib>();
    private String myJdk;
    private JavaModuleFixtureBuilder.MockJdkLevel myMockJdkLevel = JavaModuleFixtureBuilder.MockJdkLevel.jdk14;
    private LanguageLevel myLanguageLevel = null;

    public JavaModuleFixtureBuilderImpl(TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(StdModuleTypes.JAVA, fixtureBuilder);
    }

    public JavaModuleFixtureBuilderImpl(ModuleType moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(moduleType, fixtureBuilder);
    }

    @Override
    public JavaModuleFixtureBuilder setLanguageLevel(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
        return this;
    }

    @Override
    public JavaModuleFixtureBuilder addLibrary(String libraryName, String ... classPath) {
        HashMap<OrderRootType, String[]> map = new HashMap<OrderRootType, String[]>();
        for (String path : classPath) {
            if (new File(path).exists()) continue;
            System.out.println(path + " does not exist");
        }
        map.put(OrderRootType.CLASSES, classPath);
        this.myLibraries.add(new Lib(libraryName, map));
        return this;
    }

    @Override
    public JavaModuleFixtureBuilder addLibrary(@NonNls String libraryName, Map<OrderRootType, String[]> roots) {
        this.myLibraries.add(new Lib(libraryName, roots));
        return this;
    }

    @Override
    public JavaModuleFixtureBuilder addLibraryJars(String libraryName, String basePath, String ... jars) {
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        String[] classPath = ArrayUtil.newStringArray((int)jars.length);
        for (int i = 0; i < jars.length; ++i) {
            classPath[i] = basePath + jars[i];
        }
        return this.addLibrary(libraryName, classPath);
    }

    @Override
    public JavaModuleFixtureBuilder addJdk(String jdkPath) {
        this.myJdk = jdkPath;
        return this;
    }

    @Override
    public void setMockJdkLevel(JavaModuleFixtureBuilder.MockJdkLevel level) {
        this.myMockJdkLevel = level;
    }

    protected void initModule(Module module) {
        Sdk jdk;
        super.initModule(module);
        ModifiableRootModel model = ModuleRootManager.getInstance(module).getModifiableModel();
        LibraryTable libraryTable = model.getModuleLibraryTable();
        for (Lib lib : this.myLibraries) {
            String libraryName = lib.getName();
            Library library = libraryTable.createLibrary(libraryName);
            Library.ModifiableModel libraryModel = library.getModifiableModel();
            for (OrderRootType rootType : OrderRootType.getAllTypes()) {
                String[] roots;
                for (String root : roots = lib.getRoots(rootType)) {
                    VirtualFile jar;
                    VirtualFile vRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                    if (vRoot != null && OrderRootType.CLASSES.equals(rootType) && !vRoot.isDirectory() && (jar = JarFileSystem.getInstance().refreshAndFindFileByPath(root + "!/")) != null) {
                        vRoot = jar;
                    }
                    if (vRoot == null) continue;
                    libraryModel.addRoot(vRoot, rootType);
                }
            }
            libraryModel.commit();
        }
        if (this.myJdk != null) {
            VfsRootAccess.allowRootAccessTemporarily((Disposable)module, (String[])new String[]{this.myJdk});
            jdk = JavaSdk.getInstance().createJdk(module.getName() + "_jdk", this.myJdk, false);
            ((ProjectJdkImpl)jdk).setVersionString("java 1.5");
        } else {
            jdk = IdeaTestUtil.getMockJdk17();
        }
        if (jdk != null) {
            model.setSdk((Sdk)new MockJdkWrapper(CompilerConfigurationImpl.getTestsExternalCompilerHome(), jdk));
        }
        if (this.myLanguageLevel != null) {
            model.getModuleExtension(LanguageLevelModuleExtension.class).setLanguageLevel(this.myLanguageLevel);
        } else if (this.myMockJdkLevel == JavaModuleFixtureBuilder.MockJdkLevel.jdk15) {
            model.getModuleExtension(LanguageLevelModuleExtension.class).setLanguageLevel(LanguageLevel.JDK_1_5);
        }
        model.commit();
        for (OrderEntry entry : ModuleRootManager.getInstance(module).getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            this.libraryCreated(library, module);
        }
    }

    protected void setupRootModel(ModifiableRootModel rootModel) {
        if (this.myOutputPath != null) {
            File pathFile = new File(this.myOutputPath);
            if (!pathFile.mkdirs()) assert (pathFile.exists()) : "unable to create: " + this.myOutputPath;
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myOutputPath);
            assert (virtualFile != null) : "cannot find output path: " + this.myOutputPath;
            rootModel.getModuleExtension(CompilerModuleExtension.class).setCompilerOutputPath(virtualFile);
            rootModel.getModuleExtension(CompilerModuleExtension.class).inheritCompilerOutputPath(false);
            rootModel.getModuleExtension(CompilerModuleExtension.class).setExcludeOutput(false);
        }
        if (this.myTestOutputPath != null) {
            assert (new File(this.myTestOutputPath).mkdirs()) : this.myTestOutputPath;
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myTestOutputPath);
            assert (virtualFile != null) : "cannot find test output path: " + this.myTestOutputPath;
            rootModel.getModuleExtension(CompilerModuleExtension.class).setCompilerOutputPathForTests(virtualFile);
            rootModel.getModuleExtension(CompilerModuleExtension.class).inheritCompilerOutputPath(false);
            rootModel.getModuleExtension(CompilerModuleExtension.class).setExcludeOutput(false);
        }
    }

    protected void libraryCreated(Library library, Module module) {
    }

    private static class Lib {
        private final String myName;
        private final Map<OrderRootType, String[]> myRoots;

        public Lib(String name, Map<OrderRootType, String[]> roots) {
            this.myName = name;
            this.myRoots = roots;
        }

        public String getName() {
            return this.myName;
        }

        public String[] getRoots(OrderRootType rootType) {
            String[] roots = this.myRoots.get(rootType);
            return roots != null ? roots : ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }
}

