/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CollectionListModel;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCollectionComboBoxModel<T>
extends CollectionListModel<T>
implements ComboBoxModel {
    private T mySelection;

    public AbstractCollectionComboBoxModel(@Nullable T selection) {
        super(new Object[0]);
        this.mySelection = selection;
    }

    public AbstractCollectionComboBoxModel(@Nullable T selection, @NotNull Collection<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/AbstractCollectionComboBoxModel", "<init>"));
        }
        super(items);
        this.mySelection = selection;
    }

    @Override
    public void setSelectedItem(@Nullable Object item) {
        if (this.mySelection != item) {
            this.mySelection = item;
            this.update();
        }
    }

    @Override
    @Nullable
    public Object getSelectedItem() {
        return this.mySelection;
    }

    @Nullable
    public T getSelected() {
        return this.mySelection;
    }

    public void update() {
        super.fireContentsChanged(this, -1, -1);
    }

    public boolean contains(T item) {
        return this.getElementIndex(item) != -1;
    }
}

