/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.ActionPanel;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.table.TableLayout;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.Centerizer;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabLabel
extends JPanel {
    protected final SimpleColoredComponent myLabel;
    private final LayeredIcon myIcon;
    private Icon myOverlayedIcon;
    private final TabInfo myInfo;
    protected ActionPanel myActionPanel;
    private boolean myCentered;
    private final Wrapper myLabelPlaceholder = new Wrapper(false);
    protected final JBTabsImpl myTabs;
    private BufferedImage myInactiveStateImage;
    private Rectangle myLastPaintedInactiveImageBounds;

    public TabLabel(JBTabsImpl tabs, final TabInfo info) {
        super(false);
        this.myTabs = tabs;
        this.myInfo = info;
        this.myLabel = this.createLabel(tabs);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.myLabelPlaceholder.setOpaque(false);
        this.add((Component)this.myLabelPlaceholder, "Center");
        this.setAlignmentToCenter(true);
        this.myIcon = new LayeredIcon(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UIUtil.isCloseClick((MouseEvent)e, (int)501)) {
                    return;
                }
                if (JBTabsImpl.isSelectionClick(e, false) && TabLabel.this.myInfo.isEnabled()) {
                    Component c;
                    TabInfo selectedInfo = TabLabel.this.myTabs.getSelectedInfo();
                    if (selectedInfo != TabLabel.this.myInfo) {
                        TabLabel.this.myInfo.setPreviousSelection(selectedInfo);
                    }
                    if ((c = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY())) instanceof InplaceButton) {
                        return;
                    }
                    TabLabel.this.myTabs.select(info, true);
                } else {
                    TabLabel.this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TabLabel.this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TabLabel.this.myInfo.setPreviousSelection(null);
                TabLabel.this.handlePopup(e);
            }
        });
    }

    private SimpleColoredComponent createLabel(JBTabsImpl tabs) {
        SimpleColoredComponent label = new SimpleColoredComponent(){

            @Override
            protected boolean shouldDrawMacShadow() {
                return SystemInfo.isMac || UIUtil.isUnderDarcula();
            }

            @Override
            protected boolean shouldDrawDimmed() {
                return TabLabel.this.myTabs.getSelectedInfo() != TabLabel.this.myInfo || TabLabel.this.myTabs.useBoldLabels();
            }

            @Override
            public Font getFont() {
                if (this.isFontSet() || !TabLabel.this.myTabs.useSmallLabels()) {
                    return super.getFont();
                }
                return UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doPaint(Graphics2D g) {
                Rectangle clip = this.getVisibleRect();
                if (this.getPreferredSize().width <= clip.width + 2) {
                    super.doPaint(g);
                    return;
                }
                int dimSize = 10;
                int dimStep = 2;
                Composite oldComposite = g.getComposite();
                Shape oldClip = g.getClip();
                try {
                    g.setClip(clip.x, clip.y, Math.max(0, clip.width - dimSize), clip.height);
                    super.doPaint(g);
                    for (int x = clip.x + clip.width - dimSize; x < clip.x + clip.width; x += dimStep) {
                        g.setClip(x, clip.y, dimStep, clip.height);
                        g.setComposite(AlphaComposite.getInstance(3, 1.0f - ((float)x - (float)(clip.x + clip.width - dimSize)) / (float)dimSize));
                        super.doPaint(g);
                    }
                }
                finally {
                    g.setComposite(oldComposite);
                    g.setClip(oldClip);
                }
            }

            @Override
            protected void applyAdditionalHints(@NotNull Graphics2D g) {
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/tabs/impl/TabLabel$2", "applyAdditionalHints"));
                }
                UISettings.setupAntialiasing(g);
            }
        };
        label.setOpaque(false);
        label.setBorder(null);
        label.setIconTextGap(tabs.isEditorTabs() ? (!UISettings.getInstance().HIDE_TABS_IF_NEED ? 4 : 2) : new JLabel().getIconTextGap());
        label.setIconOpaque(false);
        label.setIpad(new Insets(0, 0, 0, 0));
        return label;
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.myTabs.isEditorTabs() && UISettings.getInstance().SHOW_CLOSE_BUTTON) {
            insets.right = 3;
        }
        return insets;
    }

    public void setAlignmentToCenter(boolean toCenter) {
        if (this.myCentered == toCenter && this.getLabelComponent().getParent() != null) {
            return;
        }
        this.setPlaceholderContent(toCenter, this.getLabelComponent());
    }

    protected void setPlaceholderContent(boolean toCenter, JComponent component) {
        this.myLabelPlaceholder.removeAll();
        if (toCenter) {
            Centerizer center = new Centerizer(component);
            this.myLabelPlaceholder.setContent((JComponent)center);
        } else {
            this.myLabelPlaceholder.setContent(component);
        }
        this.myCentered = toCenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintOffscreen(Graphics g) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        this.doPaint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.myTabs.isDropTarget(this.myInfo)) {
            return;
        }
        if (this.myTabs.getSelectedInfo() != this.myInfo) {
            this.doPaint(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintImage(Graphics g) {
        Rectangle b = this.getBounds();
        Graphics lG = g.create(b.x, b.y, b.width, b.height);
        try {
            lG.setColor(Color.red);
            this.doPaint(lG);
        }
        finally {
            lG.dispose();
        }
    }

    public void doTranslate(PairConsumer<Integer, Integer> consumer) {
        JBTabsPosition pos = this.myTabs.getTabsPosition();
        int dX = 0;
        int dXs = 0;
        int dY = 0;
        int dYs = 0;
        int selected = this.getSelectedOffset();
        int plain = this.getNonSelectedOffset();
        switch (pos) {
            case bottom: {
                dY = -plain;
                dYs = -selected;
                break;
            }
            case left: {
                dX = plain;
                dXs = selected;
                break;
            }
            case right: {
                dX = -plain;
                dXs = -selected;
                break;
            }
            case top: {
                dY = plain;
                dYs = selected;
            }
        }
        if (!this.myTabs.isDropTarget(this.myInfo)) {
            if (this.myTabs.getSelectedInfo() != this.myInfo) {
                consumer.consume((Object)dX, (Object)dY);
            } else {
                consumer.consume((Object)dXs, (Object)dYs);
            }
        }
    }

    private void doPaint(final Graphics g) {
        this.doTranslate(new PairConsumer<Integer, Integer>(){

            public void consume(Integer x, Integer y) {
                g.translate(x, y);
            }
        });
        Composite oldComposite = ((Graphics2D)g).getComposite();
        super.paint(g);
        ((Graphics2D)g).setComposite(oldComposite);
        this.doTranslate(new PairConsumer<Integer, Integer>(){

            public void consume(Integer x, Integer y) {
                g.translate(-x.intValue(), -y.intValue());
            }
        });
    }

    protected int getNonSelectedOffset() {
        if (this.myTabs.isEditorTabs() && (this.myTabs.isSingleRow() || ((TableLayout)this.myTabs.getEffectiveLayout()).isLastRow(this.getInfo()))) {
            return -this.myTabs.getActiveTabUnderlineHeight() / 2 + 1;
        }
        return 1;
    }

    protected int getSelectedOffset() {
        return this.getNonSelectedOffset();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = TabsUtil.getTabsHeight();
        if (this.myActionPanel != null && !this.myActionPanel.isVisible()) {
            Dimension actionPanelSize = this.myActionPanel.getPreferredSize();
            size.width += actionPanelSize.width;
        }
        JBTabsPosition pos = this.myTabs.getTabsPosition();
        switch (pos) {
            case bottom: 
            case top: {
                if (!this.myTabs.hasUnderline()) break;
                size.height += this.myTabs.getActiveTabUnderlineHeight() - 1;
                break;
            }
            case left: 
            case right: {
                size.width += this.getSelectedOffset();
            }
        }
        return size;
    }

    private void handlePopup(MouseEvent e) {
        JBTabsImpl tabs;
        if (e.getClickCount() != 1 || !e.isPopupTrigger()) {
            return;
        }
        if (e.getX() < 0 || e.getX() >= e.getComponent().getWidth() || e.getY() < 0 || e.getY() >= e.getComponent().getHeight()) {
            return;
        }
        String place = this.myTabs.getPopupPlace();
        place = place != null ? place : "unknown";
        this.myTabs.myPopupInfo = this.myInfo;
        DefaultActionGroup toShow = new DefaultActionGroup();
        if (this.myTabs.getPopupGroup() != null) {
            toShow.addAll(this.myTabs.getPopupGroup());
            toShow.addSeparator();
        }
        if ((tabs = JBTabsImpl.NAVIGATION_ACTIONS_KEY.getData(DataManager.getInstance().getDataContext(e.getComponent(), e.getX(), e.getY()))) == this.myTabs && this.myTabs.myAddNavigationGroup) {
            toShow.addAll(this.myTabs.myNavigationActions);
        }
        if (toShow.getChildrenCount() == 0) {
            return;
        }
        this.myTabs.myActivePopup = this.myTabs.myActionManager.createActionPopupMenu(place, toShow).getComponent();
        this.myTabs.myActivePopup.addPopupMenuListener(this.myTabs.myPopupListener);
        this.myTabs.myActivePopup.addPopupMenuListener(this.myTabs);
        this.myTabs.myActivePopup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void setText(final SimpleColoredText text) {
        this.myLabel.change(new Runnable(){

            @Override
            public void run() {
                TabLabel.this.myLabel.clear();
                TabLabel.this.myLabel.setIcon(TabLabel.this.hasIcons() ? TabLabel.this.myIcon : null);
                if (text != null) {
                    SimpleColoredText derive = TabLabel.this.myTabs.useBoldLabels() ? text.derive(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, true) : text;
                    derive.appendToComponent(TabLabel.this.myLabel);
                }
            }
        }, false);
        this.invalidateIfNeeded();
    }

    private void invalidateIfNeeded() {
        if (this.getLabelComponent().getRootPane() == null) {
            return;
        }
        Dimension d = this.getLabelComponent().getSize();
        Dimension pref = this.getLabelComponent().getPreferredSize();
        if (d != null && d.equals(pref)) {
            return;
        }
        this.setInactiveStateImage(null);
        this.getLabelComponent().invalidate();
        if (this.myActionPanel != null) {
            this.myActionPanel.invalidate();
        }
        this.myTabs.revalidateAndRepaint(false);
    }

    public void setIcon(Icon icon) {
        this.setIcon(icon, 0);
    }

    private boolean hasIcons() {
        Icon[] layers;
        LayeredIcon layeredIcon = this.getLayeredIcon();
        boolean hasIcons = false;
        for (Icon layer1 : layers = layeredIcon.getAllLayers()) {
            if (layer1 == null) continue;
            hasIcons = true;
            break;
        }
        return hasIcons;
    }

    private void setIcon(@Nullable Icon icon, int layer) {
        LayeredIcon layeredIcon = this.getLayeredIcon();
        layeredIcon.setIcon(icon, layer);
        if (this.hasIcons()) {
            this.myLabel.setIcon(layeredIcon);
        } else {
            this.myLabel.setIcon(null);
        }
        this.invalidateIfNeeded();
    }

    private LayeredIcon getLayeredIcon() {
        return this.myIcon;
    }

    public TabInfo getInfo() {
        return this.myInfo;
    }

    public void apply(UiDecorator.UiDecoration decoration) {
        Insets current;
        Insets insets;
        if (decoration.getLabelFont() != null) {
            this.setFont(decoration.getLabelFont());
            this.getLabelComponent().setFont(decoration.getLabelFont());
        }
        if ((insets = decoration.getLabelInsets()) != null && (current = JBTabsImpl.ourDefaultDecorator.getDecoration().getLabelInsets()) != null) {
            this.setBorder(new EmptyBorder(TabLabel.getValue(current.top, insets.top), TabLabel.getValue(current.left, insets.left), TabLabel.getValue(current.bottom, insets.bottom), TabLabel.getValue(current.right, insets.right)));
        }
    }

    private static int getValue(int currentValue, int newValue) {
        return newValue != -1 ? newValue : currentValue;
    }

    public void setTabActions(ActionGroup group) {
        this.removeOldActionPanel();
        if (group == null) {
            return;
        }
        this.myActionPanel = new ActionPanel(this.myTabs, this.myInfo, new Pass<MouseEvent>(){

            public void pass(MouseEvent event) {
                MouseEvent me = SwingUtilities.convertMouseEvent(event.getComponent(), event, TabLabel.this);
                TabLabel.this.processMouseEvent(me);
            }
        });
        this.toggleShowActions(false);
        this.add((Component)this.myActionPanel, "East");
        this.myTabs.revalidateAndRepaint(false);
    }

    private void removeOldActionPanel() {
        if (this.myActionPanel != null) {
            this.myActionPanel.getParent().remove(this.myActionPanel);
            this.myActionPanel = null;
        }
    }

    public boolean updateTabActions() {
        return this.myActionPanel != null && this.myActionPanel.update();
    }

    private void setAttractionIcon(@Nullable Icon icon) {
        if (this.myIcon.getIcon(0) == null) {
            this.setIcon(null, 1);
            this.myOverlayedIcon = icon;
        } else {
            this.setIcon(icon, 1);
            this.myOverlayedIcon = null;
        }
    }

    public boolean repaintAttraction() {
        if (!this.myTabs.myAttractions.contains(this.myInfo)) {
            if (this.getLayeredIcon().isLayerEnabled(1)) {
                this.getLayeredIcon().setLayerEnabled(1, false);
                this.setAttractionIcon(null);
                this.invalidateIfNeeded();
                return true;
            }
            return false;
        }
        boolean needsUpdate = false;
        if (this.getLayeredIcon().getIcon(1) != this.myInfo.getAlertIcon()) {
            this.setAttractionIcon(this.myInfo.getAlertIcon());
            needsUpdate = true;
        }
        int maxInitialBlinkCount = 5;
        int maxRefireBlinkCount = maxInitialBlinkCount + 2;
        if (this.myInfo.getBlinkCount() < maxInitialBlinkCount && this.myInfo.isAlertRequested()) {
            this.getLayeredIcon().setLayerEnabled(1, !this.getLayeredIcon().isLayerEnabled(1));
            if (this.myInfo.getBlinkCount() == 0) {
                needsUpdate = true;
            }
            this.myInfo.setBlinkCount(this.myInfo.getBlinkCount() + 1);
            if (this.myInfo.getBlinkCount() == maxInitialBlinkCount) {
                this.myInfo.resetAlertRequest();
            }
            this.repaint();
        } else if (this.myInfo.getBlinkCount() < maxRefireBlinkCount && this.myInfo.isAlertRequested()) {
            this.getLayeredIcon().setLayerEnabled(1, !this.getLayeredIcon().isLayerEnabled(1));
            this.myInfo.setBlinkCount(this.myInfo.getBlinkCount() + 1);
            if (this.myInfo.getBlinkCount() == maxRefireBlinkCount) {
                this.myInfo.setBlinkCount(maxInitialBlinkCount);
                this.myInfo.resetAlertRequest();
            }
            this.repaint();
        } else {
            needsUpdate = !this.getLayeredIcon().isLayerEnabled(1);
            this.getLayeredIcon().setLayerEnabled(1, true);
        }
        this.invalidateIfNeeded();
        return needsUpdate;
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.myOverlayedIcon == null || this.getLabelComponent().getParent() == null) {
            return;
        }
        Rectangle textBounds = SwingUtilities.convertRectangle(this.getLabelComponent().getParent(), this.getLabelComponent().getBounds(), this);
        if (this.getLayeredIcon().isLayerEnabled(1)) {
            int top = (this.getSize().height - this.myOverlayedIcon.getIconHeight()) / 2;
            this.myOverlayedIcon.paintIcon(this, g, textBounds.x - this.myOverlayedIcon.getIconWidth() / 2, top);
        }
    }

    public void setTabActionsAutoHide(boolean autoHide) {
        if (this.myActionPanel == null || this.myActionPanel.isAutoHide() == autoHide) {
            return;
        }
        this.myActionPanel.setAutoHide(autoHide);
    }

    public void toggleShowActions(boolean show) {
        if (this.myActionPanel != null) {
            this.myActionPanel.toggleShowActions(show);
        }
    }

    public void setActionPanelVisible(boolean visible) {
        if (this.myActionPanel != null) {
            this.myActionPanel.setVisible(visible);
        }
    }

    @Override
    public String toString() {
        return this.myInfo.getText();
    }

    public void setTabEnabled(boolean enabled) {
        this.getLabelComponent().setEnabled(enabled);
    }

    @Nullable
    public BufferedImage getInactiveStateImage(Rectangle effectiveBounds) {
        BufferedImage img = null;
        if (this.myLastPaintedInactiveImageBounds != null && this.myLastPaintedInactiveImageBounds.getSize().equals(effectiveBounds.getSize())) {
            img = this.myInactiveStateImage;
        } else {
            this.setInactiveStateImage(null);
        }
        this.myLastPaintedInactiveImageBounds = effectiveBounds;
        return img;
    }

    public void setInactiveStateImage(@Nullable BufferedImage img) {
        if (this.myInactiveStateImage != null && img != this.myInactiveStateImage) {
            this.myInactiveStateImage.flush();
        }
        this.myInactiveStateImage = img;
    }

    public JComponent getLabelComponent() {
        return this.myLabel;
    }
}

