/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergingUpdateQueue
implements Runnable,
Disposable,
Activatable {
    public static final JComponent ANY_COMPONENT = new JComponent(){};
    private volatile boolean myActive;
    private volatile boolean mySuspended;
    private final Map<Update, Update> myScheduledUpdates;
    private final Alarm myWaiterForMerge;
    private volatile boolean myFlushing;
    private final String myName;
    private int myMergingTimeSpan;
    private JComponent myModalityStateComponent;
    private final boolean myExecuteInDispatchThread;
    private boolean myPassThrough;
    private boolean myDisposed;
    private UiNotifyConnector myUiNotifyConnector;
    private boolean myRestartOnAdd;
    private boolean myTrackUiActivity;
    private UiActivity myUiActivity;

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/update/MergingUpdateQueue", "<init>"));
        }
        this(name, mergingTimeSpan, isActive, modalityStateComponent, null);
    }

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent, @Nullable Disposable parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/update/MergingUpdateQueue", "<init>"));
        }
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, null);
    }

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent, @Nullable Disposable parent, @Nullable JComponent activationComponent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/update/MergingUpdateQueue", "<init>"));
        }
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, activationComponent, true);
    }

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent, @Nullable Disposable parent, @Nullable JComponent activationComponent, boolean executeInDispatchThread) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/update/MergingUpdateQueue", "<init>"));
        }
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, activationComponent, executeInDispatchThread ? Alarm.ThreadToUse.SWING_THREAD : Alarm.ThreadToUse.POOLED_THREAD);
    }

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent, @Nullable Disposable parent, @Nullable JComponent activationComponent, @NotNull Alarm.ThreadToUse thread) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/update/MergingUpdateQueue", "<init>"));
        }
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/util/ui/update/MergingUpdateQueue", "<init>"));
        }
        this.myScheduledUpdates = new TreeMap<Update, Update>();
        this.myMergingTimeSpan = mergingTimeSpan;
        this.myModalityStateComponent = modalityStateComponent;
        this.myName = name;
        this.myPassThrough = ApplicationManager.getApplication().isUnitTestMode();
        this.myExecuteInDispatchThread = thread == Alarm.ThreadToUse.SWING_THREAD;
        this.myWaiterForMerge = this.createAlarm(thread, this.myExecuteInDispatchThread ? null : this);
        if (isActive) {
            this.showNotify();
        }
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        if (activationComponent != null) {
            this.setActivationComponent(activationComponent);
        }
    }

    protected Alarm createAlarm(@NotNull Alarm.ThreadToUse thread, Disposable parent) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/util/ui/update/MergingUpdateQueue", "createAlarm"));
        }
        return AlarmFactory.getInstance().create(thread, parent);
    }

    public void setMergingTimeSpan(int timeSpan) {
        this.myMergingTimeSpan = timeSpan;
        if (this.myActive) {
            this.restartTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllUpdates() {
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            Update[] updates;
            for (Update each : updates = this.myScheduledUpdates.keySet().toArray(new Update[this.myScheduledUpdates.size()])) {
                try {
                    each.setRejected();
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
            this.myScheduledUpdates.clear();
            this.finishActivity();
        }
    }

    public final boolean isPassThrough() {
        return this.myPassThrough;
    }

    public final void setPassThrough(boolean passThrough) {
        this.myPassThrough = passThrough;
    }

    public void activate() {
        this.showNotify();
    }

    public void deactivate() {
        this.hideNotify();
    }

    public void suspend() {
        this.mySuspended = true;
    }

    public void resume() {
        this.mySuspended = false;
        this.restartTimer();
    }

    @Override
    public void hideNotify() {
        if (!this.myActive) {
            return;
        }
        this.myActive = false;
        this.finishActivity();
        this.clearWaiter();
    }

    @Override
    public void showNotify() {
        if (this.myActive) {
            return;
        }
        this.myActive = true;
        this.restartTimer();
        this.flush();
    }

    public void restartTimer() {
        this.restart(this.myMergingTimeSpan);
    }

    private void restart(int mergingTimeSpan) {
        if (!this.myActive) {
            return;
        }
        this.clearWaiter();
        if (this.myExecuteInDispatchThread) {
            this.myWaiterForMerge.addRequest((Runnable)this, mergingTimeSpan, this.getMergerModalityState());
        } else {
            this.myWaiterForMerge.addRequest((Runnable)this, mergingTimeSpan);
        }
    }

    @Override
    public void run() {
        if (this.mySuspended) {
            return;
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            if (this.myScheduledUpdates.isEmpty()) {
                this.finishActivity();
                return;
            }
        }
        this.flush(true);
    }

    public void flush(boolean invokeLaterIfNotDispatch) {
        if (this.myFlushing) {
            return;
        }
        if (!this.isModalityStateCorrect()) {
            return;
        }
        this.myFlushing = true;
        Runnable toRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Update[] all;
                    Update[] updateArray = MergingUpdateQueue.this.myScheduledUpdates;
                    synchronized (updateArray) {
                        all = MergingUpdateQueue.this.myScheduledUpdates.keySet().toArray(new Update[MergingUpdateQueue.this.myScheduledUpdates.size()]);
                        MergingUpdateQueue.this.myScheduledUpdates.clear();
                    }
                    for (Update each : all) {
                        each.setProcessed();
                    }
                    MergingUpdateQueue.this.execute(all);
                }
                finally {
                    MergingUpdateQueue.this.myFlushing = false;
                    if (MergingUpdateQueue.this.isEmpty()) {
                        MergingUpdateQueue.this.finishActivity();
                    }
                }
            }
        };
        if (this.myExecuteInDispatchThread && invokeLaterIfNotDispatch) {
            UIUtil.invokeLaterIfNeeded((Runnable)toRun);
        } else {
            toRun.run();
        }
    }

    public void setModalityStateComponent(JComponent modalityStateComponent) {
        this.myModalityStateComponent = modalityStateComponent;
    }

    protected boolean isModalityStateCorrect() {
        ModalityState modalityState;
        if (!this.myExecuteInDispatchThread) {
            return true;
        }
        if (this.myModalityStateComponent == ANY_COMPONENT) {
            return true;
        }
        ModalityState current = ApplicationManager.getApplication().getCurrentModalityState();
        return !current.dominates(modalityState = this.getModalityState());
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    private static boolean isExpired(@NotNull Update each) {
        if (each == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/util/ui/update/MergingUpdateQueue", "isExpired"));
        }
        return each.isDisposed() || each.isExpired();
    }

    protected void execute(@NotNull Update[] update) {
        if (update == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/util/ui/update/MergingUpdateQueue", "execute"));
        }
        for (final Update each : update) {
            if (MergingUpdateQueue.isExpired(each)) {
                each.setRejected();
                continue;
            }
            if (each.executeInWriteAction()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        MergingUpdateQueue.this.execute(each);
                    }
                });
                continue;
            }
            this.execute(each);
        }
    }

    private void execute(@NotNull Update each) {
        if (each == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/util/ui/update/MergingUpdateQueue", "execute"));
        }
        if (this.myDisposed) {
            each.setRejected();
        } else {
            each.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(@NotNull Update update) {
        if (update == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/util/ui/update/MergingUpdateQueue", "queue"));
        }
        if (this.myDisposed) {
            return;
        }
        if (this.myTrackUiActivity) {
            this.startActivity();
        }
        if (this.myPassThrough) {
            update.run();
            this.finishActivity();
            return;
        }
        boolean active = this.myActive;
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            try {
                if (this.eatThisOrOthers(update)) {
                    return;
                }
                if (active && this.myScheduledUpdates.isEmpty()) {
                    this.restartTimer();
                }
                this.put(update);
                if (this.myRestartOnAdd) {
                    this.restartTimer();
                }
            }
            finally {
                if (this.isEmpty()) {
                    this.finishActivity();
                }
            }
        }
    }

    private boolean eatThisOrOthers(@NotNull Update update) {
        Update[] updates;
        if (update == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/util/ui/update/MergingUpdateQueue", "eatThisOrOthers"));
        }
        if (this.myScheduledUpdates.containsKey(update)) {
            return false;
        }
        for (Update eachInQueue : updates = this.myScheduledUpdates.keySet().toArray(new Update[this.myScheduledUpdates.size()])) {
            if (eachInQueue.canEat(update)) {
                return true;
            }
            if (!update.canEat(eachInQueue)) continue;
            this.myScheduledUpdates.remove(eachInQueue);
            eachInQueue.setRejected();
        }
        return false;
    }

    public final void run(@NotNull Update update) {
        if (update == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/util/ui/update/MergingUpdateQueue", "run"));
        }
        this.execute(new Update[]{update});
    }

    private void put(@NotNull Update update) {
        if (update == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/util/ui/update/MergingUpdateQueue", "put"));
        }
        Update existing = this.myScheduledUpdates.remove(update);
        if (existing != null && existing != update) {
            existing.setProcessed();
            existing.setRejected();
        }
        this.myScheduledUpdates.put(update, update);
    }

    public boolean isActive() {
        return this.myActive;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myActive = false;
        this.finishActivity();
        this.clearWaiter();
    }

    private void clearWaiter() {
        this.myWaiterForMerge.cancelAllRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            return this.myName + " active=" + this.myActive + " scheduled=" + this.myScheduledUpdates.size();
        }
    }

    @Nullable
    private ModalityState getMergerModalityState() {
        return this.myModalityStateComponent == ANY_COMPONENT ? null : this.getModalityState();
    }

    @NotNull
    public ModalityState getModalityState() {
        if (this.myModalityStateComponent == null) {
            ModalityState modalityState = ModalityState.NON_MODAL;
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/update/MergingUpdateQueue", "getModalityState"));
            }
            return modalityState;
        }
        ModalityState modalityState = ModalityState.stateForComponent(this.myModalityStateComponent);
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/update/MergingUpdateQueue", "getModalityState"));
        }
        return modalityState;
    }

    public void setActivationComponent(@NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/ui/update/MergingUpdateQueue", "setActivationComponent"));
        }
        if (this.myUiNotifyConnector != null) {
            Disposer.dispose((Disposable)this.myUiNotifyConnector);
        }
        UiNotifyConnector connector = new UiNotifyConnector(c, this);
        Disposer.register((Disposable)this, (Disposable)connector);
        this.myUiNotifyConnector = connector;
    }

    public MergingUpdateQueue setRestartTimerOnAdd(boolean restart) {
        this.myRestartOnAdd = restart;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            return this.myScheduledUpdates.isEmpty();
        }
    }

    public void sendFlush() {
        this.restart(0);
    }

    public boolean isFlushing() {
        return this.myFlushing;
    }

    public void setTrackUiActivity(boolean trackUiActivity) {
        if (this.myTrackUiActivity && !trackUiActivity) {
            this.finishActivity();
        }
        this.myTrackUiActivity = trackUiActivity;
    }

    private void startActivity() {
        if (!this.myTrackUiActivity) {
            return;
        }
        UiActivityMonitor.getInstance().addActivity(this.getActivityId(), this.getModalityState());
    }

    private void finishActivity() {
        if (!this.myTrackUiActivity) {
            return;
        }
        UiActivityMonitor.getInstance().removeActivity(this.getActivityId());
    }

    @NotNull
    protected UiActivity getActivityId() {
        if (this.myUiActivity == null) {
            this.myUiActivity = new UiActivity.AsyncBgOperation("UpdateQueue:" + this.myName + this.hashCode());
        }
        UiActivity uiActivity = this.myUiActivity;
        if (uiActivity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/update/MergingUpdateQueue", "getActivityId"));
        }
        return uiActivity;
    }
}

