/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.create;

import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceBundleDialogComponent {
    private static final Logger LOG = Logger.getInstance(CreateResourceBundleDialogComponent.class);
    private static final Comparator<Locale> LOCALE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale l1, Locale l2) {
            if (l1 == PropertiesUtil.DEFAULT_LOCALE) {
                return -1;
            }
            if (l2 == PropertiesUtil.DEFAULT_LOCALE) {
                return 1;
            }
            return l1.toString().compareTo(l2.toString());
        }
    };
    private final Project myProject;
    private final PsiDirectory myDirectory;
    private JPanel myPanel;
    private JTextField myResourceBundleBaseNameTextField;
    private JButton myAddLocaleFromExistButton;
    private JPanel myNewBundleLocalesPanel;
    private JPanel myProjectExistLocalesPanel;
    private JButton myAddAllButton;
    private MyLocalesToAddModel myLocalesModel;

    public CreateResourceBundleDialogComponent(Project project, PsiDirectory directory) {
        this.myProject = project;
        this.myDirectory = directory;
        this.$$$setupUI$$$();
    }

    private List<PsiFile> createPropertiesFiles() {
        final String name = this.getBaseName();
        final Set fileNames = ContainerUtil.map2Set(this.myLocalesModel.getLocales(), (Function)new Function<Locale, String>(){

            public String fun(Locale locale) {
                return locale == PropertiesUtil.DEFAULT_LOCALE ? name + ".properties" : name + "_" + locale.toString() + ".properties";
            }
        });
        return (List)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<List<PsiFile>>(){

            public List<PsiFile> compute() {
                return ContainerUtil.map((Collection)fileNames, (Function)new Function<String, PsiFile>(){

                    public PsiFile fun(String n) {
                        return CreateResourceBundleDialogComponent.this.myDirectory.createFile(n);
                    }
                });
            }
        });
    }

    private String getBaseName() {
        return this.myResourceBundleBaseNameTextField.getText();
    }

    private String canCreateAllFilesForAllLocales() {
        String name = this.getBaseName();
        if (name.isEmpty()) {
            return "Base name is empty";
        }
        Set suffixes = ContainerUtil.map2Set(this.myLocalesModel.getLocales(), (Function)new Function<Locale, String>(){

            public String fun(Locale locale) {
                return locale.toString() + ".properties";
            }
        });
        if (suffixes.isEmpty()) {
            return "No locales added";
        }
        for (PsiElement element : this.myDirectory.getChildren()) {
            String fileNameSuffix;
            PropertiesFile propertiesFile;
            String propertiesFileName;
            if (!(element instanceof PsiFile) || !(element instanceof PropertiesFile) || !(propertiesFileName = (propertiesFile = (PropertiesFile)element).getName()).startsWith(name) || !suffixes.contains(fileNameSuffix = propertiesFileName.substring(name.length()))) continue;
            return "Some of files already exist";
        }
        return null;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    private static List<Locale> extractLocalesFromString(String rawLocales) {
        if (rawLocales.isEmpty()) {
            return Collections.emptyList();
        }
        String[] splitRawLocales = rawLocales.split(",");
        ArrayList<Locale> locales = new ArrayList<Locale>(splitRawLocales.length);
        for (String rawLocale : splitRawLocales) {
            Locale locale = PropertiesUtil.getLocale("_" + rawLocale + ".properties");
            if (locale == PropertiesUtil.DEFAULT_LOCALE) {
                return null;
            }
            if (locales.contains(locale)) continue;
            locales.add(locale);
        }
        return locales;
    }

    private void createUIComponents() {
        final JBList projectExistLocalesList = new JBList();
        final MyExistLocalesListModel existLocalesListModel = new MyExistLocalesListModel();
        projectExistLocalesList.setModel((ListModel)existLocalesListModel);
        projectExistLocalesList.setCellRenderer(CreateResourceBundleDialogComponent.getLocaleRenderer());
        this.myProjectExistLocalesPanel = ToolbarDecorator.createDecorator((JList)projectExistLocalesList).disableRemoveAction().disableUpDownActions().createPanel();
        this.myProjectExistLocalesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Project locales", (boolean)false));
        final JBList localesToAddList = new JBList();
        this.myLocalesModel = new MyLocalesToAddModel();
        localesToAddList.setModel((ListModel)this.myLocalesModel);
        localesToAddList.setCellRenderer(CreateResourceBundleDialogComponent.getLocaleRenderer());
        this.myNewBundleLocalesPanel = ToolbarDecorator.createDecorator((JList)localesToAddList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String rawAddedLocales = Messages.showInputDialog((Project)CreateResourceBundleDialogComponent.this.myProject, (String)PropertiesBundle.message("create.resource.bundle.dialog.add.locales.validator.message", new Object[0]), (String)PropertiesBundle.message("create.resource.bundle.dialog.add.locales.validator.title", new Object[0]), null, null, (InputValidator)new InputValidatorEx(){

                    @Nullable
                    public String getErrorText(String inputString) {
                        return this.checkInput(inputString) ? null : "Invalid locales";
                    }

                    public boolean checkInput(String inputString) {
                        return CreateResourceBundleDialogComponent.extractLocalesFromString(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                if (rawAddedLocales != null) {
                    List locales = CreateResourceBundleDialogComponent.extractLocalesFromString(rawAddedLocales);
                    LOG.assertTrue(locales != null);
                    CreateResourceBundleDialogComponent.this.myLocalesModel.addRows(locales);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CreateResourceBundleDialogComponent.this.myLocalesModel.removeRow(localesToAddList.getSelectedIndices());
            }
        }).disableUpDownActions().createPanel();
        this.myNewBundleLocalesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Locales to add", (boolean)false));
        this.myAddLocaleFromExistButton = new JButton(AllIcons.Actions.Forward);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$7", "onClick"));
                }
                if (clickCount == 1) {
                    CreateResourceBundleDialogComponent.this.myLocalesModel.addRows(ContainerUtil.map((Object[])projectExistLocalesList.getSelectedValues(), (Function)new Function<Object, Locale>(){

                        public Locale fun(Object o) {
                            return (Locale)o;
                        }
                    }));
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myAddLocaleFromExistButton);
        this.myAddAllButton = new JButton("Add All");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$8", "onClick"));
                }
                if (clickCount == 1) {
                    CreateResourceBundleDialogComponent.this.myLocalesModel.addRows(existLocalesListModel.getLocales());
                }
                return false;
            }
        }.installOn((Component)this.myAddAllButton);
    }

    @NotNull
    private static ColoredListCellRenderer<Locale> getLocaleRenderer() {
        ColoredListCellRenderer<Locale> coloredListCellRenderer = new ColoredListCellRenderer<Locale>(){

            protected void customizeCellRenderer(JList list, Locale locale, int index, boolean selected, boolean hasFocus) {
                if (PropertiesUtil.DEFAULT_LOCALE == locale) {
                    this.append("Default locale");
                } else {
                    this.append(locale.toString());
                    this.append(PropertiesUtil.getPresentableLocale(locale), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        };
        if (coloredListCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent", "getLocaleRenderer"));
        }
        return coloredListCellRenderer;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "North");
        this.myResourceBundleBaseNameTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Resource bundle base name:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, "Center");
        JButton jButton = this.myAddLocaleFromExistButton;
        jButton.setText("");
        jButton.setFocusable(false);
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = this.myNewBundleLocalesPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 2, 2, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = this.myProjectExistLocalesPanel;
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JButton jButton2 = this.myAddAllButton;
        jButton2.setText("Add All");
        jButton2.setFocusable(false);
        jPanel3.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyExistLocalesListModel
    extends AbstractListModel {
        private final List<Locale> myLocales = new ArrayList<Locale>();

        private MyExistLocalesListModel() {
            this.myLocales.add(PropertiesUtil.DEFAULT_LOCALE);
            PropertiesReferenceManager.getInstance(CreateResourceBundleDialogComponent.this.myProject).processPropertiesFiles(GlobalSearchScopesCore.projectProductionScope((Project)CreateResourceBundleDialogComponent.this.myProject), new PropertiesFileProcessor(){

                @Override
                public boolean process(String baseName, PropertiesFile propertiesFile) {
                    Locale locale = propertiesFile.getLocale();
                    if (locale != PropertiesUtil.DEFAULT_LOCALE && !MyExistLocalesListModel.this.myLocales.contains(locale)) {
                        MyExistLocalesListModel.this.myLocales.add(locale);
                    }
                    return true;
                }
            }, BundleNameEvaluator.DEFAULT);
            Collections.sort(this.myLocales, LOCALE_COMPARATOR);
        }

        @Override
        public int getSize() {
            return this.myLocales.size();
        }

        @Override
        public Locale getElementAt(int index) {
            return this.myLocales.get(index);
        }

        public List<Locale> getLocales() {
            return this.myLocales;
        }
    }

    private static class MyLocalesToAddModel
    extends AbstractListModel {
        private final List<Locale> myLocales = new ArrayList<Locale>();

        private MyLocalesToAddModel() {
            this.myLocales.add(PropertiesUtil.DEFAULT_LOCALE);
        }

        public List<Locale> getLocales() {
            return this.myLocales;
        }

        @Override
        public int getSize() {
            return this.myLocales.size();
        }

        @Override
        public Locale getElementAt(int index) {
            return this.myLocales.get(index);
        }

        public void addRows(List<Locale> toAdd) {
            boolean added = false;
            for (Locale locale : toAdd) {
                if (this.myLocales.contains(locale)) continue;
                this.myLocales.add(locale);
                if (added) continue;
                added = true;
            }
            if (added) {
                Collections.sort(this.myLocales, LOCALE_COMPARATOR);
                this.fireIntervalAdded(this, 0, this.myLocales.size());
            }
        }

        public void removeRow(int[] indices) {
            indices = Arrays.copyOf(indices, indices.length);
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.myLocales.remove(indices[i]);
            }
            this.fireIntervalRemoved(this, indices[0], indices[indices.length - 1]);
        }
    }

    public static class Dialog
    extends DialogWrapper {
        @Nullable
        private final Project myProject;
        private final PsiDirectory myDirectory;
        private CreateResourceBundleDialogComponent myComponent;
        private PsiElement[] myCreatedFiles;

        protected Dialog(@Nullable Project project, PsiDirectory directory) {
            super(project);
            this.myProject = project;
            this.myDirectory = directory;
            this.myComponent = new CreateResourceBundleDialogComponent(this.myProject, this.myDirectory);
            this.init();
            this.initValidation();
        }

        protected void doOKAction() {
            String errorString = this.myComponent.canCreateAllFilesForAllLocales();
            if (errorString != null) {
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)errorString);
            } else {
                List createFiles = this.myComponent.createPropertiesFiles();
                this.myCreatedFiles = createFiles.toArray(new PsiElement[createFiles.size()]);
                super.doOKAction();
            }
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myComponent.getPanel();
        }

        public PsiElement[] getCreatedFiles() {
            return this.myCreatedFiles;
        }
    }
}

