/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import git4idea.stash.GitStashUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShelveUtils {
    private static final Logger LOG = Logger.getInstance((String)GitShelveUtils.class.getName());

    public static void doSystemUnshelve(final Project project, final ShelvedChangeList shelvedChangeList, final ShelveChangesManager shelveManager, @NotNull ContinuationContext context, final @Nullable String leftConflictTitle, final @Nullable String rightConflictTitle) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "git4idea/stash/GitShelveUtils", "doSystemUnshelve"));
        }
        VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        final String projectPath = baseDir.getPath() + "/";
        context.next(new TaskDescriptor[]{new TaskDescriptor("Refreshing files before unshelve", Where.POOLED){

            public void run(ContinuationContext context) {
                LOG.info("doSystemUnshelve ");
                GitShelveUtils.refreshFilesBeforeUnshelve(project, shelvedChangeList, projectPath);
                LOG.info("doSystemUnshelve files refreshed. unshelving in AWT thread.");
            }
        }, new TaskDescriptor("", Where.AWT){

            public void run(ContinuationContext context) {
                LOG.info("Unshelving in UI thread. shelvedChangeList: " + shelvedChangeList);
                shelveManager.scheduleUnshelveChangeList(shelvedChangeList, shelvedChangeList.getChanges(project), shelvedChangeList.getBinaryFiles(), null, false, context, true, true, leftConflictTitle, rightConflictTitle);
            }
        }});
    }

    public static void refreshFilesBeforeUnshelve(Project project, ShelvedChangeList shelvedChangeList, String projectPath) {
        HashSet<File> filesToRefresh = new HashSet<File>();
        for (ShelvedChange c : shelvedChangeList.getChanges(project)) {
            if (c.getBeforePath() != null) {
                filesToRefresh.add(new File(projectPath + c.getBeforePath()));
            }
            if (c.getAfterPath() == null) continue;
            filesToRefresh.add(new File(projectPath + c.getAfterPath()));
        }
        for (ShelvedBinaryFile f : shelvedChangeList.getBinaryFiles()) {
            if (f.BEFORE_PATH != null) {
                filesToRefresh.add(new File(projectPath + f.BEFORE_PATH));
            }
            if (f.AFTER_PATH == null) continue;
            filesToRefresh.add(new File(projectPath + f.AFTER_PATH));
        }
        LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
    }

    @Nullable
    public static ShelvedChangeList shelveChanges(Project project, ShelveChangesManager shelveManager, Collection<Change> changes, String description, List<VcsException> exceptions, boolean rollback) {
        try {
            ShelvedChangeList shelve = shelveManager.shelveChanges(changes, description, rollback);
            ((ChangeListener)project.getMessageBus().syncPublisher(ShelveChangesManager.SHELF_TOPIC)).stateChanged(new ChangeEvent(GitStashUtils.class));
            return shelve;
        }
        catch (IOException e) {
            exceptions.add(new VcsException("Shelving changes failed: " + description, (Throwable)e));
            return null;
        }
        catch (VcsException e) {
            exceptions.add(e);
            return null;
        }
    }
}

