/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Charsets;
import kotlin.KotlinPackage$Strings$b7f6a928;
import kotlin.KotlinPackage$StringsJVM$37bda945;
import kotlin.KotlinPackage$_Aggregates$eb3aca90;
import kotlin.KotlinPackage$_Strings$2e429fe8;
import kotlin.Sequence;
import kotlin.Unit;
import kotlin.deprecated;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilePathComponents;
import kotlin.io.IoPackage$Console$1a4a059a;
import kotlin.io.IoPackage$FilePathComponents$383c2061;
import kotlin.io.IoPackage$FileTreeWalk$120a4f35;
import kotlin.io.IoPackage$IOStreams$d3f707a4;
import kotlin.io.IoPackage$Utils$ccafcec5;
import kotlin.io.IoPackage$sam$FileFilter$0f8d850b;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.io.TerminateException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class IoPackage$Utils$ccafcec5 {
    @NotNull
    public static final File createTempDir(@JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="suffix", type="?") @Nullable String suffix, @JetValueParameter(name="directory", type="?") @Nullable File directory) {
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        File dir = File.createTempFile(prefix, suffix, directory);
        dir.delete();
        if (dir.mkdir()) {
            File file = dir;
            Intrinsics.checkExpressionValueIsNotNull(file, "dir");
            return file;
        }
        throw (Throwable)new IOException("Unable to create temporary directory " + dir);
    }

    @NotNull
    public static /* synthetic */ File createTempDir$default(String string, String string2, File file, int n) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return IoPackage$Utils$ccafcec5.createTempDir(string, string2, file);
    }

    @NotNull
    public static final File createTempFile(@JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="suffix", type="?") @Nullable String suffix, @JetValueParameter(name="directory", type="?") @Nullable File directory) {
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        File file = File.createTempFile(prefix, suffix, directory);
        Intrinsics.checkExpressionValueIsNotNull(file, "File.createTempFile(prefix, suffix, directory)");
        return file;
    }

    @NotNull
    public static /* synthetic */ File createTempFile$default(String string, String string2, File file, int n) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return IoPackage$Utils$ccafcec5.createTempFile(string, string2, file);
    }

    @NotNull
    public static final File getDirectory(@JetValueParameter(name="$receiver") File $receiver) {
        File file;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isDirectory()) {
            file = $receiver;
        } else {
            file = IoPackage$Utils$ccafcec5.getParent($receiver);
            if (file == null) {
                Intrinsics.throwNpe();
            }
        }
        return file;
    }

    @Nullable
    public static final File getParent(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getParentFile();
    }

    @NotNull
    public static final String getCanonicalPath(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String string = $receiver.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull(string, "getCanonicalPath()");
        return string;
    }

    @NotNull
    public static final String getName(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String string = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "getName()");
        return string;
    }

    @NotNull
    public static final String getPath(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String string = $receiver.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string, "getPath()");
        return string;
    }

    @NotNull
    public static final String getExtension(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinPackage$Strings$b7f6a928.substringAfterLast(IoPackage$Utils$ccafcec5.getName($receiver), '.', "");
    }

    @NotNull
    public static final String separatorsToSystem(@JetValueParameter(name="$receiver") String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String otherSep = Intrinsics.areEqual(File.separator, "/") ? "\\" : "/";
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull(string, "File.separator");
        return KotlinPackage$StringsJVM$37bda945.replace$default($receiver, otherSep, string, false, 4);
    }

    @NotNull
    public static final String pathSeparatorsToSystem(@JetValueParameter(name="$receiver") String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String otherSep = Intrinsics.areEqual(File.pathSeparator, ":") ? ";" : ":";
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull(string, "File.pathSeparator");
        return KotlinPackage$StringsJVM$37bda945.replace$default($receiver, otherSep, string, false, 4);
    }

    @NotNull
    public static final String allSeparatorsToSystem(@JetValueParameter(name="$receiver") String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return IoPackage$Utils$ccafcec5.pathSeparatorsToSystem(IoPackage$Utils$ccafcec5.separatorsToSystem($receiver));
    }

    @NotNull
    public static final StringReader reader(@JetValueParameter(name="$receiver") String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new StringReader($receiver);
    }

    @NotNull
    public static final InputStream byteInputStream(@JetValueParameter(name="$receiver") String $receiver, @JetValueParameter(name="charset") @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new ByteArrayInputStream(KotlinPackage$StringsJVM$37bda945.toByteArray($receiver, charset));
    }

    @NotNull
    public static /* synthetic */ InputStream byteInputStream$default(String string, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return IoPackage$Utils$ccafcec5.byteInputStream(string, charset);
    }

    @NotNull
    public static final String separatorsToSystem(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return IoPackage$Utils$ccafcec5.separatorsToSystem($receiver.toString());
    }

    @NotNull
    public static final String getNameWithoutExtension(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinPackage$Strings$b7f6a928.substringBeforeLast$default(IoPackage$Utils$ccafcec5.getName($receiver), ".", null, 2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String relativeTo(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="base") @NotNull File base) {
        int i;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(base, "base");
        FilePathComponents components = IoPackage$FilePathComponents$383c2061.filePathComponents($receiver);
        FilePathComponents baseComponents = IoPackage$FilePathComponents$383c2061.filePathComponents(base);
        if (Intrinsics.areEqual(components.getRootName(), baseComponents.getRootName()) ^ true) {
            throw (Throwable)new IllegalArgumentException("this and base files have different roots: " + components.getRootName() + " and " + baseComponents.getRootName());
        }
        for (i = 0; i < components.size() && i < baseComponents.size() && Intrinsics.areEqual(components.getFileList().get(i), baseComponents.getFileList().get(i)); ++i) {
        }
        int sameCount = i;
        int baseCount = baseComponents.size();
        StringBuilder res = new StringBuilder();
        int n = sameCount;
        int n2 = baseCount - 2;
        if (n <= n2) {
            while (true) {
                void j;
                res.append("..").append(File.separator);
                if (j == n2) break;
                ++j;
            }
        }
        if (baseCount > sameCount) {
            res.append(sameCount < components.size() ? ".." + File.separator : "..");
        }
        if (sameCount < components.size() - 1) {
            res.append(components.subPath(sameCount, components.size() - 1)).append(File.separator);
        }
        if (sameCount < components.size()) {
            res.append(components.subPath(components.size() - 1, components.size()));
        }
        String string = res.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "res.toString()");
        return string;
    }

    @deprecated(value="Use relativeTo() function instead")
    @NotNull
    public static final String relativePath(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="descendant") @NotNull File descendant) {
        String string;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descendant, "descendant");
        String prefix = IoPackage$Utils$ccafcec5.getCanonicalPath(IoPackage$Utils$ccafcec5.getDirectory($receiver));
        String answer = IoPackage$Utils$ccafcec5.getCanonicalPath(descendant);
        if (KotlinPackage$StringsJVM$37bda945.startsWith$default(answer, prefix, false, 2)) {
            int prefixSize = prefix.length();
            string = answer.length() > prefixSize ? KotlinPackage$StringsJVM$37bda945.substring(answer, prefixSize + 1) : "";
        } else {
            string = answer;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final long copyTo(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="dst") @NotNull File dst, @JetValueParameter(name="overwrite") boolean overwrite, @JetValueParameter(name="bufferSize") int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(dst, "dst");
        if (!$receiver.exists()) {
            throw (Throwable)new NoSuchFileException($receiver, null, "The source file doesn't exist", 2, null);
        }
        if ($receiver.isDirectory()) {
            throw (Throwable)new IllegalArgumentException("Use copyRecursively to copy a directory " + $receiver);
        }
        if (dst.exists()) {
            if (!overwrite) {
                throw (Throwable)new FileAlreadyExistsException($receiver, dst, "The destination file already exists");
            }
            if (dst.isDirectory() && KotlinPackage$_Aggregates$eb3aca90.any((Object[])dst.listFiles())) {
                return IoPackage$Utils$ccafcec5.copyTo($receiver, IoPackage$Utils$ccafcec5.resolve(dst, IoPackage$Utils$ccafcec5.getName($receiver)), overwrite, bufferSize);
            }
        }
        v0 = dst.getParentFile();
        v1 = v0 != null ? Boolean.valueOf(v0.mkdirs()) : null;
        dst.delete();
        input = new FileInputStream($receiver);
        var5_5 = input;
        closed = false;
        try {
            it = (FileInputStream)$receiver;
            output = new FileOutputStream(dst);
            var9_12 = output;
            closed = false;
            try {
                it = (FileOutputStream)$receiver;
                it = IoPackage$IOStreams$d3f707a4.copyTo(input, output, bufferSize);
                ** try [egrp 2[TRYBLOCK] [4 : 252->284)] { 
            }
lbl46:
            // 1 sources

            catch (Throwable var11_16) {
                throw var11_16;
            }
            finally {
                if (!closed) {
                    $receiver.close();
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    v2 = it;
                }
                catch (Exception e) {
                    closed = true;
                    try {
                        $receiver.close();
                    }
                    catch (Exception closeException) {
                        // empty catch block
                    }
                    InlineMarker.goToTryCatchBlockEnd();
                    throw (Throwable)e;
                }
            }
            it = ((Number)v2).longValue();
            ** try [egrp 5[TRYBLOCK] [11 : 324->356)] { 
        }
lbl69:
        // 1 sources

        catch (Throwable var7_9) {
            throw var7_9;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                v3 = it;
            }
            catch (Exception e) {
                closed = true;
                try {
                    $receiver.close();
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                InlineMarker.goToTryCatchBlockEnd();
                throw (Throwable)e;
            }
        }
        return ((Number)v3).longValue();
    }

    public static /* synthetic */ long copyTo$default(File file, File file2, boolean bl, int n, int n2) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = IoPackage$Console$1a4a059a.defaultBufferSize;
        }
        return IoPackage$Utils$ccafcec5.copyTo(file, file2, bl, n);
    }

    public static final boolean copyRecursively(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="dst") @NotNull File dst, @JetValueParameter(name="onError") @NotNull Function2<? super File, ? super IOException, ? extends OnErrorAction> onError) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(dst, "dst");
        Intrinsics.checkParameterIsNotNull(onError, "onError");
        if (!$receiver.exists()) {
            return Intrinsics.areEqual((Object)onError.invoke($receiver, new NoSuchFileException($receiver, null, "The source file doesn't exist", 2, null)), (Object)OnErrorAction.TERMINATE) ^ true;
        }
        try {
            Iterator<File> iterator2 = IoPackage$FileTreeWalk$120a4f35.walkTopDown($receiver).fail((Function2<? super File, ? super IOException, ? extends Unit>)new Function2<File, IOException, Unit>(onError){
                final /* synthetic */ Function2 $onError;

                public final void invoke(@JetValueParameter(name="f") @NotNull File f, @JetValueParameter(name="e") @NotNull IOException e) {
                    Intrinsics.checkParameterIsNotNull(f, "f");
                    Intrinsics.checkParameterIsNotNull(e, "e");
                    if (Intrinsics.areEqual((Object)((Object)((OnErrorAction)((Object)this.$onError.invoke(f, e)))), (Object)((Object)OnErrorAction.TERMINATE))) {
                        throw (Throwable)new TerminateException(f);
                    }
                }
                {
                    this.$onError = function2;
                    super(2);
                }
            }).iterator();
            while (iterator2.hasNext()) {
                File src = iterator2.next();
                if (!src.exists()) {
                    if (!Intrinsics.areEqual((Object)onError.invoke(src, new NoSuchFileException(src, null, "The source file doesn't exist", 2, null)), (Object)OnErrorAction.TERMINATE)) continue;
                    return false;
                }
                String relPath = IoPackage$Utils$ccafcec5.relativeTo(src, $receiver);
                File dstFile = new File(dst, relPath);
                if (!(!dstFile.exists() || src.isDirectory() && dstFile.isDirectory())) {
                    if (!Intrinsics.areEqual((Object)onError.invoke(dstFile, new FileAlreadyExistsException(src, dstFile, "The destination file already exists")), (Object)OnErrorAction.TERMINATE)) continue;
                    return false;
                }
                if (src.isDirectory()) {
                    dstFile.mkdirs();
                    continue;
                }
                if (IoPackage$Utils$ccafcec5.copyTo$default(src, dstFile, true, 0, 4) == src.length() || !Intrinsics.areEqual((Object)onError.invoke(src, new IOException("src.length() != dst.length()")), (Object)OnErrorAction.TERMINATE)) continue;
                return false;
            }
            return true;
        }
        catch (TerminateException e) {
            return false;
        }
    }

    public static /* synthetic */ boolean copyRecursively$default(File file, File file2, Function2 function2, int n) {
        if ((n & 2) != 0) {
            function2 = copyRecursively.1.INSTANCE$;
        }
        return IoPackage$Utils$ccafcec5.copyRecursively(file, file2, function2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean deleteRecursively(@JetValueParameter(name="$receiver") File $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Sequence sequence2 = IoPackage$FileTreeWalk$120a4f35.walkBottomUp($receiver);
        boolean initial = $receiver.exists();
        boolean accumulator = initial;
        for (Object element : $receiver2) {
            void it2;
            File file = (File)element;
            boolean res = accumulator;
            accumulator = it2.delete() && res;
        }
        return (boolean)var3_3;
    }

    @Nullable
    public static final File[] listFiles(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="filter") @NotNull Function1<? super File, ? extends Boolean> filter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(filter, "filter");
        Function1<? super File, ? extends Boolean> function1 = filter;
        return $receiver.listFiles((FileFilter)(function1 == null ? null : new IoPackage$sam$FileFilter$0f8d850b(function1)));
    }

    public static final boolean startsWith(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="other") @NotNull File other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        FilePathComponents components = IoPackage$FilePathComponents$383c2061.filePathComponents($receiver);
        FilePathComponents otherComponents = IoPackage$FilePathComponents$383c2061.filePathComponents(other);
        if (Intrinsics.areEqual(components.getRootName(), otherComponents.getRootName()) ^ true && Intrinsics.areEqual(otherComponents.getRootName(), "") ^ true) {
            return false;
        }
        return components.size() < otherComponents.size() ? false : ((Object)components.getFileList().subList(0, otherComponents.size())).equals(otherComponents.getFileList());
    }

    public static final boolean startsWith(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="other") @NotNull String other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return IoPackage$Utils$ccafcec5.startsWith($receiver, new File(other));
    }

    public static final boolean endsWith(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="other") @NotNull File other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        FilePathComponents components = IoPackage$FilePathComponents$383c2061.filePathComponents($receiver);
        FilePathComponents otherComponents = IoPackage$FilePathComponents$383c2061.filePathComponents(other);
        if (Intrinsics.areEqual(components.getRootName(), otherComponents.getRootName()) ^ true && Intrinsics.areEqual(otherComponents.getRootName(), "") ^ true) {
            return false;
        }
        int shift = components.size() - otherComponents.size();
        return shift < 0 ? false : ((Object)components.getFileList().subList(shift, components.size())).equals(otherComponents.getFileList());
    }

    public static final boolean endsWith(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="other") @NotNull String other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return IoPackage$Utils$ccafcec5.endsWith($receiver, new File(other));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final File normalize(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        components = IoPackage$FilePathComponents$383c2061.filePathComponents($receiver);
        rootName = components.getRootName();
        list = new ArrayList<E>();
        block4: for (File file : components.getFileList()) {
            v0 = var7_7 = (name = file.toString());
            if (v0 != null) {
                switch (v0.hashCode()) {
                    case 1472: {
                        if (!var7_7.equals("..")) ** break;
                        break;
                    }
                    case 46: {
                        if (!var7_7.equals(".")) ** break;
                        continue block4;
                    }
                }
                if (!list.isEmpty() && Intrinsics.areEqual((String)list.get(list.size() - 1), "..") ^ true) {
                    list.remove(list.size() - 1);
                    continue;
                }
                list.add(name);
                continue;
            }
            v1 = name;
            Intrinsics.checkExpressionValueIsNotNull(v1, "name");
            list.add(v1);
        }
        v2 = list;
        v3 = File.separator;
        Intrinsics.checkExpressionValueIsNotNull(v3, "File.separator");
        return new File(KotlinPackage$_Strings$2e429fe8.joinToString$default(v2, v3, rootName, null, 0, null, null, 60));
    }

    @NotNull
    public static final File resolve(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="relative") @NotNull File relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        if (IoPackage$FilePathComponents$383c2061.getRoot(relative) != null) {
            return relative;
        }
        String ourName = $receiver.toString();
        return KotlinPackage$Strings$b7f6a928.endsWith$default(ourName, File.separatorChar, false, 2) ? new File(ourName + relative) : new File(ourName + File.separatorChar + relative);
    }

    @NotNull
    public static final File resolve(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="relative") @NotNull String relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        return IoPackage$Utils$ccafcec5.resolve($receiver, new File(relative));
    }

    @NotNull
    public static final File resolveSibling(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="relative") @NotNull File relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        FilePathComponents components = IoPackage$FilePathComponents$383c2061.filePathComponents($receiver);
        String rootName = components.getRootName();
        return components.size() == 0 ? relative : IoPackage$Utils$ccafcec5.resolve(IoPackage$Utils$ccafcec5.resolve(new File(rootName), components.subPath(0, components.size() - 1)), relative);
    }

    @NotNull
    public static final File resolveSibling(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="relative") @NotNull String relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        return IoPackage$Utils$ccafcec5.resolveSibling($receiver, new File(relative));
    }
}

