/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.GuardedBy;
import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.Update;
import com.android.sdklib.repository.local.UpdateResult;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.SdkLifecycleListener;
import com.android.utils.ILogger;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.reference.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkData;

public class SdkState {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.sdk.SdkState");
    @GuardedBy(value="sSdkStates")
    private static final Set<SoftReference<SdkState>> sSdkStates = new HashSet<SoftReference<SdkState>>();
    @NonNull
    private final AndroidSdkData mySdkData;
    private LocalPkgInfo[] myLocalPkgInfos = new LocalPkgInfo[0];
    private SdkSources mySources;
    private UpdateResult myUpdates;
    private Multimap<PkgType, RemotePkgInfo> myRemotePkgs;
    private long myLastRefreshMs;
    private BackgroundableProcessIndicator myIndicator;

    private SdkState(@NonNull AndroidSdkData sdkData) {
        this.mySdkData = sdkData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static SdkState getInstance(@NonNull AndroidSdkData sdkData) {
        Set<SoftReference<SdkState>> set = sSdkStates;
        synchronized (set) {
            Iterator<SoftReference<SdkState>> it = sSdkStates.iterator();
            while (it.hasNext()) {
                SoftReference<SdkState> ref = it.next();
                SdkState s = (SdkState)ref.get();
                if (s == null) {
                    it.remove();
                    continue;
                }
                if (s.mySdkData != sdkData) continue;
                return s;
            }
            SdkState s = new SdkState(sdkData);
            sSdkStates.add((SoftReference<SdkState>)new SoftReference((Object)s));
            return s;
        }
    }

    @NonNull
    public AndroidSdkData getSdkData() {
        return this.mySdkData;
    }

    @NonNull
    public LocalPkgInfo[] getLocalPkgInfos() {
        return this.myLocalPkgInfos;
    }

    @Nullable
    public UpdateResult getUpdates() {
        return this.myUpdates;
    }

    public boolean loadAsync(long timeoutMs, boolean canBeCancelled, @Nullable Runnable onSuccess, @Nullable Runnable onError) {
        if (this.myIndicator != null) {
            return false;
        }
        if (System.currentTimeMillis() - this.myLastRefreshMs < timeoutMs) {
            return false;
        }
        LoadTask task = new LoadTask(canBeCancelled, onSuccess, onError);
        this.myIndicator = new BackgroundableProcessIndicator((Task.Backgroundable)task);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)this.myIndicator);
        return true;
    }

    static /* synthetic */ LocalPkgInfo[] access$002(SdkState x0, LocalPkgInfo[] x1) {
        x0.myLocalPkgInfos = x1;
        return x1;
    }

    private class LoadTask
    extends Task.Backgroundable {
        @Nullable
        private final Runnable myOnSuccess;
        @Nullable
        private final Runnable myOnError;

        public LoadTask(@Nullable boolean canBeCancelled, @Nullable Runnable onSuccess, Runnable onError) {
            super(null, "Loading Android SDK", canBeCancelled, PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.myOnSuccess = onSuccess;
            this.myOnError = onError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NonNull ProgressIndicator indicator) {
            boolean success = false;
            try {
                IndicatorLogger logger = new IndicatorLogger(indicator);
                ApplicationEx app = ApplicationManagerEx.getApplicationEx();
                SdkLifecycleListener notifier = (SdkLifecycleListener)app.getMessageBus().syncPublisher(SdkLifecycleListener.TOPIC);
                indicator.setText("Loading local SDK...");
                indicator.setText2("");
                SdkState.access$002(SdkState.this, SdkState.this.mySdkData.getLocalSdk().getPkgsInfos(PkgType.PKG_ALL));
                notifier.localSdkLoaded(SdkState.this.mySdkData);
                indicator.setFraction(0.25);
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText("Find SDK Repository...");
                indicator.setText2("");
                SdkState.this.mySources = SdkState.this.mySdkData.getRemoteSdk().fetchSources(86400000L, (ILogger)logger);
                indicator.setFraction(0.5);
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText("Check SDK Repository...");
                indicator.setText2("");
                SdkState.this.myRemotePkgs = SdkState.this.mySdkData.getRemoteSdk().fetch(SdkState.this.mySources, (ILogger)logger);
                notifier.remoteSdkLoaded(SdkState.this.mySdkData);
                indicator.setFraction(0.75);
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText("Compute SDK updates...");
                indicator.setText2("");
                SdkState.this.myUpdates = Update.computeUpdates((LocalPkgInfo[])SdkState.this.myLocalPkgInfos, (Multimap)SdkState.this.myRemotePkgs);
                notifier.updatesComputed(SdkState.this.mySdkData);
                indicator.setFraction(1.0);
                success = true;
                if (this.myOnSuccess != null) {
                    ApplicationManager.getApplication().invokeLater(this.myOnSuccess);
                }
            }
            finally {
                SdkState.this.myIndicator = null;
                SdkState.this.myLastRefreshMs = System.currentTimeMillis();
                if (!success && this.myOnError != null) {
                    ApplicationManager.getApplication().invokeLater(this.myOnError);
                }
            }
        }
    }

    private static class IndicatorLogger
    implements ILogger {
        @NonNull
        private final ProgressIndicator myIndicator;

        public IndicatorLogger(@NonNull ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }

        public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
            if (msgFormat == null && t != null) {
                this.myIndicator.setText2(t.toString());
            } else if (msgFormat != null) {
                this.myIndicator.setText2(String.format(msgFormat, args));
            }
        }

        public void warning(@NonNull String msgFormat, Object ... args) {
            this.myIndicator.setText2(String.format(msgFormat, args));
        }

        public void info(@NonNull String msgFormat, Object ... args) {
            this.myIndicator.setText2(String.format(msgFormat, args));
        }

        public void verbose(@NonNull String msgFormat, Object ... args) {
        }
    }
}

