/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardUtils {
    private static final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>]");

    @NotNull
    public static String computeModuleName(@NotNull String appName, @Nullable Project project) {
        if (appName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appName", "com/android/tools/idea/wizard/WizardUtils", "computeModuleName"));
        }
        String moduleName = appName.toLowerCase().replaceAll("[/\\\\?%*:|\"<>]", "");
        if (!WizardUtils.isUniqueModuleName(moduleName = moduleName.replaceAll("\\s", ""), project)) {
            int i = 2;
            while (!WizardUtils.isUniqueModuleName(moduleName + Integer.toString(i), project)) {
                ++i;
            }
            moduleName = moduleName + Integer.toString(i);
        }
        String string = moduleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "computeModuleName"));
        }
        return string;
    }

    public static boolean isUniqueModuleName(@NotNull String moduleName, @Nullable Project project) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/wizard/WizardUtils", "isUniqueModuleName"));
        }
        if (project == null) {
            return true;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module m : moduleManager.getModules()) {
            if (!m.getName().equalsIgnoreCase(moduleName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static ValidationResult validateLocation(@Nullable String projectLocation) {
        ValidationResult validationResult = WizardUtils.validateLocation(projectLocation, "project location", true);
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
        }
        return validationResult;
    }

    @NotNull
    public static ValidationResult validateLocation(@Nullable String projectLocation, @NotNull String fieldName, boolean checkEmpty) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
        }
        ValidationResult warningResult = null;
        if (projectLocation == null || projectLocation.isEmpty()) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.NO_LOCATION_SPECIFIED, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (File.separatorChar == '/' && projectLocation.contains("\\") || File.separatorChar == '\\' && projectLocation.contains("/")) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.BAD_SLASHES, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        for (File testFile = new File(projectLocation); testFile != null; testFile = testFile.getParentFile()) {
            String filename = testFile.getName();
            if (ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)filename)) {
                char illegalChar = filename.charAt(ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)filename));
                ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.ILLEGAL_CHARACTER, fieldName, Character.valueOf(illegalChar), filename);
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
                }
                return validationResult;
            }
            if (WizardConstants.INVALID_WINDOWS_FILENAMES.contains(filename.toLowerCase())) {
                ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.ILLEGAL_FILENAME, fieldName, filename);
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
                }
                return validationResult;
            }
            if (CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)filename)) {
                warningResult = ValidationResult.warn(ValidationResult.Message.WHITESPACE, fieldName, new Object[0]);
            }
            if (!CharMatcher.ASCII.matchesAllOf((CharSequence)filename)) {
                warningResult = ValidationResult.warn(ValidationResult.Message.NON_ASCII_CHARS, fieldName, new Object[0]);
            }
            if (testFile.exists() || testFile.getParentFile() == null || !testFile.getParentFile().exists() || testFile.getParentFile().canWrite()) continue;
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.PATH_NOT_WRITEABLE, fieldName, testFile.getParentFile().getPath());
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        File file = new File(projectLocation);
        if (file.isFile()) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.PROJECT_LOC_IS_FILE, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (file.getParent() == null) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.PROJECT_IS_FILE_SYSTEM_ROOT, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (file.getParentFile().exists() && !file.getParentFile().isDirectory()) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.PARENT_NOT_DIR, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        String installLocation = PathManager.getHomePathFor(Application.class);
        if (installLocation != null && FileUtil.isAncestor((File)new File(installLocation), (File)file, (boolean)false)) {
            String applicationName = ApplicationNamesInfo.getInstance().getProductName();
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.INSIDE_ANDROID_STUDIO, fieldName, applicationName);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (checkEmpty && file.exists() && TemplateUtils.listFiles(file).length > 0) {
            ValidationResult validationResult = ValidationResult.warn(ValidationResult.Message.NON_EMPTY_DIR, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        ValidationResult validationResult = warningResult == null ? ValidationResult.OK : warningResult;
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils", "validateLocation"));
        }
        return validationResult;
    }

    public static class ValidationResult {
        public static final ValidationResult OK = new ValidationResult(Status.OK, null, "any", new Object[0]);
        private final Status myStatus;
        private final Message myMessage;
        private final Object[] myMessageParams;

        private ValidationResult(@NotNull Status status, @Nullable Message message, @NotNull String field, Object ... messageParams) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/android/tools/idea/wizard/WizardUtils$ValidationResult", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/wizard/WizardUtils$ValidationResult", "<init>"));
            }
            this.myStatus = status;
            this.myMessage = message;
            this.myMessageParams = ArrayUtil.prepend((Object)field, (Object[])messageParams);
        }

        public static ValidationResult warn(@NotNull Message message, String field, Object ... params) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/wizard/WizardUtils$ValidationResult", "warn"));
            }
            return new ValidationResult(Status.WARN, message, field, params);
        }

        public static ValidationResult error(@NotNull Message message, String field, Object ... params) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/wizard/WizardUtils$ValidationResult", "error"));
            }
            return new ValidationResult(Status.ERROR, message, field, params);
        }

        @Nullable
        Message getMessage() {
            return this.myMessage;
        }

        Object[] getMessageParams() {
            return this.myMessageParams;
        }

        public String getFormattedMessage() {
            if (this.myMessage == null) {
                throw new IllegalStateException("Null message, are you trying to get the message of an OK?");
            }
            return String.format(this.myMessage.toString(), this.myMessageParams);
        }

        @NotNull
        public Status getStatus() {
            Status status = this.myStatus;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/WizardUtils$ValidationResult", "getStatus"));
            }
            return status;
        }

        public boolean isError() {
            return this.myStatus.equals((Object)Status.ERROR);
        }

        public boolean isOk() {
            return this.myStatus.equals((Object)Status.OK);
        }

        public static enum Message {
            NO_LOCATION_SPECIFIED("Please specify a %1s"),
            BAD_SLASHES("Your %1s contains incorrect slashes ('\\' vs '/')"),
            ILLEGAL_CHARACTER("Illegal character in %1s path: '%2c' in filename %3s"),
            ILLEGAL_FILENAME("Illegal filename in %1s path: %2s"),
            WHITESPACE("Your %1s contains whitespace. This can cause problems on some platforms and is not recommended."),
            NON_ASCII_CHARS("Your %1s contains non-ASCII characters. This can cause problems on Windows. Proceed with caution."),
            PATH_NOT_WRITEABLE("The path '%2s' is not writeable. Please choose a new location."),
            PROJECT_LOC_IS_FILE("There must not already be a file at the %1s."),
            NON_EMPTY_DIR("A non-empty directory already exists at the specified %1s. Existing files may be overwritten. Proceed with caution."),
            PROJECT_IS_FILE_SYSTEM_ROOT("The %1s can not be at the filesystem root"),
            IS_UNDER_ANDROID_STUDIO_ROOT("Path points to a location within Android Studio installation directory"),
            PARENT_NOT_DIR("The %1s's parent directory must be a directory, not a plain file"),
            INSIDE_ANDROID_STUDIO("The %1s is inside %2s install location");

            private final String myText;

            private Message(String text) {
                this.myText = text;
            }

            public String toString() {
                return this.myText;
            }
        }

        public static enum Status {
            OK,
            WARN,
            ERROR;

        }
    }
}

