/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompilerOutputParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseCompilerMessagesFromReader(MessageCollector messageCollector, final Reader reader, OutputItemsCollector collector) {
        final StringBuilder stringBuilder = new StringBuilder();
        Reader wrappingReader = new Reader(){

            @Override
            public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
                if (cbuf == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbuf", "org/jetbrains/kotlin/compilerRunner/CompilerOutputParser$1", "read"));
                }
                int read = reader.read(cbuf, off, len);
                stringBuilder.append(cbuf, off, len);
                return read;
            }

            @Override
            public void close() throws IOException {
            }
        };
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(wrappingReader), (DefaultHandler)new CompilerOutputSAXHandler(messageCollector, collector));
        }
        catch (Throwable e) {
            try {
                FileUtil.loadTextAndClose((Reader)wrappingReader);
            }
            catch (IOException ioException) {
                MessageCollectorUtil.reportException(messageCollector, ioException);
            }
            String message = stringBuilder.toString();
            MessageCollectorUtil.reportException(messageCollector, new IllegalStateException(message, e));
            messageCollector.report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                MessageCollectorUtil.reportException(messageCollector, e);
            }
        }
    }

    private static class CompilerOutputSAXHandler
    extends DefaultHandler {
        private static final Map<String, CompilerMessageSeverity> CATEGORIES = new ContainerUtil.ImmutableMapBuilder().put((Object)"error", (Object)CompilerMessageSeverity.ERROR).put((Object)"warning", (Object)CompilerMessageSeverity.WARNING).put((Object)"logging", (Object)CompilerMessageSeverity.LOGGING).put((Object)"output", (Object)CompilerMessageSeverity.OUTPUT).put((Object)"exception", (Object)CompilerMessageSeverity.EXCEPTION).put((Object)"info", (Object)CompilerMessageSeverity.INFO).put((Object)"messages", (Object)CompilerMessageSeverity.INFO).build();
        private final MessageCollector messageCollector;
        private final OutputItemsCollector collector;
        private final StringBuilder message = new StringBuilder();
        private final Stack<String> tags = new Stack();
        private String path;
        private int line;
        private int column;

        public CompilerOutputSAXHandler(MessageCollector messageCollector, OutputItemsCollector collector) {
            this.messageCollector = messageCollector;
            this.collector = collector;
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            if (uri == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler", "startElement"));
            }
            if (localName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "org/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler", "startElement"));
            }
            if (qName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler", "startElement"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler", "startElement"));
            }
            this.tags.push((Object)qName);
            this.message.setLength(0);
            this.path = attributes.getValue("path");
            this.line = CompilerOutputSAXHandler.safeParseInt(attributes.getValue("line"), -1);
            this.column = CompilerOutputSAXHandler.safeParseInt(attributes.getValue("column"), -1);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.tags.size() == 1) {
                String message = new String(ch, start, length);
                if (!message.trim().isEmpty()) {
                    this.messageCollector.report(CompilerMessageSeverity.ERROR, "Unhandled compiler output: " + message, CompilerMessageLocation.NO_LOCATION);
                }
            } else {
                this.message.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            if (localName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "org/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler", "endElement"));
            }
            if (qName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler", "endElement"));
            }
            if (this.tags.size() == 1) {
                return;
            }
            String qNameLowerCase = qName.toLowerCase();
            CompilerMessageSeverity category = CATEGORIES.get(qNameLowerCase);
            if (category == null) {
                this.messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown compiler message tag: " + qName, CompilerMessageLocation.NO_LOCATION);
                category = CompilerMessageSeverity.INFO;
            }
            String text = this.message.toString();
            if (category == CompilerMessageSeverity.OUTPUT) {
                this.reportToCollector(text);
            } else {
                this.messageCollector.report(category, text, CompilerMessageLocation.create(this.path, this.line, this.column));
            }
            this.tags.pop();
        }

        private void reportToCollector(String text) {
            OutputMessageUtil.Output output = OutputMessageUtil.parseOutputMessage(text);
            if (output != null) {
                this.collector.add(output.sourceFiles, output.outputFile);
            }
        }

        private static int safeParseInt(@Nullable String value, int defaultValue) {
            if (value == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
    }
}

