/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unsorted;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unsorted.AlphaUnsortedPropertiesFileInspectionSuppressor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AlphaUnsortedPropertiesFileInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AlphaUnsortedPropertiesFileInspection.class);
    private static final String MESSAGE_TEMPLATE_WHOLE_RESOURCE_BUNDLE = "Property keys of resource bundle '%s' aren't alphabetically sorted";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitFile(PsiFile file) {
                PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
                if (!(propertiesFile instanceof PropertiesFileImpl)) {
                    return;
                }
                for (AlphaUnsortedPropertiesFileInspectionSuppressor filter : (AlphaUnsortedPropertiesFileInspectionSuppressor[])AlphaUnsortedPropertiesFileInspectionSuppressor.EP_NAME.getExtensions()) {
                    if (!filter.suppressInspectionFor(propertiesFile)) continue;
                    return;
                }
                String resourceBundleBaseName = propertiesFile.getResourceBundle().getBaseName();
                if (!AlphaUnsortedPropertiesFileInspection.isResourceBundleAlphaSortedExceptOneFile(propertiesFile.getResourceBundle(), propertiesFile)) {
                    holder.registerProblem((PsiElement)file, String.format(AlphaUnsortedPropertiesFileInspection.MESSAGE_TEMPLATE_WHOLE_RESOURCE_BUNDLE, resourceBundleBaseName), ProblemHighlightType.INFO, new LocalQuickFix[]{new PropertiesSorterQuickFix(true, new PropertiesFile[]{propertiesFile})});
                    return;
                }
                if (!propertiesFile.isAlphaSorted()) {
                    holder.registerProblem((PsiElement)file, "Properties file is unsorted", ProblemHighlightType.INFO, new LocalQuickFix[]{new PropertiesSorterQuickFix(true, new PropertiesFile[]{propertiesFile})});
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static boolean isResourceBundleAlphaSortedExceptOneFile(@NotNull ResourceBundle resourceBundle, @NotNull PropertiesFile exceptedFile) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection", "isResourceBundleAlphaSortedExceptOneFile"));
        }
        if (exceptedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptedFile", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection", "isResourceBundleAlphaSortedExceptOneFile"));
        }
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            if (!(file instanceof PropertiesFileImpl)) {
                return true;
            }
            if (file.equals(exceptedFile) || file.isAlphaSorted()) continue;
            return false;
        }
        return true;
    }

    private static void sortPropertiesFile(PropertiesFile file) {
        ArrayList<IProperty> properties = new ArrayList<IProperty>(file.getProperties());
        Collections.sort(properties, new Comparator<IProperty>(){

            @Override
            public int compare(IProperty p1, IProperty p2) {
                return Comparing.compare((Comparable)((Object)p1.getKey()), (Comparable)((Object)p2.getKey()));
            }
        });
        char delimiter = PropertiesCodeStyleSettings.getInstance((Project)file.getProject()).KEY_VALUE_DELIMITER;
        StringBuilder rawText = new StringBuilder();
        for (int i = 0; i < properties.size(); ++i) {
            IProperty property = (IProperty)properties.get(i);
            String value = property.getUnescapedValue();
            rawText.append(PropertiesElementFactory.getPropertyText(property.getKey(), value != null ? value : "", Character.valueOf(delimiter), null));
            if (i == properties.size() - 1) continue;
            rawText.append("\n");
        }
        PropertiesFile fakeFile = PropertiesElementFactory.createPropertiesFile(file.getProject(), rawText.toString());
        PropertiesList propertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)file.getContainingFile(), PropertiesList.class);
        LOG.assertTrue(propertiesList != null);
        PropertiesList fakePropertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)fakeFile.getContainingFile(), PropertiesList.class);
        LOG.assertTrue(fakePropertiesList != null);
        propertiesList.replace((PsiElement)fakePropertiesList);
    }

    @NotNull
    public String getDisplayName() {
        if ("Alphabetically Unsorted Properties File or Resource Bundle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection", "getDisplayName"));
        }
        return "Alphabetically Unsorted Properties File or Resource Bundle";
    }

    @NotNull
    public String getShortName() {
        if ("AlphaUnsortedPropertiesFile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection", "getShortName"));
        }
        return "AlphaUnsortedPropertiesFile";
    }

    private static class PropertiesSorterQuickFix
    implements LocalQuickFix {
        private final boolean myWholeResourceBundle;
        private final PropertiesFile[] myFilesToSort;

        private PropertiesSorterQuickFix(boolean wholeResourceBundle, PropertiesFile ... toSort) {
            this.myWholeResourceBundle = wholeResourceBundle;
            this.myFilesToSort = toSort;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$PropertiesSorterQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myWholeResourceBundle ? "Sort resource bundle files" : "Sort properties file";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$PropertiesSorterQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$PropertiesSorterQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$PropertiesSorterQuickFix", "applyFix"));
            }
            boolean force = this.myFilesToSort.length == 1;
            for (PropertiesFile file : this.myFilesToSort) {
                if (!force && file.isAlphaSorted()) continue;
                AlphaUnsortedPropertiesFileInspection.sortPropertiesFile(file);
            }
        }
    }
}

