/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionParameters {
    private final PsiElement myPosition;
    private final PsiFile myOriginalFile;
    private final CompletionType myCompletionType;
    private final Editor myEditor;
    private final int myOffset;
    private final int myInvocationCount;

    CompletionParameters(@NotNull PsiElement position, @NotNull PsiFile originalFile, @NotNull CompletionType completionType, int offset, int invocationCount, @NotNull Editor editor) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/CompletionParameters", "<init>"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/codeInsight/completion/CompletionParameters", "<init>"));
        }
        if (completionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionType", "com/intellij/codeInsight/completion/CompletionParameters", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CompletionParameters", "<init>"));
        }
        assert (position.getTextRange().containsOffset(offset)) : position;
        this.myPosition = position;
        assert (position.isValid());
        this.myOriginalFile = originalFile;
        this.myCompletionType = completionType;
        this.myOffset = offset;
        this.myInvocationCount = invocationCount;
        this.myEditor = editor;
    }

    @NotNull
    public CompletionParameters delegateToClassName() {
        CompletionParameters completionParameters = this.withType(CompletionType.CLASS_NAME).withInvocationCount(this.myInvocationCount - 1);
        if (completionParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "delegateToClassName"));
        }
        return completionParameters;
    }

    @NotNull
    public CompletionParameters withType(@NotNull CompletionType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/completion/CompletionParameters", "withType"));
        }
        CompletionParameters completionParameters = new CompletionParameters(this.myPosition, this.myOriginalFile, type, this.myOffset, this.myInvocationCount, this.myEditor);
        if (completionParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "withType"));
        }
        return completionParameters;
    }

    @NotNull
    public CompletionParameters withInvocationCount(int newCount) {
        CompletionParameters completionParameters = new CompletionParameters(this.myPosition, this.myOriginalFile, this.myCompletionType, this.myOffset, newCount, this.myEditor);
        if (completionParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "withInvocationCount"));
        }
        return completionParameters;
    }

    @NotNull
    public PsiElement getPosition() {
        PsiElement psiElement = this.myPosition;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "getPosition"));
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getOriginalPosition() {
        return this.myOriginalFile.findElementAt(this.myPosition.getTextRange().getStartOffset());
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "getOriginalFile"));
        }
        return psiFile;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "getCompletionType"));
        }
        return completionType;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }

    public boolean isAutoPopup() {
        return this.myInvocationCount == 0;
    }

    @NotNull
    public CompletionParameters withPosition(@NotNull PsiElement element, int offset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/CompletionParameters", "withPosition"));
        }
        CompletionParameters completionParameters = new CompletionParameters(element, this.myOriginalFile, this.myCompletionType, offset, this.myInvocationCount, this.myEditor);
        if (completionParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "withPosition"));
        }
        return completionParameters;
    }

    public boolean isExtendedCompletion() {
        return this.myCompletionType == CompletionType.BASIC && this.myInvocationCount >= 2;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionParameters", "getEditor"));
        }
        return editor;
    }
}

