/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class EditSourceUtil {
    private EditSourceUtil() {
    }

    @Nullable
    public static Navigatable getDescriptor(PsiElement element) {
        PsiElement original = EditSourceUtil.getNavigatableOriginalElement(element);
        if (original != null) {
            element = original;
        } else if (!EditSourceUtil.canNavigate(element)) {
            return null;
        }
        if (element instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)element).getTarget();
        }
        PsiElement navigationElement = element.getNavigationElement();
        if (navigationElement instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)navigationElement).getTarget();
        }
        int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile(navigationElement);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        OpenFileDescriptor desc = new OpenFileDescriptor(navigationElement.getProject(), virtualFile, offset);
        desc.setUseCurrentWindow(FileEditorManager.USE_CURRENT_WINDOW.isIn((UserDataHolder)navigationElement));
        return desc;
    }

    private static PsiElement getNavigatableOriginalElement(PsiElement element) {
        List<? extends PsiElement> originalElements = GeneratedSourcesFilter.collectAllOriginalElements(element);
        for (PsiElement psiElement : originalElements) {
            if (!EditSourceUtil.canNavigate(psiElement)) continue;
            return psiElement;
        }
        return null;
    }

    public static boolean canNavigate(PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile(element.getNavigationElement());
        return file != null && file.isValid() && !file.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink(file);
    }

    public static void navigate(NavigationItem item, boolean requestFocus, boolean useCurrentWindow) {
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)useCurrentWindow);
        }
        item.navigate(requestFocus);
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        }
    }
}

