/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GeneratedSourcesFilter {
    public static final ExtensionPointName<GeneratedSourcesFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.generatedSourcesFilter");

    public static boolean isGeneratedSourceByAnyFilter(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/GeneratedSourcesFilter", "isGeneratedSourceByAnyFilter"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/GeneratedSourcesFilter", "isGeneratedSourceByAnyFilter"));
        }
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])EP_NAME.getExtensions()) {
            if (!filter.isGeneratedSource(file, project)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<? extends PsiElement> collectAllOriginalElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllOriginalElements"));
        }
        List<? extends PsiElement> result = null;
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])EP_NAME.getExtensions()) {
            result = GeneratedSourcesFilter.addAll(filter.getOriginalElements(element), result);
        }
        List list = GeneratedSourcesFilter.orEmpty(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllOriginalElements"));
        }
        return list;
    }

    @NotNull
    public static List<? extends PsiElement> collectAllGeneratedElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllGeneratedElements"));
        }
        List<? extends PsiElement> result = null;
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])EP_NAME.getExtensions()) {
            result = GeneratedSourcesFilter.addAll(filter.getGeneratedElements(element), result);
        }
        List list = GeneratedSourcesFilter.orEmpty(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllGeneratedElements"));
        }
        return list;
    }

    @NotNull
    public static List<? extends LocationInFile> collectAllOriginalLocations(@NotNull Project project, @NotNull VirtualFile file, @Nullable Segment segment) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllOriginalLocations"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllOriginalLocations"));
        }
        List<? extends LocationInFile> result = null;
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])EP_NAME.getExtensions()) {
            result = GeneratedSourcesFilter.addAll(filter.getOriginalLocations(project, file, segment), result);
        }
        List list = GeneratedSourcesFilter.orEmpty(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllOriginalLocations"));
        }
        return list;
    }

    @NotNull
    public static List<? extends LocationInFile> collectAllGeneratedLocations(@NotNull Project project, @NotNull VirtualFile file, @Nullable Segment segment) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllGeneratedLocations"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllGeneratedLocations"));
        }
        List<? extends LocationInFile> result = null;
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])EP_NAME.getExtensions()) {
            result = GeneratedSourcesFilter.addAll(filter.getGeneratedLocations(project, file, segment), result);
        }
        List list = GeneratedSourcesFilter.orEmpty(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "collectAllGeneratedLocations"));
        }
        return list;
    }

    private static <T> List<T> addAll(List<? extends T> elements, List<T> result) {
        if (result == null) {
            return ContainerUtil.newArrayList(elements);
        }
        result.addAll(elements);
        return result;
    }

    private static <T> List<T> orEmpty(List<T> elements) {
        if (elements != null) {
            return elements;
        }
        return Collections.emptyList();
    }

    public abstract boolean isGeneratedSource(@NotNull VirtualFile var1, @NotNull Project var2);

    @NotNull
    public List<? extends PsiElement> getOriginalElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getOriginalElements"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getOriginalElements"));
        }
        return list;
    }

    @NotNull
    public List<? extends PsiElement> getGeneratedElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getGeneratedElements"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getGeneratedElements"));
        }
        return list;
    }

    @NotNull
    public List<? extends LocationInFile> getOriginalLocations(@NotNull Project project, @NotNull VirtualFile file, @Nullable Segment segment) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getOriginalLocations"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getOriginalLocations"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getOriginalLocations"));
        }
        return list;
    }

    @NotNull
    public List<? extends LocationInFile> getGeneratedLocations(@NotNull Project project, @NotNull VirtualFile file, @Nullable Segment segment) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getGeneratedLocations"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getGeneratedLocations"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getGeneratedLocations"));
        }
        return list;
    }

    public static class LocationInFile {
        @NotNull
        private final VirtualFile myFile;
        @Nullable
        private final Segment mySegment;

        public LocationInFile(@NotNull VirtualFile file, @Nullable Segment segment) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/GeneratedSourcesFilter$LocationInFile", "<init>"));
            }
            this.myFile = file;
            this.mySegment = segment;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter$LocationInFile", "getFile"));
            }
            return virtualFile;
        }

        @Nullable
        public Segment getSegment() {
            return this.mySegment;
        }

        public String toString() {
            return "LocationInFile{myFile=" + this.myFile + ", mySegment=" + this.mySegment + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocationInFile that = (LocationInFile)o;
            if (!this.myFile.equals(that.myFile)) {
                return false;
            }
            return !(this.mySegment != null ? !this.mySegment.equals(that.mySegment) : that.mySegment != null);
        }

        public int hashCode() {
            int result = this.myFile.hashCode();
            result = 31 * result + (this.mySegment != null ? this.mySegment.hashCode() : 0);
            return result;
        }
    }
}

