/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesUtil {
    private static final Key<Boolean> INTERNAL_OPERATION_KEY = Key.create((String)"internal vcs operation");

    private ChangesUtil() {
    }

    @NotNull
    public static FilePath getFilePath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getFilePath"));
        }
        ContentRevision revision = change.getAfterRevision();
        if (revision == null) {
            revision = change.getBeforeRevision();
            assert (revision != null);
        }
        FilePath filePath = revision.getFile();
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getFilePath"));
        }
        return filePath;
    }

    @Nullable
    public static FilePath getBeforePath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getBeforePath"));
        }
        ContentRevision revision = change.getBeforeRevision();
        return revision == null ? null : revision.getFile();
    }

    @Nullable
    public static FilePath getAfterPath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getAfterPath"));
        }
        ContentRevision revision = change.getAfterRevision();
        return revision == null ? null : revision.getFile();
    }

    public static AbstractVcs getVcsForChange(Change change, Project project) {
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(ChangesUtil.getFilePath(change));
    }

    public static AbstractVcs getVcsForFile(VirtualFile file, Project project) {
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(file);
    }

    public static AbstractVcs getVcsForFile(File file, Project project) {
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(VcsContextFactory.SERVICE.getInstance().createFilePathOn(file));
    }

    @NotNull
    public static List<FilePath> getPaths(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPaths"));
        }
        List<FilePath> list = ChangesUtil.getPathsList(changes).getResult();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPaths"));
        }
        return list;
    }

    @NotNull
    public static CaseSensitiveFilePathList getPathsList(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPathsList"));
        }
        CaseSensitiveFilePathList list = new CaseSensitiveFilePathList();
        for (Change change : changes) {
            ContentRevision afterRevision;
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision != null) {
                list.add(beforeRevision.getFile());
            }
            if ((afterRevision = change.getAfterRevision()) == null) continue;
            list.add(afterRevision.getFile());
        }
        CaseSensitiveFilePathList caseSensitiveFilePathList = list;
        if (caseSensitiveFilePathList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPathsList"));
        }
        return caseSensitiveFilePathList;
    }

    public static List<File> getIoFilesFromChanges(Collection<Change> changes) {
        ArrayList<File> result = new ArrayList<File>();
        for (Change change : changes) {
            File ioFile;
            if (change.getAfterRevision() != null && !result.contains(ioFile = change.getAfterRevision().getFile().getIOFile())) {
                result.add(ioFile);
            }
            if (change.getBeforeRevision() == null || result.contains(ioFile = change.getBeforeRevision().getFile().getIOFile())) continue;
            result.add(ioFile);
        }
        return result;
    }

    public static VirtualFile[] getFilesFromChanges(Collection<Change> changes) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null) continue;
            FilePath filePath = afterRevision.getFile();
            VirtualFile file = filePath.getVirtualFile();
            if (file == null || !file.isValid()) {
                file = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath.getPath());
            }
            if (file == null || !file.isValid()) continue;
            files.add(file);
        }
        return VfsUtilCore.toVirtualFileArray(files);
    }

    public static Navigatable[] getNavigatableArray(Project project, VirtualFile[] selectedFiles) {
        ArrayList<OpenFileDescriptor> result = new ArrayList<OpenFileDescriptor>();
        for (VirtualFile selectedFile : selectedFiles) {
            if (selectedFile.isDirectory()) continue;
            result.add(new OpenFileDescriptor(project, selectedFile));
        }
        return result.toArray(new Navigatable[result.size()]);
    }

    public static boolean allChangesInOneListOrWholeListsSelected(@NotNull Project project, @NotNull Change[] changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "allChangesInOneListOrWholeListsSelected"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "allChangesInOneListOrWholeListsSelected"));
        }
        ChangeListManager clManager = ChangeListManager.getInstance(project);
        if (clManager.getChangeListNameIfOnlyOne(changes) != null) {
            return true;
        }
        List<LocalChangeList> list = clManager.getChangeListsCopy();
        HashSet checkSet = new HashSet();
        ContainerUtil.addAll(checkSet, (Object[])changes);
        for (LocalChangeList localChangeList : list) {
            Collection<Change> listChanges = localChangeList.getChanges();
            if (listChanges.isEmpty()) continue;
            Change first = listChanges.iterator().next();
            if (checkSet.contains(first)) {
                for (Change change : listChanges) {
                    if (checkSet.contains(change)) continue;
                    return false;
                }
                continue;
            }
            for (Change change : listChanges) {
                if (!checkSet.contains(change)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static ChangeList getChangeListIfOnlyOne(@NotNull Project project, @Nullable Change[] changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getChangeListIfOnlyOne"));
        }
        ChangeListManager clManager = ChangeListManager.getInstance(project);
        String name = clManager.getChangeListNameIfOnlyOne(changes);
        return name == null ? null : clManager.findChangeList(name);
    }

    public static FilePath getCommittedPath(Project project, FilePath filePath) {
        Change change = ChangeListManager.getInstance(project).getChange(filePath);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(filePath)) {
                filePath = beforeRevision.getFile();
            }
        }
        return filePath;
    }

    public static FilePath getLocalPath(final Project project, final FilePath filePath) {
        Change change = ApplicationManager.getApplication().runReadAction(new Computable<Change>(){

            @Nullable
            public Change compute() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return ChangeListManager.getInstance(project).getChange(filePath);
            }
        });
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && beforeRevision.getFile().equals(filePath)) {
                return afterRevision.getFile();
            }
        }
        return filePath;
    }

    @Nullable
    public static VirtualFile findValidParentUnderReadAction(final FilePath file) {
        if (file.getVirtualFile() != null) {
            return file.getVirtualFile();
        }
        Computable<VirtualFile> computable = new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return ChangesUtil.findValidParent(file);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            return (VirtualFile)computable.compute();
        }
        return application.runReadAction(computable);
    }

    @Nullable
    public static VirtualFile findValidParentAccurately(FilePath filePath) {
        if (filePath.getVirtualFile() != null) {
            return filePath.getVirtualFile();
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile result = lfs.findFileByIoFile(filePath.getIOFile());
        if (result != null) {
            return result;
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed() && (result = lfs.refreshAndFindFileByIoFile(filePath.getIOFile())) != null) {
            return result;
        }
        return ChangesUtil.getValidParentUnderReadAction(filePath);
    }

    @Nullable
    private static VirtualFile getValidParentUnderReadAction(final FilePath filePath) {
        return ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return ChangesUtil.findValidParent(filePath);
            }
        });
    }

    @Deprecated
    @Nullable
    public static VirtualFile findValidParent(FilePath file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile parent = file.getVirtualFile();
        if (parent == null) {
            parent = file.getVirtualFileParent();
        }
        if (parent == null) {
            File ioFile = file.getIOFile();
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            while ((parent = lfs.findFileByIoFile(ioFile)) == null) {
                if ((ioFile = ioFile.getParentFile()) != null) continue;
                return null;
            }
        }
        return parent;
    }

    @Nullable
    public static String getProjectRelativePath(Project project, @Nullable File fileName) {
        if (fileName == null) {
            return null;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return fileName.toString();
        }
        String relativePath = FileUtil.getRelativePath((File)new File(baseDir.getPath()), (File)fileName);
        if (relativePath != null) {
            return relativePath;
        }
        return fileName.toString();
    }

    public static boolean isBinaryContentRevision(ContentRevision revision) {
        return revision != null && !revision.getFile().isDirectory() && revision instanceof BinaryContentRevision;
    }

    public static boolean isBinaryChange(Change change) {
        return ChangesUtil.isBinaryContentRevision(change.getBeforeRevision()) || ChangesUtil.isBinaryContentRevision(change.getAfterRevision());
    }

    public static boolean isTextConflictingChange(Change change) {
        FileStatus status = change.getFileStatus();
        return FileStatus.MERGED_WITH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    public static boolean isPropertyConflictingChange(Change change) {
        FileStatus status = change.getFileStatus();
        return FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    public static <T> void processItemsByVcs(final Collection<T> items, final VcsSeparator<T> separator, PerVcsProcessor<T> processor) {
        final HashMap changesByVcs = new HashMap();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (Object item : items) {
                    AbstractVcs vcs = separator.getVcsFor(item);
                    if (vcs == null) continue;
                    ArrayList vcsChanges = (ArrayList)changesByVcs.get(vcs);
                    if (vcsChanges == null) {
                        vcsChanges = new ArrayList();
                        changesByVcs.put(vcs, vcsChanges);
                    }
                    vcsChanges.add(item);
                }
            }
        });
        for (Map.Entry entry : changesByVcs.entrySet()) {
            processor.process((AbstractVcs)entry.getKey(), (List)entry.getValue());
        }
    }

    public static void processChangesByVcs(final Project project, Collection<Change> changes, PerVcsProcessor<Change> processor) {
        ChangesUtil.processItemsByVcs(changes, new VcsSeparator<Change>(){

            @Override
            public AbstractVcs getVcsFor(Change item) {
                return ChangesUtil.getVcsForChange(item, project);
            }
        }, processor);
    }

    public static void processVirtualFilesByVcs(final Project project, Collection<VirtualFile> files, PerVcsProcessor<VirtualFile> processor) {
        ChangesUtil.processItemsByVcs(files, new VcsSeparator<VirtualFile>(){

            @Override
            public AbstractVcs getVcsFor(VirtualFile item) {
                return ChangesUtil.getVcsForFile(item, project);
            }
        }, processor);
    }

    public static void processFilePathsByVcs(final Project project, Collection<FilePath> files, PerVcsProcessor<FilePath> processor) {
        ChangesUtil.processItemsByVcs(files, new VcsSeparator<FilePath>(){

            @Override
            public AbstractVcs getVcsFor(FilePath item) {
                return ChangesUtil.getVcsForFile(item.getIOFile(), project);
            }
        }, processor);
    }

    public static List<File> filePathsToFiles(Collection<FilePath> filePaths) {
        ArrayList<File> ioFiles = new ArrayList<File>();
        for (FilePath filePath : filePaths) {
            ioFiles.add(filePath.getIOFile());
        }
        return ioFiles;
    }

    public static boolean hasFileChanges(Collection<Change> changes) {
        for (Change change : changes) {
            FilePath path = ChangesUtil.getFilePath(change);
            if (path.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static void markInternalOperation(Iterable<Change> changes, boolean set) {
        for (Change change : changes) {
            VirtualFile file = change.getVirtualFile();
            if (file == null) continue;
            file.putUserData(INTERNAL_OPERATION_KEY, set);
        }
    }

    public static void markInternalOperation(VirtualFile file, boolean set) {
        file.putUserData(INTERNAL_OPERATION_KEY, set);
    }

    public static boolean isInternalOperation(VirtualFile file) {
        Boolean data = (Boolean)file.getUserData(INTERNAL_OPERATION_KEY);
        return data != null && data != false;
    }

    public static String getDefaultChangeListName() {
        return VcsBundle.message("changes.default.changelist.name", new Object[0]);
    }

    public static interface VcsSeparator<T> {
        public AbstractVcs getVcsFor(T var1);
    }

    public static interface PerVcsProcessor<T> {
        public void process(AbstractVcs var1, List<T> var2);
    }

    @Deprecated
    public static class CaseSensitiveFilePathList {
        @NotNull
        private final List<FilePath> myResult = new ArrayList<FilePath>();
        @NotNull
        private final Set<String> myDuplicatesControlSet = new HashSet<String>();

        public void add(@NotNull FilePath file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangesUtil$CaseSensitiveFilePathList", "add"));
            }
            String path = file.getIOFile().getAbsolutePath();
            if (!this.myDuplicatesControlSet.contains(path)) {
                this.myResult.add(file);
                this.myDuplicatesControlSet.add(path);
            }
        }

        public void addParents(@NotNull FilePath file, @NotNull Condition<FilePath> condition) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangesUtil$CaseSensitiveFilePathList", "addParents"));
            }
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangesUtil$CaseSensitiveFilePathList", "addParents"));
            }
            FilePath parent = file.getParentPath();
            if (parent != null && condition.value((Object)parent)) {
                this.add(parent);
                this.addParents(parent, condition);
            }
        }

        @NotNull
        public List<FilePath> getResult() {
            List<FilePath> list = this.myResult;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil$CaseSensitiveFilePathList", "getResult"));
            }
            return list;
        }
    }
}

