/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.OpenSourceUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class AutoScrollToSourceHandler {
    private Alarm myAutoScrollAlarm;

    protected AutoScrollToSourceHandler() {
    }

    public void install(final JTree tree) {
        this.myAutoScrollAlarm = new Alarm();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/AutoScrollToSourceHandler$1", "onClick"));
                }
                if (clickCount > 1) {
                    return false;
                }
                TreePath location = tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                if (location != null) {
                    AutoScrollToSourceHandler.this.onMouseClicked(tree);
                    return AutoScrollToSourceHandler.this.isAutoScrollMode();
                }
                return false;
            }
        }.installOn((Component)tree);
        tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(tree);
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(tree);
            }
        });
    }

    public void install(final JTable table) {
        this.myAutoScrollAlarm = new Alarm();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/AutoScrollToSourceHandler$4", "onClick"));
                }
                if (clickCount >= 2) {
                    return false;
                }
                Component location = table.getComponentAt(e.getPoint());
                if (location != null) {
                    AutoScrollToSourceHandler.this.onMouseClicked(table);
                    return AutoScrollToSourceHandler.this.isAutoScrollMode();
                }
                return false;
            }
        }.installOn((Component)table);
        table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(table);
            }
        });
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(table);
            }
        });
    }

    public void install(final JList jList) {
        this.myAutoScrollAlarm = new Alarm();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/AutoScrollToSourceHandler$7", "onClick"));
                }
                if (clickCount >= 2) {
                    return false;
                }
                Object source = e.getSource();
                int index = jList.locationToIndex(SwingUtilities.convertPoint(source instanceof Component ? (Component)source : null, e.getPoint(), jList));
                if (index >= 0 && index < jList.getModel().getSize()) {
                    AutoScrollToSourceHandler.this.onMouseClicked(jList);
                    return true;
                }
                return false;
            }
        }.installOn((Component)jList);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(jList);
            }
        });
    }

    public void cancelAllRequests() {
        if (this.myAutoScrollAlarm != null) {
            this.myAutoScrollAlarm.cancelAllRequests();
        }
    }

    public void onMouseClicked(final Component component) {
        this.myAutoScrollAlarm.cancelAllRequests();
        if (this.isAutoScrollMode()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoScrollToSourceHandler.this.scrollToSource(component);
                }
            });
        }
    }

    private void onSelectionChanged(final Component component) {
        if (component != null && !component.isShowing()) {
            return;
        }
        if (!this.isAutoScrollMode()) {
            return;
        }
        if (this.needToCheckFocus() && !component.hasFocus()) {
            return;
        }
        this.myAutoScrollAlarm.cancelAllRequests();
        this.myAutoScrollAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (component.isShowing()) {
                    AutoScrollToSourceHandler.this.scrollToSource(component);
                }
            }
        }, 500);
    }

    protected boolean needToCheckFocus() {
        return true;
    }

    protected abstract boolean isAutoScrollMode();

    protected abstract void setAutoScrollMode(boolean var1);

    protected void scrollToSource(final Component tree) {
        DataContext dataContext = DataManager.getInstance().getDataContext(tree);
        this.getReady(dataContext).doWhenDone(new Runnable(){

            @Override
            public void run() {
                Navigatable[] navigatables;
                DataContext context = DataManager.getInstance().getDataContext(tree);
                VirtualFile vFile = CommonDataKeys.VIRTUAL_FILE.getData(context);
                if (vFile != null) {
                    if (vFile.getFileType() == FileTypes.UNKNOWN || vFile.getFileType() instanceof INativeFileType) {
                        return;
                    }
                    if (vFile.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize()) {
                        return;
                    }
                }
                if ((navigatables = CommonDataKeys.NAVIGATABLE_ARRAY.getData(context)) != null) {
                    if (navigatables.length > 1) {
                        return;
                    }
                    for (Navigatable navigatable : navigatables) {
                        if (navigatable.canNavigateToSource()) continue;
                        return;
                    }
                }
                OpenSourceUtil.navigate(false, true, navigatables);
            }
        });
    }

    @NotNull
    public ToggleAction createToggleAction() {
        AutoscrollToSourceAction autoscrollToSourceAction = new AutoscrollToSourceAction();
        if (autoscrollToSourceAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AutoScrollToSourceHandler", "createToggleAction"));
        }
        return autoscrollToSourceAction;
    }

    private ActionCallback getReady(DataContext context) {
        ToolWindow toolWindow = PlatformDataKeys.TOOL_WINDOW.getData(context);
        return toolWindow != null ? toolWindow.getReady(this) : new ActionCallback.Done();
    }

    private class AutoscrollToSourceAction
    extends ToggleAction
    implements DumbAware {
        public AutoscrollToSourceAction() {
            super(UIBundle.message((String)"autoscroll.to.source.action.name", (Object[])new Object[0]), UIBundle.message((String)"autoscroll.to.source.action.description", (Object[])new Object[0]), AllIcons.General.AutoscrollToSource);
        }

        @Override
        public boolean isSelected(AnActionEvent event) {
            return AutoScrollToSourceHandler.this.isAutoScrollMode();
        }

        @Override
        public void setSelected(AnActionEvent event, boolean flag) {
            AutoScrollToSourceHandler.this.setAutoScrollMode(flag);
        }
    }
}

