/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckBoxList<T>
extends JBList {
    private static final int DEFAULT_CHECK_BOX_WIDTH = 20;
    private CheckBoxListListener checkBoxListListener;
    private final BidirectionalMap<T, JCheckBox> myItemMap = new BidirectionalMap();

    public CheckBoxList(CheckBoxListListener checkBoxListListener) {
        this(new DefaultListModel(), checkBoxListListener);
    }

    public CheckBoxList(DefaultListModel dataModel, CheckBoxListListener checkBoxListListener) {
        this(dataModel);
        this.setCheckBoxListListener(checkBoxListListener);
    }

    public CheckBoxList() {
        this(new DefaultListModel());
    }

    public CheckBoxList(DefaultListModel dataModel) {
        this.setModel(dataModel);
        this.setCellRenderer((ListCellRenderer)new CellRenderer());
        this.setSelectionMode(0);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    for (int index : CheckBoxList.this.getSelectedIndices()) {
                        if (index < 0) continue;
                        JCheckBox checkbox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(index);
                        CheckBoxList.this.setSelected(checkbox, index);
                    }
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int index;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CheckBoxList$2", "onClick"));
                }
                if (CheckBoxList.this.isEnabled() && (index = CheckBoxList.this.locationToIndex(e.getPoint())) != -1) {
                    int iconArea;
                    JCheckBox checkbox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(index);
                    try {
                        iconArea = checkbox.getMargin().left + ((BasicRadioButtonUI)checkbox.getUI()).getDefaultIcon().getIconWidth() + checkbox.getIconTextGap();
                    }
                    catch (ClassCastException c) {
                        iconArea = 20;
                    }
                    if (e.getX() < iconArea) {
                        CheckBoxList.this.setSelected(checkbox, index);
                        return true;
                    }
                }
                return false;
            }
        }.installOn((Component)this);
    }

    public void setStringItems(Map<String, Boolean> items) {
        this.clear();
        for (Map.Entry<String, Boolean> entry : items.entrySet()) {
            this.addItem(entry.getKey(), entry.getKey(), entry.getValue());
        }
    }

    public void setItems(List<T> items, @Nullable Function<T, String> converter) {
        this.clear();
        for (T item : items) {
            String text = converter != null ? (String)converter.fun(item) : item.toString();
            this.addItem(item, text, false);
        }
    }

    public void addItem(T item, String text, boolean selected) {
        JCheckBox checkBox = new JCheckBox(text, selected);
        this.myItemMap.put(item, (Object)checkBox);
        ((DefaultListModel)this.getModel()).addElement(checkBox);
    }

    public void updateItem(@NotNull T oldItem, @NotNull T newItem) {
        if (oldItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/ui/CheckBoxList", "updateItem"));
        }
        if (newItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItem", "com/intellij/ui/CheckBoxList", "updateItem"));
        }
        JCheckBox checkBox = (JCheckBox)this.myItemMap.remove(oldItem);
        this.myItemMap.put(newItem, (Object)checkBox);
    }

    @Nullable
    public T getItemAt(int index) {
        JCheckBox checkBox = (JCheckBox)this.getModel().getElementAt(index);
        List value = this.myItemMap.getKeysByValue((Object)checkBox);
        return value == null || value.isEmpty() ? null : (T)value.get(0);
    }

    public void clear() {
        ((DefaultListModel)this.getModel()).clear();
        this.myItemMap.clear();
    }

    public boolean isItemSelected(int index) {
        return ((JCheckBox)this.getModel().getElementAt(index)).isSelected();
    }

    public boolean isItemSelected(T item) {
        JCheckBox checkBox = (JCheckBox)this.myItemMap.get(item);
        return checkBox != null && checkBox.isSelected();
    }

    public void setItemSelected(T item, boolean selected) {
        JCheckBox checkBox = (JCheckBox)this.myItemMap.get(item);
        if (checkBox != null) {
            checkBox.setSelected(selected);
        }
    }

    private void setSelected(JCheckBox checkbox, int index) {
        boolean value = !checkbox.isSelected();
        checkbox.setSelected(value);
        this.repaint();
        ListModel model = this.getModel();
        if (model instanceof DefaultListModel) {
            ((DefaultListModel)model).setElementAt(this.getModel().getElementAt(index), index);
        }
        if (this.checkBoxListListener != null) {
            this.checkBoxListListener.checkBoxSelectionChanged(index, value);
        }
    }

    public void setCheckBoxListListener(CheckBoxListListener checkBoxListListener) {
        this.checkBoxListListener = checkBoxListListener;
    }

    protected void adjustRendering(JCheckBox checkBox, int index, boolean selected, boolean hasFocus) {
    }

    @Nullable
    protected String getSecondaryText(int index) {
        return null;
    }

    protected Color getBackground(boolean isSelected) {
        return isSelected ? this.getSelectionBackground() : this.getBackground();
    }

    protected Color getForeground(boolean isSelected) {
        return isSelected ? this.getSelectionForeground() : this.getForeground();
    }

    private class CellRenderer
    implements ListCellRenderer {
        private final Border mySelectedBorder = UIManager.getBorder("List.focusCellHighlightBorder");
        private final Border myBorder;

        private CellRenderer() {
            Insets borderInsets = this.mySelectedBorder.getBorderInsets(new JCheckBox());
            this.myBorder = new EmptyBorder(borderInsets);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent rootComponent;
            boolean shouldAdjustColors;
            JCheckBox checkbox = (JCheckBox)value;
            Color textColor = CheckBoxList.this.getForeground(isSelected);
            Color backgroundColor = CheckBoxList.this.getBackground(isSelected);
            Font font = CheckBoxList.this.getFont();
            boolean bl = shouldAdjustColors = !UIUtil.isUnderNimbusLookAndFeel();
            if (shouldAdjustColors) {
                checkbox.setBackground(backgroundColor);
                checkbox.setForeground(textColor);
            }
            checkbox.setEnabled(CheckBoxList.this.isEnabled());
            checkbox.setFont(font);
            checkbox.setFocusPainted(false);
            String auxText = CheckBoxList.this.getSecondaryText(index);
            if (auxText != null) {
                JPanel panel = new JPanel(new BorderLayout());
                checkbox.setBorderPainted(false);
                panel.add((Component)checkbox, "Before");
                JLabel infoLabel = new JLabel(auxText, 4);
                infoLabel.setBorder(new EmptyBorder(0, 0, 0, checkbox.getInsets().left));
                infoLabel.setFont(font);
                panel.add((Component)infoLabel, "Center");
                if (shouldAdjustColors) {
                    panel.setBackground(backgroundColor);
                    infoLabel.setForeground(isSelected ? textColor : JBColor.GRAY);
                    infoLabel.setBackground(backgroundColor);
                }
                rootComponent = panel;
            } else {
                checkbox.setBorderPainted(true);
                rootComponent = checkbox;
            }
            rootComponent.setBorder(isSelected ? this.mySelectedBorder : this.myBorder);
            CheckBoxList.this.adjustRendering(checkbox, index, isSelected, cellHasFocus);
            return rootComponent;
        }
    }
}

