/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgRepositoryAccess
extends SvnRepositoryAccess {
    public SvnNgRepositoryAccess(ISvnOperationOptionsProvider operationOptionsProvider, SVNWCContext context) throws SVNException {
        super(operationOptionsProvider, context);
    }

    @Override
    public Structure<SvnRepositoryAccess.RepositoryInfo> createRepositoryFor(SvnTarget target, SVNRevision revision, SVNRevision pegRevision, File baseDirectory) throws SVNException {
        SVNURL url = this.getTargetURL(target);
        if (url == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)target.getFile());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNRevision[] resolvedRevisions = this.resolveRevisions(pegRevision, revision, target.isURL(), true);
        SVNRevision pegRev = resolvedRevisions[0];
        SVNRevision startRev = resolvedRevisions[1];
        SVNRepository repository = this.createRepository(url, baseDirectory);
        if (target.isURL() && !url.equals(repository.getLocation())) {
            url = repository.getLocation();
        }
        Structure<SvnRepositoryAccess.LocationsInfo> locationsInfo = this.getLocations(repository, target, pegRev, startRev, SVNRevision.UNDEFINED);
        long rev = locationsInfo.lng(SvnRepositoryAccess.LocationsInfo.startRevision);
        url = (SVNURL)locationsInfo.get(SvnRepositoryAccess.LocationsInfo.startUrl);
        locationsInfo.release();
        repository.setLocation(url, false);
        if (rev < 0L) {
            Structure<SvnRepositoryAccess.RevisionsPair> revs = this.getRevisionNumber(repository, target, SVNRevision.HEAD, null);
            rev = revs.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            revs.release();
        }
        Object result = Structure.obtain(SvnRepositoryAccess.RepositoryInfo.class);
        ((Structure)result).set((SvnRepositoryAccess.RepositoryInfo)SvnRepositoryAccess.RepositoryInfo.revision, rev);
        ((Structure)result).set((SvnRepositoryAccess.RepositoryInfo)SvnRepositoryAccess.RepositoryInfo.repository, repository);
        ((Structure)result).set((SvnRepositoryAccess.RepositoryInfo)SvnRepositoryAccess.RepositoryInfo.url, url);
        return result;
    }

    @Override
    public Structure<SvnRepositoryAccess.UrlInfo> getURLFromPath(SvnTarget path, SVNRevision revision, SVNRepository repository) throws SVNException {
        Object urlInfo = Structure.obtain(SvnRepositoryAccess.UrlInfo.class);
        SVNURL url = null;
        if (revision == SVNRevision.WORKING) {
            Structure<StructureFields.NodeOriginInfo> nodeOrigin = this.getWCContext().getNodeOrigin(path.getFile(), false, new StructureFields.NodeOriginInfo[0]);
            ((Structure)urlInfo).set((SvnRepositoryAccess.UrlInfo)SvnRepositoryAccess.UrlInfo.pegRevision, nodeOrigin.lng(StructureFields.NodeOriginInfo.revision));
            if (nodeOrigin.hasValue(StructureFields.NodeOriginInfo.reposRelpath)) {
                url = SVNWCUtils.join((SVNURL)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRootUrl), (File)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRelpath));
            }
            if (url != null && nodeOrigin.hasValue(StructureFields.NodeOriginInfo.isCopy) && nodeOrigin.is(StructureFields.NodeOriginInfo.isCopy) && repository != null && !url.equals(repository.getLocation())) {
                ((Structure)urlInfo).set((SvnRepositoryAccess.UrlInfo)SvnRepositoryAccess.UrlInfo.dropRepsitory, true);
                repository = null;
            }
        }
        if (url == null) {
            url = this.getWCContext().getNodeUrl(path.getFile());
        }
        if (url == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)path.getFile());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        ((Structure)urlInfo).set((SvnRepositoryAccess.UrlInfo)SvnRepositoryAccess.UrlInfo.url, url);
        return urlInfo;
    }

    @Override
    public Structure<SvnRepositoryAccess.RevisionsPair> getRevisionNumber(SVNRepository repository, SvnTarget path, SVNRevision revision, Structure<SvnRepositoryAccess.RevisionsPair> youngestRevision) throws SVNException {
        SVNErrorMessage err;
        Structure<SvnRepositoryAccess.RevisionsPair> result;
        Structure<SvnRepositoryAccess.RevisionsPair> structure = result = youngestRevision == null ? Structure.obtain(SvnRepositoryAccess.RevisionsPair.class) : youngestRevision;
        if (youngestRevision == null) {
            result.set(SvnRepositoryAccess.RevisionsPair.youngestRevision, -1L);
        }
        if (repository == null && (revision == SVNRevision.HEAD || revision.getDate() != null)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (revision == SVNRevision.UNDEFINED) {
            result.set(SvnRepositoryAccess.RevisionsPair.revNumber, -1L);
        } else if (revision.getNumber() >= 0L) {
            result.set(SvnRepositoryAccess.RevisionsPair.revNumber, revision.getNumber());
        } else if (revision == SVNRevision.HEAD) {
            if (youngestRevision != null && youngestRevision.lng(SvnRepositoryAccess.RevisionsPair.youngestRevision) >= 0L) {
                result.set(SvnRepositoryAccess.RevisionsPair.revNumber, youngestRevision.lng(SvnRepositoryAccess.RevisionsPair.youngestRevision));
            } else {
                if (repository == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                long youngest = repository.getLatestRevision();
                result.set(SvnRepositoryAccess.RevisionsPair.revNumber, youngest);
                result.set(SvnRepositoryAccess.RevisionsPair.youngestRevision, youngest);
            }
        } else if (revision == SVNRevision.WORKING || revision == SVNRevision.BASE) {
            if (path == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (!path.isFile()) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "PREV, BASE or COMMITTTED revision keywords are invalid for URL");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            long revnum = -1L;
            try {
                revnum = this.getWCContext().getNodeCommitBaseRev(path.getFile());
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)path.getFile());
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                throw e;
            }
            if (revnum < 0L) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", (Object)path.getFile());
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            result.set(SvnRepositoryAccess.RevisionsPair.revNumber, revnum);
        } else if (revision == SVNRevision.COMMITTED || revision == SVNRevision.PREVIOUS) {
            if (path == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (!path.isFile()) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "PREV, BASE or COMMITTTED revision keywords are invalid for URL");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            long revnum = -1L;
            try {
                Structure<StructureFields.NodeInfo> info = this.getWCContext().getDb().readInfo(path.getFile(), StructureFields.NodeInfo.changedRev);
                revnum = info.lng(StructureFields.NodeInfo.changedRev);
                info.release();
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)path.getFile());
                    SVNErrorManager.error(err4, SVNLogType.WC);
                }
                throw e;
            }
            if (revnum < 0L) {
                SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", (Object)path.getFile());
                SVNErrorManager.error(err5, SVNLogType.WC);
            }
            if (revision == SVNRevision.PREVIOUS) {
                --revnum;
            }
            result.set(SvnRepositoryAccess.RevisionsPair.revNumber, revnum);
        } else if (revision.getDate() != null) {
            if (repository == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            long revnum = repository.getDatedRevision(revision.getDate());
            result.set(SvnRepositoryAccess.RevisionsPair.revNumber, revnum);
        } else {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Unrecognized revision type requested for ''{0}''", (Object)path.getFile());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (youngestRevision != null && (revision == SVNRevision.HEAD || revision.getDate() != null) && youngestRevision.lng(SvnRepositoryAccess.RevisionsPair.youngestRevision) >= 0L && result.lng(SvnRepositoryAccess.RevisionsPair.revNumber) >= 0L && result.lng(SvnRepositoryAccess.RevisionsPair.revNumber) > youngestRevision.lng(SvnRepositoryAccess.RevisionsPair.youngestRevision)) {
            result.set(SvnRepositoryAccess.RevisionsPair.revNumber, youngestRevision.lng(SvnRepositoryAccess.RevisionsPair.youngestRevision));
        }
        return result;
    }

    public SVNRepository createRepository(SVNURL url, File baseDirectory) throws SVNException {
        String expectedUuid;
        block3: {
            expectedUuid = null;
            if (baseDirectory != null) {
                SVNWCContext.SVNWCNodeReposInfo nodeReposInfo = null;
                try {
                    nodeReposInfo = this.getWCContext().getNodeReposInfo(baseDirectory);
                    expectedUuid = nodeReposInfo.reposUuid;
                }
                catch (SVNException e) {
                    SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
                    if (errorCode == SVNErrorCode.WC_NOT_WORKING_COPY || errorCode == SVNErrorCode.WC_PATH_NOT_FOUND || errorCode == SVNErrorCode.WC_UPGRADE_REQUIRED) break block3;
                    throw e;
                }
            }
        }
        return this.createRepository(url, expectedUuid, true);
    }

    @Override
    public SvnCopySource createRemoteCopySource(SVNWCContext context, SvnCopySource localCopySource) throws SVNException {
        Structure<StructureFields.NodeOriginInfo> origin = context.getNodeOrigin(localCopySource.getSource().getFile(), true, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl, StructureFields.NodeOriginInfo.revision);
        SVNURL url = (SVNURL)origin.get(StructureFields.NodeOriginInfo.reposRootUrl);
        url = url.appendPath(SVNFileUtil.getFilePath((File)origin.get(StructureFields.NodeOriginInfo.reposRelpath)), false);
        SVNRevision pegRevision = localCopySource.getSource().getResolvedPegRevision();
        SVNRevision revision = localCopySource.getRevision();
        if (pegRevision == SVNRevision.UNDEFINED || pegRevision == SVNRevision.WORKING || pegRevision == SVNRevision.BASE) {
            pegRevision = SVNRevision.create(origin.lng(StructureFields.NodeOriginInfo.revision));
        }
        if (revision == SVNRevision.BASE) {
            revision = SVNRevision.create(origin.lng(StructureFields.NodeOriginInfo.revision));
        }
        origin.release();
        localCopySource = SvnCopySource.create(SvnTarget.fromURL(url, pegRevision), revision);
        return localCopySource;
    }

    protected SVNURL getTargetURL(SvnTarget target) throws SVNException {
        if (target.isURL()) {
            return target.getURL();
        }
        return this.getWCContext().getNodeUrl(target.getFile());
    }
}

