/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationPackage$findClassInModule$430b024a;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationPackage$protoEnumMapping$32ebef8f;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedType;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FlexibleTypeCapabilitiesDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.LocalClassResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionBase;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage$collections$b33ae3d0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Function1<? super Integer, ? extends ClassDescriptor> classDescriptors;
    private final NotNullLazyValue<Map<Integer, ? extends TypeParameterDescriptor>> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final List<? extends ProtoBuf.TypeParameter> typeParameterProtos;
    private final String debugName;

    static {
        $kotlinClass = Reflection.createKotlinClass(TypeDeserializer.class);
    }

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return UtilsPackage$collections$b33ae3d0.toReadOnlyList(((Map)this.typeParameterDescriptors.invoke()).values());
    }

    @NotNull
    public final JetType type(@JetValueParameter(name="proto") @NotNull ProtoBuf.Type proto) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            FlexibleTypeCapabilitiesDeserializer flexibleTypeCapabilitiesDeserializer = this.c.getComponents().getFlexibleTypeCapabilitiesDeserializer();
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull(string, "id");
            FlexibleTypeCapabilities capabilities = flexibleTypeCapabilitiesDeserializer.capabilitiesById(string);
            if (capabilities == null) {
                JetType jetType = ErrorUtils.createErrorType(new DeserializedType(this.c, proto) + ": Capabilities not found for id " + id);
                Intrinsics.checkExpressionValueIsNotNull(jetType, "ErrorUtils.createErrorTy\u2026es not found for id $id\")");
                return jetType;
            }
            JetType jetType = new DeserializedType(this.c, proto);
            ProtoBuf.Type type2 = proto.getFlexibleUpperBound();
            Intrinsics.checkExpressionValueIsNotNull(type2, "proto.getFlexibleUpperBound()");
            return DelegatingFlexibleType.Companion.create(jetType, new DeserializedType(this.c, type2), capabilities);
        }
        return new DeserializedType(this.c, proto);
    }

    @NotNull
    public final TypeConstructor typeConstructor(@JetValueParameter(name="proto") @NotNull ProtoBuf.Type proto) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        ProtoBuf.Type.Constructor constructorProto = proto.getConstructor();
        int id = constructorProto.getId();
        ProtoBuf.Type.Constructor constructor2 = constructorProto;
        Intrinsics.checkExpressionValueIsNotNull(constructor2, "constructorProto");
        TypeConstructor typeConstructor2 = this.typeConstructor(constructor2);
        if (typeConstructor2 == null) {
            typeConstructor2 = ErrorUtils.createErrorType(Intrinsics.areEqual(constructorProto.getKind(), ProtoBuf.Type.Constructor.Kind.CLASS) ? this.c.getNameResolver().getClassId(id).asSingleFqName().asString() : "Unknown type parameter " + id).getConstructor();
        }
        return typeConstructor2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final TypeConstructor typeConstructor(@JetValueParameter(name="proto") ProtoBuf.Type.Constructor proto) {
        ProtoBuf.Type.Constructor.Kind kind = proto.getKind();
        if (kind == null) throw (Throwable)new IllegalStateException("Unknown kind " + proto.getKind());
        switch (TypeDeserializer$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                ClassDescriptor classDescriptor = this.classDescriptors.invoke((Integer)proto.getId());
                if (classDescriptor == null) return null;
                TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
                return typeConstructor2;
            }
            case 2: {
                TypeConstructor typeConstructor2 = this.typeParameterTypeConstructor(proto);
                return typeConstructor2;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown kind " + proto.getKind());
            }
        }
    }

    private final TypeConstructor typeParameterTypeConstructor(@JetValueParameter(name="proto") ProtoBuf.Type.Constructor proto) {
        Annotated annotated = (TypeParameterDescriptor)((Map)this.typeParameterDescriptors.invoke()).get(proto.getId());
        if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            annotated = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(proto) : null;
        }
        return annotated;
    }

    private final ClassDescriptor computeClassDescriptor(@JetValueParameter(name="fqNameIndex") int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassResolver localClassResolver = this.c.getComponents().getLocalClassResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull(classId, "id");
            return localClassResolver.resolveLocalClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull(classId, "id");
        return DeserializationPackage$findClassInModule$430b024a.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    @NotNull
    public final TypeProjection typeArgument(@JetValueParameter(name="parameter", type="?") @Nullable TypeParameterDescriptor parameter, @JetValueParameter(name="typeArgumentProto") @NotNull ProtoBuf.Type.Argument typeArgumentProto) {
        TypeProjectionBase typeProjectionBase;
        Intrinsics.checkParameterIsNotNull(typeArgumentProto, "typeArgumentProto");
        if (Intrinsics.areEqual(typeArgumentProto.getProjection(), ProtoBuf.Type.Argument.Projection.STAR)) {
            if (parameter == null) {
                JetType jetType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(jetType, "c.components.moduleDescr\u2026tIns.getNullableAnyType()");
                typeProjectionBase = new TypeBasedStarProjectionImpl(jetType);
            } else {
                typeProjectionBase = new StarProjectionImpl(parameter);
            }
        } else {
            ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
            Intrinsics.checkExpressionValueIsNotNull(projection, "typeArgumentProto.getProjection()");
            Variance variance = DeserializationPackage$protoEnumMapping$32ebef8f.variance(projection);
            ProtoBuf.Type type2 = typeArgumentProto.getType();
            Intrinsics.checkExpressionValueIsNotNull(type2, "typeArgumentProto.getType()");
            typeProjectionBase = new TypeProjectionImpl(variance, this.type(type2));
        }
        return typeProjectionBase;
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@JetValueParameter(name="c") @NotNull DeserializationContext c, @JetValueParameter(name="parent", type="?") @Nullable TypeDeserializer parent, @JetValueParameter(name="typeParameterProtos") @NotNull List<? extends ProtoBuf.TypeParameter> typeParameterProtos, @JetValueParameter(name="debugName") @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        this.c = c;
        this.parent = parent;
        this.typeParameterProtos = typeParameterProtos;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(@JetValueParameter(name="fqNameIndex") int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor$0(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeParameterDescriptors = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<Integer, ? extends TypeParameterDescriptor>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final Map<Integer, TypeParameterDescriptor> invoke() {
                Map map;
                if (TypeDeserializer.access$getTypeParameterProtos$1(this.this$0).isEmpty()) {
                    map = KotlinPackage.mapOf();
                } else {
                    LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
                    for (Pair<Integer, T> pair : KotlinPackage.withIndices((Iterable)TypeDeserializer.access$getTypeParameterProtos$1(this.this$0))) {
                        int index = ((Number)pair.component1()).intValue();
                        ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)pair.component2();
                        KotlinPackage.set(result, proto.getId(), new DeserializedTypeParameterDescriptor(TypeDeserializer.access$getC$2(this.this$0), proto, index));
                    }
                    map = result;
                }
                return map;
            }
            {
                this.this$0 = typeDeserializer;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor$0(@JetValueParameter(name="$this", type="?") TypeDeserializer $this, @JetValueParameter(name="fqNameIndex") int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @NotNull
    public static final /* synthetic */ List<ProtoBuf.TypeParameter> access$getTypeParameterProtos$1(@JetValueParameter(name="$this", type="?") TypeDeserializer $this) {
        return $this.typeParameterProtos;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$2(@JetValueParameter(name="$this", type="?") TypeDeserializer $this) {
        return $this.c;
    }
}

