/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.GroupBasedTestClassFilter;
import com.intellij.PatternListTestClassFilter;
import com.intellij.TestAll;
import com.intellij.TestClassesFilter;
import com.intellij.idea.Bombed;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCaseLoader {
    public static final String TARGET_TEST_GROUP = "idea.test.group";
    public static final String TARGET_TEST_PATTERNS = "idea.test.patterns";
    public static final String PERFORMANCE_TESTS_ONLY_FLAG = "idea.performance.tests";
    public static final String SKIP_COMMUNITY_TESTS = "idea.skip.community.tests";
    private final List<Class> myClassList = new ArrayList<Class>();
    private Class myFirstTestClass;
    private Class myLastTestClass;
    private final TestClassesFilter myTestClassesFilter;
    private final boolean myIsPerformanceTestsRun;
    private static final List<String> ourRankList = TestCaseLoader.getTeamCityRankList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestCaseLoader(String classFilterName, boolean isPerformanceTestsRun) {
        this.myIsPerformanceTestsRun = isPerformanceTestsRun;
        String patterns = System.getProperty(TARGET_TEST_PATTERNS);
        if (patterns != null) {
            this.myTestClassesFilter = new PatternListTestClassFilter(StringUtil.split((String)patterns, (String)";"));
            System.out.println("Using patterns: [" + patterns + "]");
        } else {
            List<URL> groupingFileUrls = Collections.emptyList();
            if (!StringUtil.isEmpty((String)classFilterName)) {
                try {
                    groupingFileUrls = Collections.list(this.getClass().getClassLoader().getResources(classFilterName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            List testGroupNames = StringUtil.split((String)System.getProperty(TARGET_TEST_GROUP, "").trim(), (String)";");
            MultiMap groups = MultiMap.createLinked();
            for (URL fileUrl : groupingFileUrls) {
                try {
                    InputStreamReader reader = new InputStreamReader(fileUrl.openStream());
                    try {
                        groups.putAllValues(GroupBasedTestClassFilter.readGroups(reader));
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("Failed to load test groups from " + fileUrl);
                }
            }
            if (groups.isEmpty()) {
                System.out.println("Using all classes");
                this.myTestClassesFilter = TestClassesFilter.ALL_CLASSES;
            } else {
                System.out.println("Using test groups: " + testGroupNames);
                this.myTestClassesFilter = new GroupBasedTestClassFilter((MultiMap<String, String>)groups, testGroupNames);
            }
        }
    }

    void addClassIfTestCase(Class testCaseClass, String moduleName) {
        if (this.shouldAddTestCase(testCaseClass, moduleName, true) && testCaseClass != this.myFirstTestClass && testCaseClass != this.myLastTestClass && PlatformTestUtil.canRunTest(testCaseClass)) {
            this.myClassList.add(testCaseClass);
        }
    }

    void addFirstTest(Class aClass) {
        assert (this.myFirstTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myFirstTestClass = aClass;
    }

    void addLastTest(Class aClass) {
        assert (this.myLastTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myLastTestClass = aClass;
    }

    private boolean shouldAddTestCase(Class<?> testCaseClass, String moduleName, boolean testForExcluded) {
        if ((testCaseClass.getModifiers() & 0x400) != 0) {
            return false;
        }
        if (testForExcluded && this.shouldExcludeTestClass(moduleName, testCaseClass)) {
            return false;
        }
        if (TestCase.class.isAssignableFrom(testCaseClass) || TestSuite.class.isAssignableFrom(testCaseClass)) {
            return true;
        }
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", new Class[0]);
            if (Test.class.isAssignableFrom(suiteMethod.getReturnType()) && (suiteMethod.getModifiers() & 8) != 0) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return TestRunnerUtil.isJUnit4TestClass(testCaseClass);
    }

    private boolean shouldExcludeTestClass(String moduleName, Class testCaseClass) {
        if (TestAll.isPerformanceTest(testCaseClass) && !this.myIsPerformanceTestsRun) {
            return true;
        }
        String className = testCaseClass.getName();
        return !this.myTestClassesFilter.matches(className, moduleName) || TestCaseLoader.isBombed(testCaseClass);
    }

    public static boolean isBombed(AnnotatedElement element) {
        Bombed bombedAnnotation = element.getAnnotation(Bombed.class);
        if (bombedAnnotation == null) {
            return false;
        }
        return !PlatformTestUtil.bombExplodes(bombedAnnotation);
    }

    public void loadTestCases(String moduleName, Collection<String> classNamesIterator) {
        for (String className : classNamesIterator) {
            try {
                Class<?> candidateClass = Class.forName(className, false, this.getClass().getClassLoader());
                this.addClassIfTestCase(candidateClass, moduleName);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Cannot load class " + className + ": " + e.getMessage());
                e.printStackTrace();
            }
            catch (ExceptionInInitializerError e) {
                System.err.println("Cannot initialize class " + className + ": " + e.getException().getMessage());
                e.printStackTrace();
                System.err.println("Root cause:");
                e.getException().printStackTrace();
            }
            catch (LinkageError e) {
                System.err.println("Cannot load class " + className + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static List<String> getTeamCityRankList() {
        String filePath = System.getProperty("teamcity.tests.recentlyFailedTests.file", null);
        if (filePath != null) {
            try {
                return FileUtil.loadLines((String)filePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private int getRank(Class aClass) {
        String name = aClass.getName();
        if (aClass == this.myFirstTestClass) {
            return -1;
        }
        if (aClass == this.myLastTestClass) {
            return this.myClassList.size() + ourRankList.size();
        }
        int i = ourRankList.indexOf(name);
        if (i != -1) {
            return i;
        }
        return ourRankList.size();
    }

    public List<Class> getClasses() {
        ArrayList<Class> result = new ArrayList<Class>(this.myClassList.size());
        if (this.myFirstTestClass != null) {
            result.add(this.myFirstTestClass);
        }
        result.addAll(this.myClassList);
        if (this.myLastTestClass != null) {
            result.add(this.myLastTestClass);
        }
        if (!ourRankList.isEmpty()) {
            Collections.sort(result, new Comparator<Class>(){

                @Override
                public int compare(Class o1, Class o2) {
                    return TestCaseLoader.this.getRank(o1) - TestCaseLoader.this.getRank(o2);
                }
            });
        }
        return result;
    }

    public void clearClasses() {
        this.myClassList.clear();
    }
}

