/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.PatternFilter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class CompletionVariant {
    protected static final TailType DEFAULT_TAIL_TYPE = TailType.SPACE;
    private final Set<Scope> myScopeClasses = new HashSet<Scope>();
    private ElementFilter myPosition;
    private final List<CompletionVariantItem> myCompletionsList = new ArrayList<CompletionVariantItem>();
    private final Set<Class> myScopeClassExceptions = new HashSet<Class>();
    private InsertHandler myInsertHandler = null;
    private final Map<Object, Object> myItemProperties = new HashMap();

    public CompletionVariant() {
    }

    public CompletionVariant(Class scopeClass, ElementPattern position) {
        this(scopeClass, (ElementFilter)new PatternFilter(position));
    }

    public CompletionVariant(Class scopeClass, ElementFilter position) {
        this.includeScopeClass(scopeClass);
        this.myPosition = position;
    }

    public CompletionVariant(ElementPattern<? extends PsiElement> position) {
        this((ElementFilter)new PatternFilter(position));
    }

    public CompletionVariant(ElementFilter position) {
        this.myPosition = position;
    }

    public boolean isScopeAcceptable(PsiElement scope) {
        return this.isScopeClassAcceptable(scope.getClass());
    }

    public boolean isScopeFinal(PsiElement scope) {
        return this.isScopeClassFinal(scope.getClass());
    }

    public InsertHandler getInsertHandler() {
        return this.myInsertHandler;
    }

    public void setInsertHandler(InsertHandler handler) {
        this.myInsertHandler = handler;
    }

    public void setItemProperty(Object id, Object value) {
        this.myItemProperties.put(id, value);
    }

    public Map<Object, Object> getItemProperties() {
        return this.myItemProperties;
    }

    public boolean isScopeClassFinal(Class scopeClass) {
        Iterator<Scope> iterator = this.myScopeClasses.iterator();
        while (iterator.hasNext()) {
            Scope myScopeClass;
            Scope scope = myScopeClass = iterator.next();
            if (!ReflectionUtil.isAssignable((Class)scope.myClass, (Class)scopeClass) || !scope.myIsFinalScope) continue;
            return true;
        }
        return false;
    }

    public boolean isScopeClassAcceptable(Class scopeClass) {
        boolean ret = false;
        for (Scope myScopeClass : this.myScopeClasses) {
            Class aClass = myScopeClass.myClass;
            if (!ReflectionUtil.isAssignable((Class)aClass, (Class)scopeClass)) continue;
            ret = true;
            break;
        }
        if (ret) {
            for (Class aClass : this.myScopeClassExceptions) {
                if (!ReflectionUtil.isAssignable((Class)aClass, (Class)scopeClass)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public void excludeScopeClass(Class<?> aClass) {
        this.myScopeClassExceptions.add(aClass);
    }

    public void includeScopeClass(Class<?> aClass) {
        this.myScopeClasses.add(new Scope(aClass, false));
    }

    public void includeScopeClass(Class<?> aClass, boolean isFinalScope) {
        this.myScopeClasses.add(new Scope(aClass, isFinalScope));
    }

    public void addCompletionFilter(ElementFilter filter, TailType tailType) {
        this.addCompletion(filter, tailType);
    }

    public void addCompletionFilter(ElementFilter filter) {
        this.addCompletionFilter(filter, TailType.NONE);
    }

    public void addCompletion(@NonNls String keyword) {
        this.addCompletion(keyword, DEFAULT_TAIL_TYPE);
    }

    public void addCompletion(@NonNls String keyword, TailType tailType) {
        this.addCompletion((Object)keyword, tailType);
    }

    public void addCompletion(ContextGetter chooser) {
        this.addCompletion(chooser, DEFAULT_TAIL_TYPE);
    }

    public void addCompletion(ContextGetter chooser, TailType tailType) {
        this.addCompletion((Object)chooser, tailType);
    }

    private void addCompletion(Object completion, TailType tail) {
        this.myCompletionsList.add(new CompletionVariantItem(completion, tail));
    }

    public void addCompletion(@NonNls String[] keywordList) {
        this.addCompletion(keywordList, DEFAULT_TAIL_TYPE);
    }

    public void addCompletion(String[] keywordList, TailType tailType) {
        for (String aKeywordList : keywordList) {
            this.addCompletion(aKeywordList, tailType);
        }
    }

    public boolean isVariantApplicable(PsiElement position, PsiElement scope) {
        return this.isScopeAcceptable(scope) && this.myPosition.isAcceptable((Object)position, scope);
    }

    public void addReferenceCompletions(PsiReference reference, PsiElement position, Set<LookupElement> set, PsiFile file, CompletionData completionData) {
        for (CompletionVariantItem ce : this.myCompletionsList) {
            if (!(ce.myCompletion instanceof ElementFilter)) continue;
            ElementFilter filter = (ElementFilter)ce.myCompletion;
            completionData.completeReference(reference, position, set, ce.myTailType, file, filter, this);
        }
    }

    public void addKeywords(Set<LookupElement> set, PsiElement position, PrefixMatcher matcher, PsiFile file, CompletionData completionData) {
        for (CompletionVariantItem ce : this.myCompletionsList) {
            completionData.addKeywords(set, position, matcher, file, this, ce.myCompletion, ce.myTailType);
        }
    }

    public boolean hasReferenceFilter() {
        for (CompletionVariantItem item : this.myCompletionsList) {
            if (!(item.myCompletion instanceof ElementFilter)) continue;
            return true;
        }
        return false;
    }

    public boolean hasKeywordCompletions() {
        for (CompletionVariantItem item : this.myCompletionsList) {
            if (item.myCompletion instanceof ElementFilter) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "completion variant at " + this.myPosition.toString() + " completions: " + this.myCompletionsList;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.setItemProperty(LookupItem.CASE_INSENSITIVE, caseInsensitive);
    }

    protected static class CompletionVariantItem {
        public Object myCompletion;
        public TailType myTailType;

        public CompletionVariantItem(Object completion, TailType tailtype) {
            this.myCompletion = completion;
            this.myTailType = tailtype;
        }

        public String toString() {
            return this.myCompletion.toString();
        }
    }

    private static class Scope {
        Class myClass;
        boolean myIsFinalScope;

        Scope(Class aClass, boolean isFinalScope) {
            this.myClass = aClass;
            this.myIsFinalScope = isFinalScope;
        }
    }
}

