/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.FlatteningIterator;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiftShorterItemsClassifier
extends Classifier<LookupElement> {
    private final TreeSet<String> mySortedStrings = new TreeSet();
    private final MultiMap<String, LookupElement> myElements = MultiMap.createSmart();
    private final MultiMap<LookupElement, LookupElement> myToLift = new MultiMap<LookupElement, LookupElement>(){

        @NotNull
        protected Map<LookupElement, Collection<LookupElement>> createMap() {
            IdentityHashMap identityHashMap = ContainerUtil.newIdentityHashMap();
            if (identityHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/LiftShorterItemsClassifier$1", "createMap"));
            }
            return identityHashMap;
        }
    };
    private final WeakInterner<Collection<LookupElement>> myListInterner = new WeakInterner();
    private final String myName;
    private final Classifier<LookupElement> myNext;
    private final LiftingCondition myCondition;
    private final boolean myLiftBefore;
    private int myCount = 0;

    public LiftShorterItemsClassifier(String name, Classifier<LookupElement> next, LiftingCondition condition, boolean liftBefore) {
        this.myName = name;
        this.myNext = next;
        this.myCondition = condition;
        this.myLiftBefore = liftBefore;
    }

    @Override
    public void addElement(LookupElement added, ProcessingContext context) {
        ++this.myCount;
        for (String string : CompletionUtil.getImmutableLookupStrings(added)) {
            if (string.length() == 0) continue;
            this.myElements.putValue((Object)string, (Object)added);
            this.mySortedStrings.add(string);
            NavigableSet<String> after = this.mySortedStrings.tailSet(string, false);
            for (String s : after) {
                if (!s.startsWith(string)) break;
                for (LookupElement longer : this.myElements.get((Object)s)) {
                    this.updateLongerItem(added, longer);
                }
            }
        }
        this.myNext.addElement(added, context);
        this.calculateToLift(added);
    }

    private void updateLongerItem(LookupElement shorter, LookupElement longer) {
        if (this.myCondition.shouldLift(shorter, longer)) {
            this.myToLift.putValue((Object)longer, (Object)shorter);
            this.internListToLift(longer);
        }
    }

    private void internListToLift(LookupElement longer) {
        Collection elements = this.myToLift.get((Object)longer);
        if (elements.size() > 10) {
            return;
        }
        this.myToLift.put((Object)longer, (Collection)this.myListInterner.intern((Object)elements));
    }

    private void calculateToLift(LookupElement element) {
        boolean hasChanges = false;
        for (String string : CompletionUtil.getImmutableLookupStrings(element)) {
            for (int len = 1; len < string.length(); ++len) {
                String prefix = string.substring(0, len);
                for (LookupElement shorterElement : this.myElements.get((Object)prefix)) {
                    if (!this.myCondition.shouldLift(shorterElement, element)) continue;
                    hasChanges = true;
                    this.myToLift.putValue((Object)element, (Object)shorterElement);
                }
            }
        }
        if (hasChanges) {
            this.internListToLift(element);
        }
    }

    @Override
    public Iterable<LookupElement> classify(Iterable<LookupElement> source, ProcessingContext context) {
        return this.liftShorterElements(source, null, context);
    }

    private Iterable<LookupElement> liftShorterElements(Iterable<LookupElement> source, @Nullable THashSet<LookupElement> lifted, ProcessingContext context) {
        THashSet srcSet = ContainerUtil.newIdentityTroveSet((int)(source instanceof Collection ? ((Collection)source).size() : this.myCount));
        ContainerUtil.addAll((Collection)srcSet, source);
        if (srcSet.size() < 2) {
            return this.myNext.classify(source, context);
        }
        return new LiftingIterable((Set<LookupElement>)srcSet, context, source, lifted);
    }

    @Override
    public void describeItems(LinkedHashMap<LookupElement, StringBuilder> map, ProcessingContext context) {
        THashSet lifted = ContainerUtil.newIdentityTroveSet();
        this.liftShorterElements(new ArrayList<LookupElement>(map.keySet()), (THashSet<LookupElement>)lifted, context);
        if (!lifted.isEmpty()) {
            for (LookupElement element : map.keySet()) {
                StringBuilder builder = map.get(element);
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(this.myName).append("=").append(lifted.contains((Object)element));
            }
        }
        this.myNext.describeItems(map, context);
    }

    private class LiftingIterable
    implements Iterable<LookupElement> {
        private final Set<LookupElement> mySrcSet;
        private final ProcessingContext myContext;
        private final Iterable<LookupElement> mySource;
        private final THashSet<LookupElement> myLifted;

        public LiftingIterable(Set<LookupElement> srcSet, ProcessingContext context, Iterable<LookupElement> source, THashSet<LookupElement> lifted) {
            this.mySrcSet = srcSet;
            this.myContext = context;
            this.mySource = source;
            this.myLifted = lifted;
        }

        @Override
        public Iterator<LookupElement> iterator() {
            THashSet processed = ContainerUtil.newIdentityTroveSet((int)this.mySrcSet.size());
            THashSet arraysProcessed = ContainerUtil.newIdentityTroveSet();
            Iterable<LookupElement> next = LiftShorterItemsClassifier.this.myNext.classify(this.mySource, this.myContext);
            Iterator base = FilteringIterator.create(next.iterator(), (Condition)new Condition<LookupElement>((Set)processed){
                final /* synthetic */ Set val$processed;
                {
                    this.val$processed = set;
                }

                public boolean value(LookupElement element) {
                    return this.val$processed.add(element);
                }
            });
            return new FlatteningIterator<LookupElement, LookupElement>(base, (Set)arraysProcessed, (Set)processed){
                final /* synthetic */ Set val$arraysProcessed;
                final /* synthetic */ Set val$processed;
                {
                    this.val$arraysProcessed = set;
                    this.val$processed = set2;
                    super(x0);
                }

                protected Iterator<LookupElement> createValueIterator(LookupElement element) {
                    List<LookupElement> shorter = this.addShorterElements(LiftShorterItemsClassifier.this.myToLift.get((Object)element));
                    List<LookupElement> singleton = Collections.singletonList(element);
                    if (shorter != null) {
                        if (LiftingIterable.this.myLifted != null) {
                            LiftingIterable.this.myLifted.addAll(shorter);
                        }
                        Iterable<LookupElement> lifted = LiftShorterItemsClassifier.this.myNext.classify(shorter, LiftingIterable.this.myContext);
                        return (LiftShorterItemsClassifier.this.myLiftBefore ? ContainerUtil.concat((Iterable[])new Iterable[]{lifted, singleton}) : ContainerUtil.concat((Iterable[])new Iterable[]{singleton, lifted})).iterator();
                    }
                    return singleton.iterator();
                }

                @Nullable
                private List<LookupElement> addShorterElements(@Nullable Collection<LookupElement> from) {
                    ArrayList<LookupElement> toLift = null;
                    if (from == null) {
                        return null;
                    }
                    if (this.val$arraysProcessed.add(from)) {
                        for (LookupElement shorterElement : from) {
                            if (!LiftingIterable.this.mySrcSet.contains(shorterElement) || !this.val$processed.add(shorterElement)) continue;
                            if (toLift == null) {
                                toLift = new ArrayList<LookupElement>();
                            }
                            toLift.add(shorterElement);
                        }
                    }
                    return toLift;
                }
            };
        }
    }

    public static class LiftingCondition {
        public boolean shouldLift(LookupElement shorterElement, LookupElement longerElement) {
            return true;
        }
    }
}

