/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;

public class SetupSDKNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"Setup SDK");
    private final Project myProject;

    public SetupSDKNotificationProvider(Project project, final EditorNotifications notifications) {
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SetupSDKNotificationProvider", "getKey"));
        }
        return key;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/SetupSDKNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/codeInsight/daemon/impl/SetupSDKNotificationProvider", "createNotificationPanel"));
        }
        if (file.getFileType() == JavaClassFileType.INSTANCE) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (psiFile.getLanguage() != JavaLanguage.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null) {
            return null;
        }
        return SetupSDKNotificationProvider.createPanel(this.myProject, psiFile);
    }

    @NotNull
    private static EditorNotificationPanel createPanel(final @NotNull Project project, final @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/SetupSDKNotificationProvider", "createPanel"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/SetupSDKNotificationProvider", "createPanel"));
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(ProjectBundle.message((String)"project.sdk.not.defined", (Object[])new Object[0]));
        panel.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                Sdk projectSdk = ProjectSettingsService.getInstance(project).chooseAndSetSdk();
                if (projectSdk == null) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                        if (module != null) {
                            ModuleRootModificationUtil.setSdkInherited((Module)module);
                        }
                    }
                });
            }
        });
        EditorNotificationPanel editorNotificationPanel = panel;
        if (editorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SetupSDKNotificationProvider", "createPanel"));
        }
        return editorNotificationPanel;
    }
}

