/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;

public class SmartPointerEditorTracker
extends AbstractProjectComponent
implements DocumentListener,
EditorFactoryListener,
DocumentBulkUpdateListener {
    private final SmartPointerManagerImpl mySmartPointerManager;

    public SmartPointerEditorTracker(Project project, EditorFactory editorFactory, SmartPointerManager manager, MessageBus bus) {
        super(project);
        this.mySmartPointerManager = (SmartPointerManagerImpl)manager;
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)project);
        editorFactory.addEditorFactoryListener((EditorFactoryListener)this, (Disposable)project);
        bus.connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)this);
    }

    public void beforeDocumentChange(DocumentEvent event) {
        boolean isRelevant;
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean isBulk = document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate();
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (!isBulk && isRelevant && this.shouldNotifySmartPointers(virtualFile)) {
            this.mySmartPointerManager.fastenBelts(virtualFile, event.getOffset(), null);
        }
    }

    public void documentChanged(DocumentEvent event) {
        boolean isRelevant;
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean isBulk = document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate();
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (!isBulk && isRelevant && this.shouldNotifySmartPointers(virtualFile)) {
            this.mySmartPointerManager.unfastenBelts(virtualFile, event.getOffset());
        }
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/SmartPointerEditorTracker", "editorCreated"));
        }
        Editor editor = event.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject || this.myProject.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null) {
            this.mySmartPointerManager.fastenBelts(virtualFile, 0, null);
        }
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/SmartPointerEditorTracker", "editorReleased"));
        }
        Editor editor = event.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject || this.myProject.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && virtualFile.isValid() && this.shouldNotifySmartPointers(virtualFile)) {
            this.mySmartPointerManager.unfastenBelts(virtualFile, 0);
        }
    }

    private boolean shouldNotifySmartPointers(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInsight/daemon/impl/SmartPointerEditorTracker", "shouldNotifySmartPointers"));
        }
        return !FileEditorManager.getInstance((Project)this.myProject).isFileOpen(virtualFile);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInsight/daemon/impl/SmartPointerEditorTracker", "isRelevant"));
        }
        return !virtualFile.getFileType().isBinary() && !this.myProject.isDisposed();
    }

    @Override
    public void updateStarted(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/SmartPointerEditorTracker", "updateStarted"));
        }
        VirtualFile virtualFile = SmartPointerEditorTracker.getVirtualFile(document);
        if (virtualFile != null && this.isRelevant(virtualFile) && this.shouldNotifySmartPointers(virtualFile)) {
            this.mySmartPointerManager.fastenBelts(virtualFile, 0, null);
        }
    }

    @Override
    public void updateFinished(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/SmartPointerEditorTracker", "updateFinished"));
        }
        VirtualFile virtualFile = SmartPointerEditorTracker.getVirtualFile(document);
        if (virtualFile != null && this.isRelevant(virtualFile) && this.shouldNotifySmartPointers(virtualFile)) {
            this.mySmartPointerManager.unfastenBelts(virtualFile, 0);
        }
    }

    private static VirtualFile getVirtualFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/SmartPointerEditorTracker", "getVirtualFile"));
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return virtualFile == null || !virtualFile.isValid() ? null : virtualFile;
    }
}

