/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.BringVariableIntoScopeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstantFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateEnumConstantFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateParameterFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToModuleFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    @Override
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider", "registerFixes"));
        }
        QuickFixFactory factory = QuickFixFactory.getInstance();
        registrar.register((IntentionAction)new ImportClassFix(ref));
        registrar.register(factory.createSetupJDKFix());
        OrderEntryFix.registerFixes(registrar, (PsiReference)ref);
        MoveClassToModuleFix.registerFixes(registrar, ref);
        if (ref instanceof PsiReferenceExpression) {
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)ref);
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            registrar.register(fixRange, (IntentionAction)new CreateEnumConstantFromUsageFix(refExpr), null);
            registrar.register((IntentionAction)new RenameWrongRefFix(refExpr));
            if (!ref.isQualified()) {
                registrar.register(fixRange, (IntentionAction)new BringVariableIntoScopeFix(refExpr), null);
            }
            DefaultQuickFixProvider.registerPriorityActions(registrar, fixRange, refExpr);
        }
        registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.INTERFACE));
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)ref)) {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ENUM));
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ANNOTATION));
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiNewExpression.class, PsiMethod.class});
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiExpressionList.class);
        if (!(!(parent instanceof PsiNewExpression) || ref.getParent() instanceof PsiTypeElement || expressionList != null && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expressionList, (boolean)false))) {
            registrar.register((IntentionAction)new CreateClassFromNewFix((PsiNewExpression)parent));
            registrar.register((IntentionAction)new CreateInnerClassFromNewFix((PsiNewExpression)parent));
        } else {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.CLASS));
            registrar.register((IntentionAction)new CreateInnerClassFromUsageFix(ref, CreateClassKind.CLASS));
        }
    }

    private static void registerPriorityActions(@NotNull QuickFixActionRegistrar registrar, @NotNull TextRange fixRange, @NotNull PsiReferenceExpression refExpr) {
        VariableKind kind;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider", "registerPriorityActions"));
        }
        if (fixRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixRange", "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider", "registerPriorityActions"));
        }
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider", "registerPriorityActions"));
        }
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)refExpr.getProject());
        EnumMap<VariableKind, CreateVarFromUsageFix> map = new EnumMap<VariableKind, CreateVarFromUsageFix>(VariableKind.class);
        map.put(VariableKind.FIELD, new CreateFieldFromUsageFix(refExpr));
        map.put(VariableKind.STATIC_FINAL_FIELD, new CreateConstantFieldFromUsageFix(refExpr));
        if (!refExpr.isQualified()) {
            map.put(VariableKind.LOCAL_VARIABLE, new CreateLocalFromUsageFix(refExpr));
            map.put(VariableKind.PARAMETER, new CreateParameterFromUsageFix(refExpr));
        }
        if (map.containsKey(kind = DefaultQuickFixProvider.getKind(styleManager, refExpr))) {
            map.put(kind, (CreateVarFromUsageFix)PriorityIntentionActionWrapper.highPriority((IntentionAction)((IntentionAction)map.get(kind))));
        }
        for (IntentionAction action : map.values()) {
            registrar.register(fixRange, action, null);
        }
    }

    @Nullable
    private static VariableKind getKind(@NotNull JavaCodeStyleManager styleManager, @NotNull PsiReferenceExpression refExpr) {
        if (styleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleManager", "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider", "getKind"));
        }
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider", "getKind"));
        }
        String reference = refExpr.getText();
        if (reference.toUpperCase().equals(reference)) {
            return VariableKind.STATIC_FINAL_FIELD;
        }
        for (VariableKind kind : VariableKind.values()) {
            String prefix = styleManager.getPrefixByVariableKind(kind);
            String suffix = styleManager.getSuffixByVariableKind(kind);
            if (prefix.isEmpty() && suffix.isEmpty() || !reference.startsWith(prefix) || !reference.endsWith(suffix)) continue;
            return kind;
        }
        if (StringUtil.isCapitalized((String)reference)) {
            return null;
        }
        return VariableKind.LOCAL_VARIABLE;
    }

    @Override
    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider", "getReferenceClass"));
        }
        return PsiJavaCodeReferenceElement.class;
    }
}

