/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaTypeProvider
extends ExpressionTypeProvider<PsiExpression> {
    @NotNull
    public String getInformationHint(@NotNull PsiExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/hint/JavaTypeProvider", "getInformationHint"));
        }
        PsiType type = element.getType();
        String text = type == null ? "<unknown>" : type.getCanonicalText();
        String string = StringUtil.escapeXml((String)text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/JavaTypeProvider", "getInformationHint"));
        }
        return string;
    }

    @NotNull
    public String getErrorHint() {
        if ("No expression found" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/JavaTypeProvider", "getErrorHint"));
        }
        return "No expression found";
    }

    @NotNull
    public List<PsiExpression> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/codeInsight/hint/JavaTypeProvider", "getExpressionsAt"));
        }
        List list = SyntaxTraverser.psiTraverser().parents((Object)elementAt).filter(PsiExpression.class).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/JavaTypeProvider", "getExpressionsAt"));
        }
        return list;
    }
}

