/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JavaGotoSuperHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "invoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
        int offset = editor.getCaretModel().getOffset();
        PsiElement[] superElements = this.findSuperElements(file, offset);
        if (superElements.length == 0) {
            return;
        }
        if (superElements.length == 1) {
            PsiElement superElement = superElements[0].getNavigationElement();
            PsiFile containingFile = superElement.getContainingFile();
            if (containingFile == null) {
                return;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, superElement.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        } else if (superElements[0] instanceof PsiMethod) {
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])((PsiMethod[])superElements));
            PsiElementListNavigator.openTargets(editor, (NavigatablePsiElement[])((PsiMethod[])superElements), CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]), CodeInsightBundle.message((String)"goto.super.method.findUsages.title", (Object[])new Object[]{((PsiMethod)superElements[0]).getName()}), (ListCellRenderer)new MethodCellRenderer(showMethodNames));
        } else {
            NavigationUtil.getPsiElementPopup(superElements, CodeInsightBundle.message((String)"goto.super.class.chooser.title", (Object[])new Object[0])).showInBestPositionFor(editor);
        }
    }

    @NotNull
    private PsiElement[] findSuperElements(@NotNull PsiFile file, int offset) {
        PsiMethod interfaceMethod;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "findSuperElements"));
        }
        PsiElement element = this.getElement(file, offset);
        if (element == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "findSuperElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiFunctionalExpression.class, PsiMember.class});
        if (psiElement instanceof PsiFunctionalExpression && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)psiElement)) != null) {
            PsiElement[] psiElementArray = (PsiElement[])ArrayUtil.prepend((Object)interfaceMethod, (Object[])interfaceMethod.findSuperMethods(false));
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "findSuperElements"));
            }
            return psiElementArray;
        }
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "findSuperElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = FindSuperElementsHelper.findSuperElements((PsiElement)parent);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "findSuperElements"));
        }
        return psiElementArray;
    }

    protected PsiElement getElement(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "getElement"));
        }
        return file.findElementAt(offset);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

