/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.actions.GotoDeclarationAction");

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        GotoDeclarationAction gotoDeclarationAction = this;
        if (gotoDeclarationAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "getHandler"));
        }
        return gotoDeclarationAction;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DumbService.getInstance((Project)project).setAlternativeResolveEnabled(true);
        try {
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] elements = GotoDeclarationAction.findAllTargetElements(project, editor, offset);
            FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.declaration");
            if (elements.length != 1) {
                PsiNameIdentifierOwner element;
                if (elements.length == 0 && GotoDeclarationAction.suggestCandidates(TargetElementUtil.findReference(editor, offset)).isEmpty() && (element = GotoDeclarationAction.findElementToShowUsagesOf(editor, editor.getCaretModel().getOffset())) != null) {
                    ShowUsagesAction showUsages = (ShowUsagesAction)ActionManager.getInstance().getAction("ShowUsages");
                    RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
                    showUsages.startFindUsages((PsiElement)element, popupPosition, editor, 100);
                    return;
                }
                GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, elements);
                return;
            }
            PsiElement element = elements[0];
            PsiElement navElement = element.getNavigationElement();
            navElement = TargetElementUtil.getInstance().getGotoDeclarationTarget(element, navElement);
            if (navElement != null) {
                GotoDeclarationAction.gotoTargetElement(navElement);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available here during index update");
        }
        finally {
            DumbService.getInstance((Project)project).setAlternativeResolveEnabled(false);
        }
    }

    public static PsiNameIdentifierOwner findElementToShowUsagesOf(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "findElementToShowUsagesOf"));
        }
        PsiElement elementAt = TargetElementUtil.getInstance().findTargetElement(editor, 2, offset);
        if (elementAt instanceof PsiNameIdentifierOwner) {
            return (PsiNameIdentifierOwner)elementAt;
        }
        return null;
    }

    private static void chooseAmbiguousTarget(Editor editor, int offset, PsiElement[] elements) {
        PsiElementProcessor<PsiElement> navigateProcessor = new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction$1", "execute"));
                }
                GotoDeclarationAction.gotoTargetElement(element);
                return true;
            }
        };
        boolean found = GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), elements);
        if (!found) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find declaration to go to");
        }
    }

    private static void gotoTargetElement(PsiElement element) {
        Navigatable navigatable;
        Navigatable navigatable2 = navigatable = element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)element);
        if (navigatable != null && navigatable.canNavigate()) {
            navigatable.navigate(true);
        }
    }

    public static boolean chooseAmbiguousTarget(@NotNull Editor editor, int offset, @NotNull PsiElementProcessor<PsiElement> processor, @NotNull String titlePattern, @Nullable PsiElement[] elements) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "chooseAmbiguousTarget"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "chooseAmbiguousTarget"));
        }
        if (titlePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titlePattern", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "chooseAmbiguousTarget"));
        }
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            return false;
        }
        PsiReference reference = TargetElementUtil.findReference(editor, offset);
        if (elements == null || elements.length == 0) {
            Collection<PsiElement> candidates = GotoDeclarationAction.suggestCandidates(reference);
            elements = PsiUtilCore.toPsiElementArray(candidates);
        }
        if (elements.length == 1) {
            PsiElement element = elements[0];
            LOG.assertTrue(element != null);
            processor.execute(element);
            return true;
        }
        if (elements.length > 1) {
            String title;
            if (reference == null) {
                title = titlePattern;
            } else {
                TextRange range = reference.getRangeInElement();
                String elementText = reference.getElement().getText();
                LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= elementText.length(), (Object)(Arrays.toString(elements) + ";" + reference));
                String refText = range.substring(elementText);
                title = MessageFormat.format(titlePattern, refText);
            }
            NavigationUtil.getPsiElementPopup((PsiElement[])elements, (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)title, processor).showInBestPositionFor(editor);
            return true;
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> suggestCandidates(@Nullable PsiReference reference) {
        if (reference == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "suggestCandidates"));
            }
            return list;
        }
        Collection<PsiElement> collection = TargetElementUtil.getInstance().getTargetCandidates(reference);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "suggestCandidates"));
        }
        return collection;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static PsiElement findTargetElement(Project project, Editor editor, int offset) {
        PsiElement[] targets = GotoDeclarationAction.findAllTargetElements(project, editor, offset);
        return targets.length == 1 ? targets[0] : null;
    }

    @NotNull
    public static PsiElement[] findAllTargetElements(Project project, Editor editor, int offset) {
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "findAllTargetElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] targets = GotoDeclarationAction.findTargetElementsNoVS(project, editor, offset, true);
        PsiElement[] psiElementArray = targets != null ? targets : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction", "findAllTargetElements"));
        }
        return psiElementArray;
    }

    @Nullable
    public static PsiElement[] findTargetElementsNoVS(Project project, Editor editor, int offset, boolean lookupAccepted) {
        PsiElement element;
        PsiFile decompiled;
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        if (file instanceof PsiCompiledFile && (decompiled = ((PsiCompiledFile)file).getDecompiledPsiFile()) != null) {
            file = decompiled;
        }
        PsiElement elementAt = file.findElementAt(TargetElementUtil.adjustOffset(file, document, offset));
        for (GotoDeclarationHandler handler : (GotoDeclarationHandler[])Extensions.getExtensions(GotoDeclarationHandler.EP_NAME)) {
            try {
                PsiElement[] result = handler.getGotoDeclarationTargets(elementAt, offset, editor);
                if (result == null || result.length <= 0) continue;
                for (PsiElement element2 : result) {
                    if (element2 != null) continue;
                    LOG.error("Null target element is returned by " + handler.getClass().getName());
                    return null;
                }
                return result;
            }
            catch (AbstractMethodError e) {
                LOG.error((Throwable)new ExtensionException(handler.getClass()));
            }
        }
        int flags = TargetElementUtil.getInstance().getAllAccepted() & 0xFFFFFFFD;
        if (!lookupAccepted) {
            flags &= 0xFFFFFFF7;
        }
        if ((element = TargetElementUtil.getInstance().findTargetElement(editor, flags, offset)) != null) {
            return new PsiElement[]{element};
        }
        if (editor instanceof EditorWindow) {
            EditorWindow window = (EditorWindow)editor;
            return GotoDeclarationAction.findTargetElementsNoVS(project, window.getDelegate(), window.getDocument().injectedToHost(offset), lookupAccepted);
        }
        return null;
    }

    @Override
    public void update(AnActionEvent event) {
        Component component;
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent && (component = inputEvent.getComponent()) != null) {
            LogicalPosition pos;
            Point point = ((MouseEvent)inputEvent).getPoint();
            Component componentAt = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
            Editor editor = this.getBaseEditor(event.getDataContext(), event.getProject());
            if (componentAt instanceof EditorGutterComponentEx) {
                event.getPresentation().setEnabled(false);
                return;
            }
            if (editor != null && componentAt == editor.getContentComponent() && EditorUtil.inVirtualSpace(editor, pos = editor.xyToLogicalPosition(SwingUtilities.convertPoint(component, point, componentAt)))) {
                event.getPresentation().setEnabled(false);
                return;
            }
        }
        for (GotoDeclarationHandler handler : (GotoDeclarationHandler[])Extensions.getExtensions(GotoDeclarationHandler.EP_NAME)) {
            try {
                String text = handler.getActionText(event.getDataContext());
                if (text == null) continue;
                Presentation presentation = event.getPresentation();
                presentation.setText(text);
                break;
            }
            catch (AbstractMethodError e) {
                LOG.error(handler.toString(), (Throwable)e);
            }
        }
        super.update(event);
    }
}

