/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

class SequentialCleanupTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance(SequentialCleanupTask.class);
    private final Project myProject;
    private final LinkedHashMap<PsiFile, List<HighlightInfo>> myResults;
    private Iterator<PsiFile> myFileIterator;
    private final SequentialModalProgressTask myProgressTask;
    private int myCount = 0;

    public SequentialCleanupTask(Project project, LinkedHashMap<PsiFile, List<HighlightInfo>> results, SequentialModalProgressTask task) {
        this.myProject = project;
        this.myResults = results;
        this.myProgressTask = task;
        this.myFileIterator = this.myResults.keySet().iterator();
    }

    public void prepare() {
    }

    public boolean isDone() {
        return this.myFileIterator == null || !this.myFileIterator.hasNext();
    }

    public boolean iteration() {
        ProgressIndicator indicator = this.myProgressTask.getIndicator();
        if (indicator != null) {
            indicator.setFraction((double)this.myCount++ / (double)this.myResults.size());
        }
        PsiFile file = this.myFileIterator.next();
        List<HighlightInfo> infos = this.myResults.get(file);
        Collections.reverse(infos);
        for (HighlightInfo info : infos) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> actionRange : info.quickFixActionRanges) {
                try {
                    ((HighlightInfo.IntentionActionDescriptor)actionRange.getFirst()).getAction().invoke(this.myProject, null, file);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return true;
    }

    public void stop() {
        this.myFileIterator = null;
    }
}

