/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class DefaultDebugEnvironment
implements DebugEnvironment {
    private final GlobalSearchScope mySearchScope;
    private final RemoteConnection myRemoteConnection;
    private final boolean myPollConnection;
    private final ExecutionEnvironment environment;
    private final RunProfileState state;

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/DefaultDebugEnvironment", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/DefaultDebugEnvironment", "<init>"));
        }
        this.environment = environment;
        this.state = state;
        this.myRemoteConnection = remoteConnection;
        this.myPollConnection = pollConnection;
        this.mySearchScope = SearchScopeProvider.createSearchScope((Project)environment.getProject(), (RunProfile)environment.getRunProfile());
    }

    @Override
    public ExecutionResult createExecutionResult() throws ExecutionException {
        return this.state.execute(this.environment.getExecutor(), this.environment.getRunner());
    }

    @Override
    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @Override
    public boolean isRemote() {
        return this.state instanceof RemoteState;
    }

    @Override
    public RemoteConnection getRemoteConnection() {
        return this.myRemoteConnection;
    }

    @Override
    public boolean isPollConnection() {
        return this.myPollConnection;
    }

    @Override
    public String getSessionName() {
        return this.environment.getRunProfile().getName();
    }
}

