/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;

public class ResumeThreadAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNode = ResumeThreadAction.getSelectedNodes(e.getDataContext());
        DebuggerContextImpl debuggerContext = ResumeThreadAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        for (final DebuggerTreeNodeImpl debuggerTreeNode : selectedNode) {
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)debuggerTreeNode.getDescriptor();
            if (!threadDescriptor.isSuspended()) continue;
            final ThreadReferenceProxyImpl thread = threadDescriptor.getThreadReference();
            debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContext.getSuspendContext()){

                @Override
                public void contextAction() throws Exception {
                    debugProcess.createResumeThreadCommand(this.getSuspendContext(), thread).run();
                    debuggerTreeNode.calcValue();
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNodes = ResumeThreadAction.getSelectedNodes(e.getDataContext());
        boolean visible = false;
        boolean enabled = false;
        String text = DebuggerBundle.message((String)"action.resume.thread.text.resume", (Object[])new Object[0]);
        if (selectedNodes != null && selectedNodes.length > 0) {
            visible = true;
            enabled = true;
            for (DebuggerTreeNodeImpl selectedNode : selectedNodes) {
                NodeDescriptorImpl threadDescriptor = selectedNode.getDescriptor();
                if (threadDescriptor instanceof ThreadDescriptorImpl && ((ThreadDescriptorImpl)threadDescriptor).isSuspended()) continue;
                visible = false;
                break;
            }
        }
        Presentation presentation = e.getPresentation();
        presentation.setText(text);
        presentation.setVisible(visible);
        presentation.setEnabled(enabled);
    }
}

