/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSourcePositionProvider
extends SourcePositionProvider {
    @Override
    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "computeSourcePosition"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "computeSourcePosition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "computeSourcePosition"));
        }
        StackFrameProxyImpl frame = context.getFrameProxy();
        if (frame == null) {
            return null;
        }
        if (descriptor instanceof FieldDescriptor) {
            return this.getSourcePositionForField((FieldDescriptor)descriptor, project, context, nearest);
        }
        if (descriptor instanceof LocalVariableDescriptor) {
            return this.getSourcePositionForLocalVariable((LocalVariableDescriptor)descriptor, project, context, nearest);
        }
        return null;
    }

    @Nullable
    protected SourcePosition getSourcePositionForField(@NotNull FieldDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        DebugProcessImpl debugProcess;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "getSourcePositionForField"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "getSourcePositionForField"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "getSourcePositionForField"));
        }
        ReferenceType type = descriptor.getField().declaringType();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        String fieldName = descriptor.getField().name();
        if (fieldName.startsWith("val$")) {
            String varName = fieldName.substring(fieldName.lastIndexOf(36) + 1);
            PsiElement element = PositionUtil.getContextElement((StackFrameContext)context);
            if (element == null) {
                return null;
            }
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null) {
                return null;
            }
            PsiElement navigationElement = aClass.getNavigationElement();
            if (!(navigationElement instanceof PsiClass)) {
                return null;
            }
            aClass = (PsiClass)navigationElement;
            PsiVariable psiVariable = facade.getResolveHelper().resolveReferencedVariable(varName, (PsiElement)aClass);
            if (psiVariable == null) {
                return null;
            }
            if (nearest) {
                return DebuggerContextUtil.findNearest(context, (PsiElement)psiVariable, aClass.getContainingFile());
            }
            return SourcePosition.createFromElement((PsiElement)psiVariable);
        }
        DebuggerSession session = context.getDebuggerSession();
        GlobalSearchScope scope = session != null ? session.getSearchScope() : GlobalSearchScope.allScope((Project)project);
        PsiClass aClass = facade.findClass(type.name().replace('$', '.'), scope);
        if (aClass == null && (debugProcess = context.getDebugProcess()) != null) {
            try {
                List<Location> locations = type.allLineLocations();
                if (!locations.isEmpty()) {
                    Location lastLocation = locations.get(locations.size() - 1);
                    SourcePosition position = debugProcess.getPositionManager().getSourcePosition(lastLocation);
                    aClass = JVMNameUtil.getClassAt(position);
                }
            }
            catch (AbsentInformationException absentInformationException) {
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                // empty catch block
            }
        }
        if (aClass != null) {
            PsiField field = aClass.findFieldByName(fieldName, false);
            if (field == null) {
                return null;
            }
            if (nearest) {
                return DebuggerContextUtil.findNearest(context, field.getNavigationElement(), aClass.getContainingFile());
            }
            return SourcePosition.createFromElement((PsiElement)field);
        }
        return null;
    }

    @Nullable
    protected SourcePosition getSourcePositionForLocalVariable(@NotNull LocalVariableDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "getSourcePositionForLocalVariable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "getSourcePositionForLocalVariable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/engine/DefaultSourcePositionProvider", "getSourcePositionForLocalVariable"));
        }
        PsiElement place = PositionUtil.getContextElement((StackFrameContext)context);
        if (place == null) {
            return null;
        }
        PsiVariable psiVariable = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(descriptor.getName(), place);
        if (psiVariable == null) {
            return null;
        }
        PsiFile containingFile = psiVariable.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (nearest) {
            return DebuggerContextUtil.findNearest(context, (PsiElement)psiVariable, containingFile);
        }
        return SourcePosition.createFromElement((PsiElement)psiVariable);
    }
}

