/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import java.io.OutputStream;

public class RemoteDebugProcessHandler
extends ProcessHandler {
    private final Project myProject;

    public RemoteDebugProcessHandler(Project project) {
        this.myProject = project;
    }

    public void startNotify() {
        final DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        DebugProcessAdapter listener = new DebugProcessAdapter(){

            public void processDetached(DebugProcess process, boolean closedByUser) {
                debugProcess.removeDebugProcessListener((DebugProcessListener)this);
                RemoteDebugProcessHandler.this.notifyProcessDetached();
            }
        };
        debugProcess.addDebugProcessListener((DebugProcessListener)listener);
        try {
            super.startNotify();
        }
        finally {
            if (debugProcess.isDetached()) {
                debugProcess.removeDebugProcessListener((DebugProcessListener)listener);
                this.notifyProcessDetached();
            }
        }
    }

    protected void destroyProcessImpl() {
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(true);
        }
    }

    protected void detachProcessImpl() {
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(false);
        }
    }

    public boolean detachIsDefault() {
        return true;
    }

    public OutputStream getProcessInput() {
        return null;
    }
}

