/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.NameMapper;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.apiAdapters.TransportServiceWrapper;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.GetJPDADialog;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class DebuggerManagerImpl
extends DebuggerManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerManagerImpl");
    private final Project myProject;
    private final HashMap<ProcessHandler, DebuggerSession> mySessions = new HashMap();
    private final BreakpointManager myBreakpointManager;
    private final List<NameMapper> myNameMappers = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Function<DebugProcess, PositionManager>> myCustomPositionManagerFactories = new ArrayList<Function<DebugProcess, PositionManager>>();
    private final EventDispatcher<DebuggerManagerListener> myDispatcher = EventDispatcher.create(DebuggerManagerListener.class);
    private final MyDebuggerStateManager myDebuggerStateManager = new MyDebuggerStateManager();
    private final DebuggerContextListener mySessionListener = new DebuggerContextListener(){

        @Override
        public void changeEvent(DebuggerContextImpl newContext, int event) {
            DebuggerSession session = newContext.getDebuggerSession();
            if (event == 6 && DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession != session) {
                DebuggerManagerImpl.this.myDebuggerStateManager.setState(newContext, session != null ? session.getState() : 6, event, null);
                return;
            }
            if (DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession == session) {
                DebuggerManagerImpl.this.myDebuggerStateManager.fireStateChanged(newContext, event);
            }
            if (event == 0) {
                ((DebuggerManagerListener)DebuggerManagerImpl.this.myDispatcher.getMulticaster()).sessionAttached(session);
            } else if (event == 1) {
                ((DebuggerManagerListener)DebuggerManagerImpl.this.myDispatcher.getMulticaster()).sessionDetached(session);
            } else if (event == 10) {
                DebuggerManagerImpl.this.dispose(session);
                if (DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession == session) {
                    DebuggerManagerImpl.this.myDebuggerStateManager.setState(DebuggerContextImpl.EMPTY_CONTEXT, 6, 10, null);
                }
            }
        }
    };
    @NonNls
    private static final String DEBUG_KEY_NAME = "idea.xdebug.key";

    public void addClassNameMapper(NameMapper mapper) {
        this.myNameMappers.add(mapper);
    }

    public void removeClassNameMapper(NameMapper mapper) {
        this.myNameMappers.remove(mapper);
    }

    public String getVMClassQualifiedName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/debugger/impl/DebuggerManagerImpl", "getVMClassQualifiedName"));
        }
        for (NameMapper nameMapper : this.myNameMappers) {
            String qName = nameMapper.getQualifiedName(aClass);
            if (qName == null) continue;
            return qName;
        }
        return aClass.getQualifiedName();
    }

    @Override
    public void addDebuggerManagerListener(DebuggerManagerListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeDebuggerManagerListener(DebuggerManagerListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public DebuggerManagerImpl(Project project, StartupManager startupManager, EditorColorsManager colorsManager) {
        this.myProject = project;
        this.myBreakpointManager = new BreakpointManager(this.myProject, startupManager, this);
        if (!project.isDefault()) {
            colorsManager.addEditorColorsListener(new EditorColorsListener(){

                public void globalSchemeChange(EditorColorsScheme scheme) {
                    DebuggerManagerImpl.this.getBreakpointManager().updateBreakpointsUI();
                }
            }, (Disposable)project);
        }
    }

    @Override
    public DebuggerSession getSession(DebugProcess process) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (DebuggerSession debuggerSession : this.getSessions()) {
            if (process != debuggerSession.getProcess()) continue;
            return debuggerSession;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DebuggerSession> getSessions() {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            Collection<DebuggerSession> values = this.mySessions.values();
            return values.isEmpty() ? Collections.emptyList() : new ArrayList<DebuggerSession>(values);
        }
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public void projectClosed() {
    }

    public void projectOpened() {
        this.myBreakpointManager.init();
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.myBreakpointManager.writeExternal(state);
        return state;
    }

    public void loadState(Element state) {
        this.myBreakpointManager.readExternal(state);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myBreakpointManager.writeExternal(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DebuggerSession attachVirtualMachine(@NotNull DebugEnvironment environment) throws ExecutionException {
        ExecutionResult executionResult;
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/impl/DebuggerManagerImpl", "attachVirtualMachine"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final DebugProcessEvents debugProcess = new DebugProcessEvents(this.myProject);
        debugProcess.addDebugProcessListener((DebugProcessListener)new DebugProcessAdapter(){

            public void processAttached(DebugProcess process) {
                process.removeDebugProcessListener((DebugProcessListener)this);
                for (Function factory : DebuggerManagerImpl.this.myCustomPositionManagerFactories) {
                    PositionManager positionManager = (PositionManager)factory.fun((Object)process);
                    if (positionManager == null) continue;
                    process.appendPositionManager(positionManager);
                }
                for (PositionManagerFactory factory : (PositionManagerFactory[])Extensions.getExtensions((ExtensionPointName)PositionManagerFactory.EP_NAME, (AreaInstance)DebuggerManagerImpl.this.myProject)) {
                    PositionManager manager = factory.createPositionManager((DebugProcess)debugProcess);
                    if (manager == null) continue;
                    process.appendPositionManager(manager);
                }
            }

            public void processDetached(DebugProcess process, boolean closedByUser) {
                debugProcess.removeDebugProcessListener((DebugProcessListener)this);
            }

            public void attachException(RunProfileState state, ExecutionException exception, RemoteConnection remoteConnection) {
                debugProcess.removeDebugProcessListener((DebugProcessListener)this);
            }
        });
        DebuggerSession session = new DebuggerSession(environment.getSessionName(), debugProcess);
        try {
            executionResult = session.attach(environment);
        }
        catch (ExecutionException e) {
            session.dispose();
            throw e;
        }
        if (executionResult == null) {
            return null;
        }
        session.getContextManager().addListener(this.mySessionListener);
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(session, session.getContextManager().getContext().getSuspendContext()), session.getState(), 8, null);
        ProcessHandler processHandler = executionResult.getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            this.mySessions.put(processHandler, session);
        }
        if (!(processHandler instanceof RemoteDebugProcessHandler)) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                    final DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(event.getProcessHandler());
                    if (debugProcess != null) {
                        debugProcess.stop(willBeDestroyed && !(event.getProcessHandler() instanceof KillableColoredProcessHandler));
                        if (!DebuggerManagerThreadImpl.isManagerThread()) {
                            if (SwingUtilities.isEventDispatchThread()) {
                                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                                        debugProcess.waitFor(10000L);
                                    }
                                }, "Waiting For Debugger Response", false, debugProcess.getProject());
                            } else {
                                debugProcess.waitFor(10000L);
                            }
                        }
                    }
                }
            });
        }
        ((DebuggerManagerListener)this.myDispatcher.getMulticaster()).sessionCreated(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugProcessImpl getDebugProcess(ProcessHandler processHandler) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            DebuggerSession session = this.mySessions.get(processHandler);
            return session != null ? session.getProcess() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DebuggerSession getDebugSession(ProcessHandler processHandler) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            return this.mySessions.get(processHandler);
        }
    }

    public void addDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener listener) {
        DebugProcessImpl debugProcess = this.getDebugProcess(processHandler);
        if (debugProcess != null) {
            debugProcess.addDebugProcessListener(listener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler);
                    if (debugProcess != null) {
                        debugProcess.addDebugProcessListener(listener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            });
        }
    }

    public void removeDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener listener) {
        DebugProcessImpl debugProcess = this.getDebugProcess(processHandler);
        if (debugProcess != null) {
            debugProcess.removeDebugProcessListener(listener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler);
                    if (debugProcess != null) {
                        debugProcess.removeDebugProcessListener(listener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            });
        }
    }

    public boolean isDebuggerManagerThread() {
        return DebuggerManagerThreadImpl.isManagerThread();
    }

    @NotNull
    public String getComponentName() {
        if ("DebuggerManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerManagerImpl", "getComponentName"));
        }
        return "DebuggerManager";
    }

    @Override
    public BreakpointManager getBreakpointManager() {
        return this.myBreakpointManager;
    }

    @Override
    public DebuggerContextImpl getContext() {
        return this.getContextManager().getContext();
    }

    @Override
    public DebuggerStateManager getContextManager() {
        return this.myDebuggerStateManager;
    }

    public void registerPositionManagerFactory(Function<DebugProcess, PositionManager> factory) {
        this.myCustomPositionManagerFactories.add(factory);
    }

    public void unregisterPositionManagerFactory(Function<DebugProcess, PositionManager> factory) {
        this.myCustomPositionManagerFactories.remove(factory);
    }

    private static boolean hasWhitespace(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static void checkTargetJPDAInstalled(JavaParameters parameters) throws ExecutionException {
        Sdk jdk = parameters.getJdk();
        if (jdk == null) {
            throw new ExecutionException(DebuggerBundle.message((String)"error.jdk.not.specified", (Object[])new Object[0]));
        }
        JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk);
        String versionString = jdk.getVersionString();
        if (version == JavaSdkVersion.JDK_1_0 || version == JavaSdkVersion.JDK_1_1) {
            throw new ExecutionException(DebuggerBundle.message((String)"error.unsupported.jdk.version", (Object[])new Object[]{versionString}));
        }
        if (SystemInfo.isWindows && version == JavaSdkVersion.JDK_1_2) {
            VirtualFile homeDirectory = jdk.getHomeDirectory();
            if (homeDirectory == null || !homeDirectory.isValid()) {
                throw new ExecutionException(DebuggerBundle.message((String)"error.invalid.jdk.home", (Object[])new Object[]{versionString}));
            }
            File dllFile = new File(homeDirectory.getPath().replace('/', File.separatorChar) + File.separator + "bin" + File.separator + "jdwp.dll");
            if (!dllFile.exists()) {
                GetJPDADialog dialog = new GetJPDADialog();
                dialog.show();
                throw new ExecutionException(DebuggerBundle.message((String)"error.debug.libraries.missing", (Object[])new Object[0]));
            }
        }
    }

    private static boolean shouldForceClassicVM(Sdk jdk) {
        if (SystemInfo.isMac) {
            return false;
        }
        if (jdk == null) {
            return false;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version != null) {
            if (version.compareTo("1.4") >= 0) {
                return false;
            }
            if (version.startsWith("1.2") && SystemInfo.isWindows) {
                return true;
            }
            if ((version = version + ".0").startsWith("1.3.0") && SystemInfo.isWindows) {
                return true;
            }
            if ((version.startsWith("1.3.1_07") || version.startsWith("1.3.1_08")) && SystemInfo.isWindows) {
                return false;
            }
        }
        return DebuggerSettings.getInstance().FORCE_CLASSIC_VM;
    }

    /*
     * Unable to fully structure code
     */
    public static RemoteConnection createDebugParameters(final JavaParameters parameters, boolean debuggerInServerMode, int transport, String debugPort, boolean checkValidity) throws ExecutionException {
        if (checkValidity) {
            DebuggerManagerImpl.checkTargetJPDAInstalled(parameters);
        }
        useSockets = transport == 0;
        address = "";
        if (StringUtil.isEmptyOrSpaces((String)debugPort)) {
            try {
                address = DebuggerUtils.getInstance().findAvailableDebugAddress(useSockets);
            }
            catch (ExecutionException e) {
                if (!checkValidity) ** GOTO lbl13
                throw e;
            }
        } else {
            address = debugPort;
        }
lbl13:
        // 3 sources

        transportService = TransportServiceWrapper.getTransportService(useSockets);
        debugAddress = debuggerInServerMode != false && useSockets != false ? "127.0.0.1:" + address : address;
        debuggeeRunProperties = "transport=" + transportService.transportId() + ",address=" + debugAddress;
        debuggeeRunProperties = debuggerInServerMode != false ? debuggeeRunProperties + ",suspend=y,server=n" : debuggeeRunProperties + ",suspend=n,server=y";
        if (DebuggerManagerImpl.hasWhitespace(debuggeeRunProperties)) {
            debuggeeRunProperties = "\"" + debuggeeRunProperties + "\"";
        }
        _debuggeeRunProperties = debuggeeRunProperties;
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                boolean needDebugKey;
                JavaSdkUtil.addRtJar(parameters.getClassPath());
                Sdk jdk = parameters.getJdk();
                boolean forceClassicVM = DebuggerManagerImpl.shouldForceClassicVM(jdk);
                boolean forceNoJIT = DebuggerManagerImpl.shouldForceNoJIT(jdk);
                String debugKey = System.getProperty(DebuggerManagerImpl.DEBUG_KEY_NAME, "-Xdebug");
                boolean bl = needDebugKey = DebuggerManagerImpl.shouldAddXdebugKey(jdk) || !"-Xdebug".equals(debugKey);
                if (forceClassicVM || forceNoJIT || needDebugKey || !DebuggerManagerImpl.isJVMTIAvailable(jdk)) {
                    parameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "-Xrunjdwp:" + _debuggeeRunProperties);
                } else {
                    parameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "");
                    parameters.getVMParametersList().replaceOrPrepend("-agentlib:jdwp=", "-agentlib:jdwp=" + _debuggeeRunProperties);
                }
                if (forceNoJIT) {
                    parameters.getVMParametersList().replaceOrPrepend("-Djava.compiler=", "-Djava.compiler=NONE");
                    parameters.getVMParametersList().replaceOrPrepend("-Xnoagent", "-Xnoagent");
                }
                if (needDebugKey) {
                    parameters.getVMParametersList().replaceOrPrepend(debugKey, debugKey);
                } else {
                    parameters.getVMParametersList().replaceOrPrepend("-Xdebug", "");
                }
                parameters.getVMParametersList().replaceOrPrepend("-classic", forceClassicVM ? "-classic" : "");
            }
        });
        return new RemoteConnection(useSockets, "127.0.0.1", address, debuggerInServerMode);
    }

    private static boolean shouldForceNoJIT(Sdk jdk) {
        String version;
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        return jdk != null && (version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION)) != null && (version.startsWith("1.2") || version.startsWith("1.3"));
    }

    private static boolean shouldAddXdebugKey(Sdk jdk) {
        if (jdk == null) {
            return true;
        }
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return version == null || version.startsWith("1.4") || version.startsWith("1.3") || version.startsWith("1.2") || version.startsWith("1.1") || version.startsWith("1.0");
    }

    private static boolean isJVMTIAvailable(Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            return false;
        }
        return !version.startsWith("1.4") && !version.startsWith("1.3") && !version.startsWith("1.2") && !version.startsWith("1.1") && !version.startsWith("1.0");
    }

    public static RemoteConnection createDebugParameters(JavaParameters parameters, GenericDebuggerRunnerSettings settings, boolean checkValidity) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(parameters, settings.LOCAL, settings.getTransport(), settings.getDebugPort(), checkValidity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(DebuggerSession session) {
        ProcessHandler processHandler = session.getProcess().getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            DebuggerSession removed = this.mySessions.remove(processHandler);
            LOG.assertTrue(removed != null);
            ((DebuggerManagerListener)this.myDispatcher.getMulticaster()).sessionRemoved(session);
        }
    }

    private static class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerSession myDebuggerSession;

        private MyDebuggerStateManager() {
        }

        @Override
        public DebuggerContextImpl getContext() {
            return this.myDebuggerSession == null ? DebuggerContextImpl.EMPTY_CONTEXT : this.myDebuggerSession.getContextManager().getContext();
        }

        @Override
        public void setState(DebuggerContextImpl context, int state, int event, String description) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myDebuggerSession = context.getDebuggerSession();
            if (this.myDebuggerSession != null) {
                this.myDebuggerSession.getContextManager().setState(context, state, event, description);
            } else {
                this.fireStateChanged(context, event);
            }
        }
    }
}

