/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.InternalException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LocalVariablesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.LocalVariablesUtil");
    private static final boolean ourInitializationOk;
    private static Class<?> ourSlotInfoClass;
    private static Constructor<?> slotInfoConstructor;
    private static Class<?> ourGetValuesClass;
    private static Method ourEnqueueMethod;
    private static Method ourWaitForReplyMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<DecompiledLocalVariable, Value> fetchValues(StackFrame frame, Collection<DecompiledLocalVariable> vars) throws Exception {
        Object ps;
        Object vmState;
        if (!ourInitializationOk) {
            return Collections.emptyMap();
        }
        Field frameIdField = frame.getClass().getDeclaredField("id");
        frameIdField.setAccessible(true);
        Object frameId = frameIdField.get(frame);
        VirtualMachine vm = frame.virtualMachine();
        Method stateMethod = vm.getClass().getDeclaredMethod("state", new Class[0]);
        stateMethod.setAccessible(true);
        Object slotInfoArray = LocalVariablesUtil.createSlotInfoArray(vars);
        Object object = vmState = stateMethod.invoke((Object)vm, new Object[0]);
        synchronized (object) {
            ps = ourEnqueueMethod.invoke(null, vm, frame.thread(), frameId, slotInfoArray);
        }
        try {
            Object reply = ourWaitForReplyMethod.invoke(null, vm, ps);
            Field valuesField = reply.getClass().getDeclaredField("values");
            valuesField.setAccessible(true);
            Value[] values = (Value[])valuesField.get(reply);
            if (vars.size() != values.length) {
                throw new InternalException("Wrong number of values returned from target VM");
            }
            HashMap<DecompiledLocalVariable, Value> map = new HashMap<DecompiledLocalVariable, Value>(vars.size());
            int idx = 0;
            for (DecompiledLocalVariable var : vars) {
                map.put(var, values[idx++]);
            }
            return map;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Exception) {
                throw (Exception)target;
            }
            throw e;
        }
    }

    private static Object createSlotInfoArray(Collection<DecompiledLocalVariable> vars) throws Exception {
        Object arrayInstance = Array.newInstance(ourSlotInfoClass, vars.size());
        int idx = 0;
        for (DecompiledLocalVariable var : vars) {
            Object info = slotInfoConstructor.newInstance(var.getSlot(), (byte)var.getSignature().charAt(0));
            Array.set(arrayInstance, idx++, info);
        }
        return arrayInstance;
    }

    private static Method findMethod(Class aClass, String methodName) throws NoSuchMethodException {
        for (Method method : aClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        throw new NoSuchMethodException(aClass.getName() + "." + methodName);
    }

    static {
        boolean success = false;
        try {
            ourSlotInfoClass = Class.forName("com.sun.tools.jdi.JDWP$StackFrame$GetValues$SlotInfo");
            slotInfoConstructor = ourSlotInfoClass.getDeclaredConstructor(Integer.TYPE, Byte.TYPE);
            slotInfoConstructor.setAccessible(true);
            ourGetValuesClass = Class.forName("com.sun.tools.jdi.JDWP$StackFrame$GetValues");
            ourEnqueueMethod = LocalVariablesUtil.findMethod(ourGetValuesClass, "enqueueCommand");
            ourEnqueueMethod.setAccessible(true);
            ourWaitForReplyMethod = LocalVariablesUtil.findMethod(ourGetValuesClass, "waitForReply");
            ourWaitForReplyMethod.setAccessible(true);
            success = true;
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        ourInitializationOk = success;
    }
}

