/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.DataBinding;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NonNls;

public abstract class FieldDataBinding
implements DataBinding {
    private final String myFieldName;

    protected FieldDataBinding(@NonNls String fieldName) {
        this.myFieldName = fieldName;
    }

    @Override
    public final void loadData(Object from) {
        try {
            Field field = this.findField(from);
            this.doLoadData(from, field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public final void saveData(Object to) {
        try {
            Field field = this.findField(to);
            this.doSaveData(to, field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isModified(Object obj) {
        try {
            Field field = this.findField(obj);
            return this.isModified(obj, field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected abstract void doLoadData(Object var1, Field var2) throws IllegalAccessException;

    protected abstract void doSaveData(Object var1, Field var2) throws IllegalAccessException;

    protected abstract boolean isModified(Object var1, Field var2) throws IllegalAccessException;

    private Field findField(Object from) {
        Class<Object> objectClass = Object.class;
        Class<?> aClass = from.getClass();
        while (!aClass.equals(objectClass)) {
            try {
                Field field = aClass.getDeclaredField(this.myFieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                aClass = aClass.getSuperclass();
            }
        }
        throw new RuntimeException(DebuggerBundle.message((String)"error.field.not.found.in.class", (Object[])new Object[]{this.myFieldName, from.getClass().getName()}));
    }
}

