/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Value;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public abstract class CompilingEvaluator
implements ExpressionEvaluator {
    @NotNull
    protected final PsiElement myPsiContext;
    @NotNull
    protected final ExtractLightMethodObjectHandler.ExtractedData myData;
    private static final String GEN_CLASS_NAME = "GeneratedEvaluationClass";

    public CompilingEvaluator(@NotNull PsiElement context, @NotNull ExtractLightMethodObjectHandler.ExtractedData data) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/ui/impl/watch/CompilingEvaluator", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/debugger/ui/impl/watch/CompilingEvaluator", "<init>"));
        }
        this.myPsiContext = context;
        this.myData = data;
    }

    public Value getValue() {
        return null;
    }

    public Modifier getModifier() {
        return null;
    }

    private TextWithImports getCallCode() {
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, this.myData.getGeneratedCallText());
    }

    public Value evaluate(final EvaluationContext evaluationContext) throws EvaluateException {
        DebugProcess process = evaluationContext.getDebugProcess();
        ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(evaluationContext, process);
        String version = ((VirtualMachineProxyImpl)process.getVirtualMachineProxy()).version();
        Collection<OutputFileObject> classes = this.compile(JdkVersionUtil.getVersion((String)version));
        this.defineClasses(classes, evaluationContext, process, classLoader);
        try {
            final Project project = (Project)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Project>(){

                public Project compute() {
                    return CompilingEvaluator.this.myPsiContext.getProject();
                }
            });
            ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project, new EvaluatingComputable<ExpressionEvaluator>(){

                @Override
                public ExpressionEvaluator compute() throws EvaluateException {
                    TextWithImports callCode = CompilingEvaluator.this.getCallCode();
                    PsiElement copyContext = CompilingEvaluator.this.myData.getAnchor();
                    CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(callCode, copyContext);
                    return factory.getEvaluatorBuilder().build((PsiElement)factory.createCodeFragment(callCode, copyContext, project), ContextUtil.getSourcePosition((StackFrameContext)evaluationContext));
                }
            });
            ((EvaluationContextImpl)evaluationContext).setClassLoader(classLoader);
            return evaluator.evaluate(evaluationContext);
        }
        catch (Exception e) {
            throw new EvaluateException("Error during generated code invocation " + e, (Throwable)e);
        }
    }

    private ClassType defineClasses(Collection<OutputFileObject> classes, EvaluationContext context, DebugProcess process, ClassLoaderReference classLoader) throws EvaluateException {
        for (OutputFileObject cls : classes) {
            BinaryContent content;
            if (!cls.getName().contains(GEN_CLASS_NAME) || (content = cls.getContent()) == null) continue;
            byte[] bytes = CompilingEvaluator.changeSuperToMagicAccessor(content.toByteArray());
            ClassLoadingUtils.defineClass(cls.getClassName(), bytes, context, process, classLoader);
        }
        return (ClassType)process.findClass(context, this.getGenClassQName(), classLoader);
    }

    private static byte[] changeSuperToMagicAccessor(byte[] bytes) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if ("java/lang/Object".equals(superName)) {
                    superName = "sun/reflect/MagicAccessorImpl";
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }
        };
        new ClassReader(bytes).accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    public static String getGeneratedClassName() {
        return GEN_CLASS_NAME;
    }

    protected String getGenClassQName() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return JVMNameUtil.getNonAnonymousClassName(CompilingEvaluator.this.myData.getGeneratedInnerClass());
            }
        });
    }

    @NotNull
    protected abstract Collection<OutputFileObject> compile(@Nullable JavaSdkVersion var1) throws EvaluateException;
}

