/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ThreadDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.sun.jdi.ObjectCollectedException;
import javax.swing.Icon;

public class ThreadDescriptorImpl
extends NodeDescriptorImpl
implements ThreadDescriptor {
    private final ThreadReferenceProxyImpl myThread;
    private String myName = null;
    private boolean myIsExpandable = true;
    private boolean myIsSuspended = false;
    private boolean myIsCurrent;
    private boolean myIsFrozen;
    private boolean myIsAtBreakpoint;
    private SuspendContextImpl mySuspendContext;

    public ThreadDescriptorImpl(ThreadReferenceProxyImpl thread) {
        this.myThread = thread;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReferenceProxyImpl thread = this.getThreadReference();
        try {
            this.myName = thread.name();
            ThreadGroupReferenceProxyImpl gr = this.getThreadReference().threadGroupProxy();
            String grname = gr != null ? gr.name() : null;
            String threadStatusText = DebuggerUtilsEx.getThreadStatusText(this.getThreadReference().status());
            if (grname != null && !"SYSTEM".equalsIgnoreCase(grname)) {
                return DebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{this.myName, thread.uniqueID(), threadStatusText, grname});
            }
            return DebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{this.myName, thread.uniqueID(), threadStatusText});
        }
        catch (ObjectCollectedException e) {
            return this.myName != null ? DebuggerBundle.message((String)"label.thread.node.thread.collected", (Object[])new Object[]{this.myName}) : "";
        }
    }

    @Override
    public ThreadReferenceProxyImpl getThreadReference() {
        return this.myThread;
    }

    public boolean isCurrent() {
        return this.myIsCurrent;
    }

    public boolean isFrozen() {
        return this.myIsFrozen;
    }

    @Override
    public boolean isExpandable() {
        return this.myIsExpandable;
    }

    @Override
    public void setContext(EvaluationContextImpl context) {
        ThreadReferenceProxyImpl thread = this.getThreadReference();
        SuspendManager suspendManager = context != null ? context.getDebugProcess().getSuspendManager() : null;
        SuspendContextImpl suspendContext = context != null ? context.getSuspendContext() : null;
        try {
            this.myIsSuspended = suspendManager != null ? suspendManager.isSuspended(thread) : thread.isSuspended();
        }
        catch (ObjectCollectedException e) {
            this.myIsSuspended = false;
        }
        this.myIsExpandable = this.calcExpandable(this.myIsSuspended);
        this.mySuspendContext = SuspendManagerUtil.getSuspendContextForThread(suspendContext, thread);
        boolean bl = suspendManager != null ? SuspendManagerUtil.findContextByThread(suspendManager, thread) != null : (this.myIsAtBreakpoint = thread.isAtBreakpoint());
        this.myIsCurrent = suspendContext != null ? suspendContext.getThread() == thread : false;
        this.myIsFrozen = suspendManager != null ? suspendManager.isFrozen(thread) : this.myIsSuspended;
    }

    private boolean calcExpandable(boolean isSuspended) {
        if (!isSuspended) {
            return false;
        }
        int status = this.getThreadReference().status();
        return status != -1 && status != 5 && status != 0;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }

    public boolean isAtBreakpoint() {
        return this.myIsAtBreakpoint;
    }

    public boolean isSuspended() {
        return this.myIsSuspended;
    }

    public Icon getIcon() {
        if (this.isCurrent()) {
            return AllIcons.Debugger.ThreadCurrent;
        }
        if (this.isFrozen()) {
            return AllIcons.Debugger.ThreadFrozen;
        }
        if (this.isAtBreakpoint()) {
            return AllIcons.Debugger.ThreadAtBreakpoint;
        }
        if (this.isSuspended()) {
            return AllIcons.Debugger.ThreadSuspended;
        }
        return AllIcons.Debugger.ThreadRunning;
    }
}

