/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public final class BasicRendererProperties
implements Cloneable,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.BasicRendererProperties");
    @NonNls
    private static final String NAME_OPTION = "NAME";
    private String myName;
    @NonNls
    private static final String ENABLED_OPTION = "ENABLED";
    private Boolean myEnabled;
    @NonNls
    private static final String CLASSNAME_OPTION = "QUALIFIED_NAME";
    private String myClassName;

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public boolean isEnabled() {
        return this.myEnabled != null ? this.myEnabled : false;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(String className) {
        this.myClassName = className;
    }

    public void readExternal(Element element) throws InvalidDataException {
        List options = element.getChildren("option");
        this.myName = null;
        this.myEnabled = null;
        this.myClassName = null;
        for (Element option : options) {
            String optionName = option.getAttributeValue("name");
            if (NAME_OPTION.equals(optionName)) {
                this.myName = option.getAttributeValue("value");
                continue;
            }
            if (ENABLED_OPTION.equals(optionName)) {
                String val = option.getAttributeValue("value");
                this.myEnabled = "true".equalsIgnoreCase(val);
                continue;
            }
            if (!CLASSNAME_OPTION.equals(optionName)) continue;
            this.myClassName = option.getAttributeValue("value");
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myName != null) {
            this.addOption(element, NAME_OPTION, this.myName);
        }
        if (this.myEnabled != null) {
            this.addOption(element, ENABLED_OPTION, this.myEnabled != false ? "true" : "false");
        }
        if (this.myClassName != null) {
            this.addOption(element, CLASSNAME_OPTION, this.myClassName);
        }
    }

    private void addOption(Element element, String optionName, String optionValue) {
        Element option = new Element("option");
        element.addContent(option);
        option.setAttribute("name", optionName);
        option.setAttribute("value", optionValue);
    }

    public BasicRendererProperties clone() {
        try {
            return (BasicRendererProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

