/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerformanceWatcher
implements ApplicationComponent {
    private Thread myThread;
    private int myLoopCounter;
    private int mySwingThreadCounter;
    private final Semaphore myShutdownSemaphore = new Semaphore(1);
    private ThreadMXBean myThreadMXBean;
    private final DateFormat myDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private File mySessionLogDir;
    private int myUnresponsiveDuration;
    private File myCurHangLogDir;
    private List<StackTraceElement> myStacktraceCommonPart;
    private int UNRESPONSIVE_THRESHOLD_SECONDS = 5;
    private int UNRESPONSIVE_INTERVAL_SECONDS = 5;

    public static PerformanceWatcher getInstance() {
        return (PerformanceWatcher)ServiceManager.getService(PerformanceWatcher.class);
    }

    @NotNull
    public String getComponentName() {
        if ("PerformanceWatcher" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/PerformanceWatcher", "getComponentName"));
        }
        return "PerformanceWatcher";
    }

    public void initComponent() {
        String interval;
        this.myThreadMXBean = ManagementFactory.getThreadMXBean();
        if (!this.shouldWatch()) {
            return;
        }
        String threshold = System.getProperty("performance.watcher.threshold");
        if (threshold != null) {
            try {
                this.UNRESPONSIVE_THRESHOLD_SECONDS = Integer.parseInt(threshold);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((interval = System.getProperty("performance.watcher.interval")) != null) {
            try {
                this.UNRESPONSIVE_INTERVAL_SECONDS = Integer.parseInt(interval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.UNRESPONSIVE_THRESHOLD_SECONDS == 0 || this.UNRESPONSIVE_INTERVAL_SECONDS == 0) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                PerformanceWatcher.deleteOldThreadDumps();
            }
        });
        this.myCurHangLogDir = this.mySessionLogDir = new File(PathManager.getLogPath() + "/threadDumps-" + this.myDateFormat.format(new Date()) + "-" + ApplicationInfo.getInstance().getBuild().asString());
        try {
            this.myShutdownSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                PerformanceWatcher.this.checkEDTResponsiveness();
            }
        }, "Performance watcher");
        this.myThread.setPriority(1);
        this.myThread.start();
    }

    private static void deleteOldThreadDumps() {
        Object[] dirs;
        File allLogsDir = new File(PathManager.getLogPath());
        if (allLogsDir.isDirectory() && (dirs = allLogsDir.list(new FilenameFilter(){

            @Override
            public boolean accept(@NotNull File dir, @NotNull String name) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/diagnostic/PerformanceWatcher$3", "accept"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diagnostic/PerformanceWatcher$3", "accept"));
                }
                return name.startsWith("threadDumps-");
            }
        })) != null) {
            Arrays.sort(dirs);
            for (int i = 0; i < dirs.length - 11; ++i) {
                FileUtil.delete((File)new File(allLogsDir, (String)dirs[i]));
            }
        }
    }

    public void disposeComponent() {
        if (!this.shouldWatch()) {
            return;
        }
        this.myShutdownSemaphore.release();
        try {
            this.myThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean shouldWatch() {
        return !ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment() && this.UNRESPONSIVE_INTERVAL_SECONDS != 0 && this.UNRESPONSIVE_THRESHOLD_SECONDS != 0;
    }

    private void checkEDTResponsiveness() {
        while (true) {
            try {
                if (this.myShutdownSemaphore.tryAcquire(this.UNRESPONSIVE_INTERVAL_SECONDS, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException e) {}
            break;
            if (this.mySwingThreadCounter != this.myLoopCounter) {
                this.myUnresponsiveDuration += this.UNRESPONSIVE_INTERVAL_SECONDS;
                if (this.myUnresponsiveDuration >= this.UNRESPONSIVE_THRESHOLD_SECONDS) {
                    if (this.myCurHangLogDir == this.mySessionLogDir) {
                        this.myCurHangLogDir = new File(this.mySessionLogDir, this.myDateFormat.format(new Date()));
                    }
                    this.dumpThreads("", false);
                }
            } else {
                if (this.myUnresponsiveDuration >= this.UNRESPONSIVE_THRESHOLD_SECONDS) {
                    if (this.myCurHangLogDir != this.mySessionLogDir && this.myCurHangLogDir.exists()) {
                        this.myCurHangLogDir.renameTo(new File(this.mySessionLogDir, this.getLogDirForHang()));
                    }
                    this.myUnresponsiveDuration = 0;
                    this.myCurHangLogDir = this.mySessionLogDir;
                    this.myStacktraceCommonPart = null;
                }
                this.myUnresponsiveDuration = 0;
            }
            ++this.myLoopCounter;
            SwingUtilities.invokeLater(new SwingThreadRunnable(this.myLoopCounter));
        }
    }

    private String getLogDirForHang() {
        StringBuilder name = new StringBuilder("freeze-" + this.myCurHangLogDir.getName());
        name.append("-").append(this.myUnresponsiveDuration);
        if (this.myStacktraceCommonPart != null && !this.myStacktraceCommonPart.isEmpty()) {
            StackTraceElement element = this.myStacktraceCommonPart.get(0);
            name.append("-").append(StringUtil.getShortName((String)element.getClassName())).append(".").append(element.getMethodName());
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File dumpThreads(@NotNull String pathPrefix, boolean millis) {
        if (pathPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPrefix", "com/intellij/diagnostic/PerformanceWatcher", "dumpThreads"));
        }
        if (!this.shouldWatch()) {
            return null;
        }
        String suffix = millis ? "-" + System.currentTimeMillis() : "";
        File file = new File(this.myCurHangLogDir, pathPrefix + "threadDump-" + this.myDateFormat.format(new Date()) + suffix + ".txt");
        File dir = file.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            try {
                Object[] edtStack = ThreadDumper.dumpThreadsToFile((ThreadMXBean)this.myThreadMXBean, (Writer)writer);
                if (edtStack != null) {
                    if (this.myStacktraceCommonPart == null) {
                        this.myStacktraceCommonPart = ContainerUtil.newArrayList((Object[])edtStack);
                    } else {
                        this.updateStacktraceCommonPart((StackTraceElement[])edtStack);
                    }
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static void dumpThreadsToConsole(String message) {
        OutputStreamWriter writer = new OutputStreamWriter(System.err);
        try {
            writer.write(message);
            writer.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ThreadDumper.dumpThreadsToFile((ThreadMXBean)PerformanceWatcher.getInstance().myThreadMXBean, (Writer)writer);
    }

    private void updateStacktraceCommonPart(StackTraceElement[] stackTraceElements) {
        for (int i = 0; i < this.myStacktraceCommonPart.size() && i < stackTraceElements.length; ++i) {
            StackTraceElement el2;
            StackTraceElement el1 = this.myStacktraceCommonPart.get(this.myStacktraceCommonPart.size() - i - 1);
            if (el1.equals(el2 = stackTraceElements[stackTraceElements.length - i - 1])) continue;
            this.myStacktraceCommonPart = this.myStacktraceCommonPart.subList(this.myStacktraceCommonPart.size() - i, this.myStacktraceCommonPart.size());
            break;
        }
    }

    private class SwingThreadRunnable
    implements Runnable {
        private final int myCount;

        private SwingThreadRunnable(int count) {
            this.myCount = count;
        }

        @Override
        public void run() {
            PerformanceWatcher.this.mySwingThreadCounter = this.myCount;
        }
    }
}

