/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideBinaryDiffViewer
extends TwosideDiffViewer<BinaryEditorHolder> {
    public static final Logger LOG = Logger.getInstance(TwosideBinaryDiffViewer.class);
    @NotNull
    private final StatusPanel myStatusPanel;

    public TwosideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        this.myStatusPanel = new StatusPanel();
        new MyFocusOppositePaneAction().setupAction(this.myPanel);
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        VirtualFile file2;
        VirtualFile file1;
        block11: {
            List contents;
            block10: {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
                }
                indicator.checkCanceled();
                contents = this.myRequest.getContents();
                if (contents.get(0) instanceof FileContent && contents.get(1) instanceof FileContent) break block10;
                Runnable runnable2 = this.applyNotification(null);
                if (runnable2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
                }
                return runnable2;
            }
            file1 = ((FileContent)contents.get(0)).getFile();
            file2 = ((FileContent)contents.get(1)).getFile();
            if (file1.isValid() && file2.isValid()) break block11;
            Runnable runnable3 = this.applyNotification(DiffNotifications.ERROR);
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        try {
            boolean equal = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    try {
                        byte[] bytes1 = file1.contentsToByteArray();
                        byte[] bytes2 = file2.contentsToByteArray();
                        return Arrays.equals(bytes1, bytes2);
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                        return false;
                    }
                }
            });
            runnable = this.applyNotification(equal ? DiffNotifications.EQUAL_CONTENTS : null);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = this.applyNotification(DiffNotifications.ERROR);
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
        }
        return runnable;
    }

    @NotNull
    private Runnable applyNotification(final @Nullable JComponent notification) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TwosideBinaryDiffViewer.this.clearDiffPresentation();
                if (notification != null) {
                    TwosideBinaryDiffViewer.this.myPanel.addNotification(notification);
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "applyNotification"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
    }

    @NotNull
    FileEditor getCurrentEditor() {
        FileEditor fileEditor = ((BinaryEditorHolder)this.getCurrentEditorHolder()).getEditor();
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "getCurrentEditor"));
        }
        return fileEditor;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "getStatusPanel"));
        }
        return statusPanel;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "canShowRequest"));
        }
        return TwosideDiffViewer.canShowRequest(context, request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
            }
            TwosideBinaryDiffViewer.this.setCurrentSide(TwosideBinaryDiffViewer.this.getCurrentSide().other());
            TwosideBinaryDiffViewer.this.myContext.requestFocus();
        }
    }
}

